/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.AdBreakStatus;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.VideoInfo;
import com.google.android.gms.cast.zzag;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzayd;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaStatus
extends zza {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    public static final Parcelable.Creator<MediaStatus> CREATOR = new zzag();
    private MediaInfo zzaqg;
    private long zzaqw;
    private int zzaqx;
    private double zzaqy;
    private int zzaqz;
    private int zzaqA;
    private long zzaqB;
    private long zzaqC;
    private double zzaqD;
    private boolean zzaqE;
    private long[] zzaqu;
    private int zzaqF;
    private int zzaqG;
    private String zzaoC;
    private JSONObject zzaoD;
    private int zzaqH;
    private ArrayList<MediaQueueItem> zzaqI = new ArrayList();
    private boolean zzaqJ;
    private AdBreakStatus zzaqK;
    private VideoInfo zzaqL;
    private final SparseArray<Integer> zzaqM = new SparseArray();

    MediaStatus(MediaInfo mediaInfo, long l, int n, double d, int n2, int n3, long l2, long l3, double d2, boolean bl, long[] lArray, int n4, int n5, String string2, int n6, List<MediaQueueItem> list, boolean bl2, AdBreakStatus adBreakStatus, VideoInfo videoInfo) {
        this.zzaqg = mediaInfo;
        this.zzaqw = l;
        this.zzaqx = n;
        this.zzaqy = d;
        this.zzaqz = n2;
        this.zzaqA = n3;
        this.zzaqB = l2;
        this.zzaqC = l3;
        this.zzaqD = d2;
        this.zzaqE = bl;
        this.zzaqu = lArray;
        this.zzaqF = n4;
        this.zzaqG = n5;
        this.zzaoC = string2;
        if (this.zzaoC != null) {
            try {
                this.zzaoD = new JSONObject(this.zzaoC);
            }
            catch (JSONException jSONException) {
                this.zzaoD = null;
                this.zzaoC = null;
            }
        } else {
            this.zzaoD = null;
        }
        this.zzaqH = n6;
        if (list != null && !list.isEmpty()) {
            this.zza(list.toArray(new MediaQueueItem[list.size()]));
        }
        this.zzaqJ = bl2;
        this.zzaqK = adBreakStatus;
        this.zzaqL = videoInfo;
    }

    public MediaStatus(JSONObject jSONObject) throws JSONException {
        this(null, 0L, 0, 0.0, 0, 0, 0L, 0L, 0.0, false, null, 0, 0, null, 0, null, false, null, null);
        this.zza(jSONObject, 0);
    }

    public final long zznk() {
        return this.zzaqw;
    }

    public int getPlayerState() {
        return this.zzaqz;
    }

    public int getIdleReason() {
        return this.zzaqA;
    }

    public double getPlaybackRate() {
        return this.zzaqy;
    }

    public MediaInfo getMediaInfo() {
        return this.zzaqg;
    }

    public long getStreamPosition() {
        return this.zzaqB;
    }

    public boolean isMediaCommandSupported(long l) {
        return (this.zzaqC & l) != 0L;
    }

    public double getStreamVolume() {
        return this.zzaqD;
    }

    public boolean isMute() {
        return this.zzaqE;
    }

    public long[] getActiveTrackIds() {
        return this.zzaqu;
    }

    public JSONObject getCustomData() {
        return this.zzaoD;
    }

    public int getCurrentItemId() {
        return this.zzaqx;
    }

    public int getLoadingItemId() {
        return this.zzaqF;
    }

    public int getPreloadedItemId() {
        return this.zzaqG;
    }

    public int getQueueRepeatMode() {
        return this.zzaqH;
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzaqI;
    }

    public int getQueueItemCount() {
        return this.zzaqI.size();
    }

    public MediaQueueItem getQueueItemById(int n) {
        return this.getItemById(n);
    }

    public MediaQueueItem getQueueItem(int n) {
        return this.getItemByIndex(n);
    }

    public boolean isPlayingAd() {
        return this.zzaqJ;
    }

    public final void zzV(boolean bl) {
        this.zzaqJ = bl;
    }

    public AdBreakStatus getAdBreakStatus() {
        return this.zzaqK;
    }

    public VideoInfo getVideoInfo() {
        return this.zzaqL;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        block75: {
            int n3;
            block73: {
                MediaQueueItem[] mediaQueueItemArray;
                int n4;
                JSONArray jSONArray;
                String string2;
                MediaStatus mediaStatus;
                block74: {
                    block72: {
                        int n5;
                        boolean bl;
                        int n6;
                        block71: {
                            int n7;
                            block70: {
                                int n8;
                                int n9;
                                int n10;
                                int n11;
                                long[] lArray;
                                boolean bl2;
                                block69: {
                                    block67: {
                                        int n12;
                                        block68: {
                                            block65: {
                                                block66: {
                                                    long l;
                                                    long l2;
                                                    double d;
                                                    n2 = 0;
                                                    long l3 = jSONObject.getLong("mediaSessionId");
                                                    if (l3 != this.zzaqw) {
                                                        this.zzaqw = l3;
                                                        n2 = 1;
                                                    }
                                                    if (jSONObject.has("playerState")) {
                                                        int n13 = 0;
                                                        String string3 = jSONObject.getString("playerState");
                                                        if (string3.equals("IDLE")) {
                                                            n13 = 1;
                                                        } else if (string3.equals("PLAYING")) {
                                                            n13 = 2;
                                                        } else if (string3.equals("PAUSED")) {
                                                            n13 = 3;
                                                        } else if (string3.equals("BUFFERING")) {
                                                            n13 = 4;
                                                        }
                                                        if (n13 != this.zzaqz) {
                                                            this.zzaqz = n13;
                                                            n2 |= 2;
                                                        }
                                                        if (n13 == 1 && jSONObject.has("idleReason")) {
                                                            int n14 = 0;
                                                            string3 = jSONObject.getString("idleReason");
                                                            if (string3.equals("CANCELLED")) {
                                                                n14 = 2;
                                                            } else if (string3.equals("INTERRUPTED")) {
                                                                n14 = 3;
                                                            } else if (string3.equals("FINISHED")) {
                                                                n14 = 1;
                                                            } else if (string3.equals("ERROR")) {
                                                                n14 = 4;
                                                            }
                                                            if (n14 != this.zzaqA) {
                                                                this.zzaqA = n14;
                                                                n2 |= 2;
                                                            }
                                                        }
                                                    }
                                                    if (jSONObject.has("playbackRate") && this.zzaqy != (d = jSONObject.getDouble("playbackRate"))) {
                                                        this.zzaqy = d;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = (long)(jSONObject.getDouble("currentTime") * 1000.0)) != this.zzaqB) {
                                                        this.zzaqB = l2;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzaqC) {
                                                        this.zzaqC = l;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("volume") && (n & 1) == 0) {
                                                        JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
                                                        double d2 = jSONObject2.getDouble("level");
                                                        if (d2 != this.zzaqD) {
                                                            this.zzaqD = d2;
                                                            n2 |= 2;
                                                        }
                                                        boolean bl3 = jSONObject2.getBoolean("muted");
                                                        n12 = bl3 ? 1 : 0;
                                                        if (bl3 != this.zzaqE) {
                                                            this.zzaqE = n12;
                                                            n2 |= 2;
                                                        }
                                                    }
                                                    bl2 = false;
                                                    lArray = null;
                                                    if (!jSONObject.has("activeTrackIds")) break block65;
                                                    JSONArray jSONArray2 = jSONObject.getJSONArray("activeTrackIds");
                                                    n12 = jSONArray2.length();
                                                    lArray = new long[n12];
                                                    for (n11 = 0; n11 < n12; ++n11) {
                                                        lArray[n11] = jSONArray2.getLong(n11);
                                                    }
                                                    if (this.zzaqu != null) break block66;
                                                    bl2 = true;
                                                    break block67;
                                                }
                                                if (this.zzaqu.length == n12) break block68;
                                                bl2 = true;
                                                break block67;
                                            }
                                            if (this.zzaqu != null) {
                                                bl2 = true;
                                            }
                                            break block69;
                                        }
                                        for (n11 = 0; n11 < n12; ++n11) {
                                            if (this.zzaqu[n11] == lArray[n11]) continue;
                                            bl2 = true;
                                            break;
                                        }
                                    }
                                    if (bl2) {
                                        this.zzaqu = lArray;
                                    }
                                }
                                if (bl2) {
                                    this.zzaqu = lArray;
                                    n2 |= 2;
                                }
                                if (jSONObject.has("customData")) {
                                    this.zzaoD = jSONObject.getJSONObject("customData");
                                    this.zzaoC = null;
                                    n2 |= 2;
                                }
                                if (jSONObject.has("media")) {
                                    JSONObject jSONObject3 = jSONObject.getJSONObject("media");
                                    MediaInfo mediaInfo = new MediaInfo(jSONObject3);
                                    if (this.zzaqg == null || this.zzaqg != null && !this.zzaqg.equals((Object)mediaInfo)) {
                                        this.zzaqg = mediaInfo;
                                        n2 |= 2;
                                    }
                                    if (jSONObject3.has("metadata")) {
                                        n2 |= 4;
                                    }
                                }
                                if (jSONObject.has("currentItemId") && this.zzaqx != (n10 = jSONObject.getInt("currentItemId"))) {
                                    this.zzaqx = n10;
                                    n2 |= 2;
                                }
                                if (this.zzaqG != (n9 = jSONObject.optInt("preloadedItemId", 0))) {
                                    this.zzaqG = n9;
                                    n2 |= 0x10;
                                }
                                if (this.zzaqF != (n8 = jSONObject.optInt("loadingItemId", 0))) {
                                    this.zzaqF = n8;
                                    n2 |= 2;
                                }
                                n6 = n11 = this.zzaqg == null ? -1 : this.zzaqg.getStreamType();
                                n3 = this.zzaqF;
                                n7 = this.zzaqA;
                                if (this.zzaqz == 1) break block70;
                                bl = false;
                                break block71;
                            }
                            switch (n7) {
                                case 1: 
                                case 3: {
                                    if (n3 == 0) break;
                                    bl = false;
                                    break block71;
                                }
                                case 2: {
                                    if (n6 != 2) break;
                                    bl = false;
                                    break block71;
                                }
                            }
                            bl = true;
                        }
                        if (bl) break block72;
                        JSONObject jSONObject4 = jSONObject;
                        mediaStatus = this;
                        n3 = 0;
                        if (jSONObject4.has("repeatMode")) {
                            n6 = mediaStatus.zzaqH;
                            string2 = jSONObject4.getString("repeatMode");
                            n5 = -1;
                            switch (string2.hashCode()) {
                                case 1645952171: {
                                    if (!string2.equals("REPEAT_OFF")) break;
                                    n5 = 0;
                                    break;
                                }
                                case 1645938909: {
                                    if (!string2.equals("REPEAT_ALL")) break;
                                    n5 = 1;
                                    break;
                                }
                                case -962896020: {
                                    if (!string2.equals("REPEAT_SINGLE")) break;
                                    n5 = 2;
                                    break;
                                }
                                case -1118317585: {
                                    if (!string2.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                                    n5 = 3;
                                    break;
                                }
                            }
                            switch (n5) {
                                case 0: {
                                    n6 = 0;
                                    break;
                                }
                                case 1: {
                                    n6 = 1;
                                    break;
                                }
                                case 2: {
                                    n6 = 2;
                                    break;
                                }
                                case 3: {
                                    n6 = 3;
                                    break;
                                }
                            }
                            if (mediaStatus.zzaqH != n6) {
                                mediaStatus.zzaqH = n6;
                                n3 = 1;
                            }
                        }
                        if (!jSONObject4.has("items")) break block73;
                        jSONArray = jSONObject4.getJSONArray("items");
                        n4 = jSONArray.length();
                        string2 = new SparseArray();
                        for (n5 = 0; n5 < n4; ++n5) {
                            string2.put(n5, (Object)jSONArray.getJSONObject(n5).getInt("itemId"));
                        }
                        mediaQueueItemArray = new MediaQueueItem[n4];
                        break block74;
                    }
                    this.zzaqx = 0;
                    this.zzaqF = 0;
                    this.zzaqG = 0;
                    if (!this.zzaqI.isEmpty()) {
                        MediaStatus mediaStatus2 = this;
                        this.zzaqH = 0;
                        mediaStatus2.zzaqI.clear();
                        mediaStatus2.zzaqM.clear();
                        n2 |= 8;
                    }
                    break block75;
                }
                for (int i = 0; i < n4; ++i) {
                    Integer n15 = (Integer)string2.get(i);
                    JSONObject jSONObject5 = jSONArray.getJSONObject(i);
                    MediaQueueItem mediaQueueItem = mediaStatus.getItemById(n15);
                    if (mediaQueueItem != null) {
                        n3 |= mediaQueueItem.zzm(jSONObject5);
                        mediaQueueItemArray[i] = mediaQueueItem;
                        if (i == mediaStatus.getIndexById(n15)) continue;
                        n3 = 1;
                        continue;
                    }
                    n3 = 1;
                    if (n15 == mediaStatus.zzaqx) {
                        mediaQueueItemArray[i] = new MediaQueueItem.Builder(mediaStatus.zzaqg).build();
                        mediaQueueItemArray[i].zzm(jSONObject5);
                        continue;
                    }
                    mediaQueueItemArray[i] = new MediaQueueItem(jSONObject5);
                }
                if (mediaStatus.zzaqI.size() != n4) {
                    n3 = 1;
                }
                mediaStatus.zza(mediaQueueItemArray);
            }
            if (n3 != 0) {
                n2 |= 8;
            }
        }
        AdBreakStatus adBreakStatus = AdBreakStatus.zzj(jSONObject.optJSONObject("breakStatus"));
        if (this.zzaqK == null && adBreakStatus != null || this.zzaqK != null && !this.zzaqK.equals((Object)adBreakStatus)) {
            boolean bl = adBreakStatus != null;
            this.zzaqJ = bl;
            this.zzaqK = adBreakStatus;
            n2 |= 0x20;
        }
        VideoInfo videoInfo = VideoInfo.zzn(jSONObject.optJSONObject("videoInfo"));
        if (this.zzaqL == null && videoInfo != null || this.zzaqL != null && !this.zzaqL.equals((Object)videoInfo)) {
            this.zzaqL = videoInfo;
            n2 |= 0x40;
        }
        if (jSONObject.has("breakInfo") && this.zzaqg != null) {
            this.zzaqg.zzk(jSONObject.getJSONObject("breakInfo"));
            n2 |= 2;
        }
        return n2;
    }

    public MediaQueueItem getItemById(int n) {
        Integer n2 = (Integer)this.zzaqM.get(n);
        if (n2 == null) {
            return null;
        }
        return this.zzaqI.get(n2);
    }

    public MediaQueueItem getItemByIndex(int n) {
        if (n < 0 || n >= this.zzaqI.size()) {
            return null;
        }
        return this.zzaqI.get(n);
    }

    public Integer getIndexById(int n) {
        return (Integer)this.zzaqM.get(n);
    }

    private final void zza(MediaQueueItem[] mediaQueueItemArray) {
        this.zzaqI.clear();
        this.zzaqM.clear();
        for (int i = 0; i < mediaQueueItemArray.length; ++i) {
            MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
            this.zzaqI.add(mediaQueueItem);
            this.zzaqM.put(mediaQueueItem.getItemId(), (Object)i);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaStatus)) {
            return false;
        }
        MediaStatus mediaStatus = (MediaStatus)((Object)object);
        if (this.zzaoD == null != (mediaStatus.zzaoD == null)) {
            return false;
        }
        if (this.zzaqw == mediaStatus.zzaqw && this.zzaqx == mediaStatus.zzaqx && this.zzaqy == mediaStatus.zzaqy && this.zzaqz == mediaStatus.zzaqz && this.zzaqA == mediaStatus.zzaqA && this.zzaqB == mediaStatus.zzaqB && this.zzaqD == mediaStatus.zzaqD && this.zzaqE == mediaStatus.zzaqE && this.zzaqF == mediaStatus.zzaqF && this.zzaqG == mediaStatus.zzaqG && this.zzaqH == mediaStatus.zzaqH && Arrays.equals(this.zzaqu, mediaStatus.zzaqu) && zzayd.zza(this.zzaqC, mediaStatus.zzaqC) && zzayd.zza(this.zzaqI, mediaStatus.zzaqI) && zzayd.zza(this.zzaqg, mediaStatus.zzaqg)) {
            MediaStatus mediaStatus2 = mediaStatus;
            MediaStatus mediaStatus3 = this;
            if ((mediaStatus3.zzaoD == null || mediaStatus2.zzaoD == null || zzo.zzc((Object)mediaStatus3.zzaoD, (Object)mediaStatus2.zzaoD)) && this.zzaqJ == mediaStatus.isPlayingAd()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaqg, this.zzaqw, this.zzaqx, this.zzaqy, this.zzaqz, this.zzaqA, this.zzaqB, this.zzaqC, this.zzaqD, this.zzaqE, Arrays.hashCode(this.zzaqu), this.zzaqF, this.zzaqG, String.valueOf(this.zzaoD), this.zzaqH, this.zzaqI, this.zzaqJ});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzaoC = this.zzaoD == null ? null : this.zzaoD.toString();
        Parcel parcel2 = parcel;
        MediaStatus mediaStatus = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)mediaStatus.getMediaInfo(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)mediaStatus.zzaqw);
        zzd.zzc((Parcel)parcel2, (int)4, (int)mediaStatus.getCurrentItemId());
        zzd.zza((Parcel)parcel2, (int)5, (double)mediaStatus.getPlaybackRate());
        zzd.zzc((Parcel)parcel2, (int)6, (int)mediaStatus.getPlayerState());
        zzd.zzc((Parcel)parcel2, (int)7, (int)mediaStatus.getIdleReason());
        zzd.zza((Parcel)parcel2, (int)8, (long)mediaStatus.getStreamPosition());
        zzd.zza((Parcel)parcel2, (int)9, (long)mediaStatus.zzaqC);
        zzd.zza((Parcel)parcel2, (int)10, (double)mediaStatus.getStreamVolume());
        zzd.zza((Parcel)parcel2, (int)11, (boolean)mediaStatus.isMute());
        zzd.zza((Parcel)parcel2, (int)12, (long[])mediaStatus.getActiveTrackIds(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)13, (int)mediaStatus.getLoadingItemId());
        zzd.zzc((Parcel)parcel2, (int)14, (int)mediaStatus.getPreloadedItemId());
        zzd.zza((Parcel)parcel2, (int)15, (String)mediaStatus.zzaoC, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)16, (int)mediaStatus.zzaqH);
        zzd.zzc((Parcel)parcel2, (int)17, mediaStatus.zzaqI, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)18, (boolean)mediaStatus.isPlayingAd());
        zzd.zza((Parcel)parcel2, (int)19, (Parcelable)mediaStatus.getAdBreakStatus(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)20, (Parcelable)mediaStatus.getVideoInfo(), (int)n, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public AdBreakInfo getCurrentAdBreak() {
        if (this.zzaqK == null || this.zzaqg == null) {
            return null;
        }
        String string2 = this.zzaqK.getBreakId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakInfo> list = this.zzaqg.getAdBreaks();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakInfo adBreakInfo : list) {
            if (!string2.equals(adBreakInfo.getId())) continue;
            return adBreakInfo;
        }
        return null;
    }

    public AdBreakClipInfo getCurrentAdBreakClip() {
        if (this.zzaqK == null || this.zzaqg == null) {
            return null;
        }
        String string2 = this.zzaqK.getBreakClipId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakClipInfo> list = this.zzaqg.getAdBreakClips();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakClipInfo adBreakClipInfo : list) {
            if (!string2.equals(adBreakClipInfo.getId())) continue;
            return adBreakClipInfo;
        }
        return null;
    }
}

