/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.zzah;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzayd;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack
extends zza
implements ReflectedParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    public static final Parcelable.Creator<MediaTrack> CREATOR = new zzah();
    private long zzakg;
    private int zzamr;
    private String zzapX;
    private String zzapZ;
    private String mName;
    private String zzaeT;
    private int zzaqN;
    private String zzaoC;
    private JSONObject zzaoD;

    MediaTrack(long l, int n, String string2, String string3, String string4, String string5, int n2, String string6) {
        this.zzakg = l;
        this.zzamr = n;
        this.zzapX = string2;
        this.zzapZ = string3;
        this.mName = string4;
        this.zzaeT = string5;
        this.zzaqN = n2;
        this.zzaoC = string6;
        if (this.zzaoC != null) {
            try {
                this.zzaoD = new JSONObject(this.zzaoC);
                return;
            }
            catch (JSONException jSONException) {
                this.zzaoD = null;
                this.zzaoC = null;
                return;
            }
        }
        this.zzaoD = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    MediaTrack(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2;
        block12: {
            block13: {
                String string2;
                block16: {
                    block15: {
                        block14: {
                            this(0L, 0, null, null, null, null, -1, null);
                            jSONObject2 = jSONObject;
                            MediaTrack mediaTrack = this;
                            this.zzakg = jSONObject2.getLong("trackId");
                            string2 = jSONObject2.getString("type");
                            if ("TEXT".equals(string2)) {
                                mediaTrack.zzamr = 1;
                            } else if ("AUDIO".equals(string2)) {
                                mediaTrack.zzamr = 2;
                            } else if ("VIDEO".equals(string2)) {
                                mediaTrack.zzamr = 3;
                            } else {
                                String string3;
                                String string4 = String.valueOf(string2);
                                if (string4.length() != 0) {
                                    string3 = "invalid type: ".concat(string4);
                                    throw new JSONException(string3);
                                }
                                string3 = new String("invalid type: ");
                                throw new JSONException(string3);
                            }
                            mediaTrack.zzapX = jSONObject2.optString("trackContentId", null);
                            mediaTrack.zzapZ = jSONObject2.optString("trackContentType", null);
                            mediaTrack.mName = jSONObject2.optString("name", null);
                            mediaTrack.zzaeT = jSONObject2.optString("language", null);
                            if (!jSONObject2.has("subtype")) break block13;
                            string2 = jSONObject2.getString("subtype");
                            if (!"SUBTITLES".equals(string2)) break block14;
                            mediaTrack.zzaqN = 1;
                            break block12;
                        }
                        if (!"CAPTIONS".equals(string2)) break block15;
                        mediaTrack.zzaqN = 2;
                        break block12;
                    }
                    if (!"DESCRIPTIONS".equals(string2)) break block16;
                    mediaTrack.zzaqN = 3;
                    break block12;
                }
                if ("CHAPTERS".equals(string2)) {
                    mediaTrack.zzaqN = 4;
                    break block12;
                } else if ("METADATA".equals(string2)) {
                    mediaTrack.zzaqN = 5;
                    break block12;
                } else {
                    String string5;
                    String string6 = String.valueOf(string2);
                    if (string6.length() != 0) {
                        string5 = "invalid subtype: ".concat(string6);
                        throw new JSONException(string5);
                    }
                    string5 = new String("invalid subtype: ");
                    throw new JSONException(string5);
                }
            }
            mediaTrack.zzaqN = 0;
        }
        mediaTrack.zzaoD = jSONObject2.optJSONObject("customData");
    }

    MediaTrack(long l, int n) throws IllegalArgumentException {
        this(0L, 0, null, null, null, null, -1, null);
        this.zzakg = l;
        if (n <= 0 || n > 3) {
            throw new IllegalArgumentException(new StringBuilder(24).append("invalid type ").append(n).toString());
        }
        this.zzamr = n;
    }

    public final long getId() {
        return this.zzakg;
    }

    public final int getType() {
        return this.zzamr;
    }

    public final String getContentId() {
        return this.zzapX;
    }

    public final void setContentId(String string2) {
        this.zzapX = string2;
    }

    public final String getContentType() {
        return this.zzapZ;
    }

    public final void setContentType(String string2) {
        this.zzapZ = string2;
    }

    public final String getName() {
        return this.mName;
    }

    final void setName(String string2) {
        this.mName = string2;
    }

    public final String getLanguage() {
        return this.zzaeT;
    }

    final void setLanguage(String string2) {
        this.zzaeT = string2;
    }

    public final int getSubtype() {
        return this.zzaqN;
    }

    final void zzW(int n) throws IllegalArgumentException {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(new StringBuilder(27).append("invalid subtype ").append(n).toString());
        }
        if (n != 0 && this.zzamr != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzaqN = n;
    }

    public final JSONObject getCustomData() {
        return this.zzaoD;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzaoD = jSONObject;
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzakg);
            switch (this.zzamr) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                }
            }
            if (this.zzapX != null) {
                jSONObject.put("trackContentId", (Object)this.zzapX);
            }
            if (this.zzapZ != null) {
                jSONObject.put("trackContentType", (Object)this.zzapZ);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzaeT)) {
                jSONObject.put("language", (Object)this.zzaeT);
            }
            switch (this.zzaqN) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                }
            }
            if (this.zzaoD != null) {
                jSONObject.put("customData", (Object)this.zzaoD);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)((Object)object);
        if (this.zzaoD == null != (mediaTrack.zzaoD == null)) {
            return false;
        }
        if (this.zzaoD != null && mediaTrack.zzaoD != null && !zzo.zzc((Object)this.zzaoD, (Object)mediaTrack.zzaoD)) {
            return false;
        }
        return this.zzakg == mediaTrack.zzakg && this.zzamr == mediaTrack.zzamr && zzayd.zza(this.zzapX, mediaTrack.zzapX) && zzayd.zza(this.zzapZ, mediaTrack.zzapZ) && zzayd.zza(this.mName, mediaTrack.mName) && zzayd.zza(this.zzaeT, mediaTrack.zzaeT) && this.zzaqN == mediaTrack.zzaqN;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzakg, this.zzamr, this.zzapX, this.zzapZ, this.mName, this.zzaeT, this.zzaqN, String.valueOf(this.zzaoD)});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzaoC = this.zzaoD == null ? null : this.zzaoD.toString();
        Parcel parcel2 = parcel;
        MediaTrack mediaTrack = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (long)mediaTrack.getId());
        zzd.zzc((Parcel)parcel2, (int)3, (int)mediaTrack.getType());
        zzd.zza((Parcel)parcel2, (int)4, (String)mediaTrack.getContentId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)mediaTrack.getContentType(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)mediaTrack.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (String)mediaTrack.getLanguage(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)8, (int)mediaTrack.getSubtype());
        zzd.zza((Parcel)parcel2, (int)9, (String)mediaTrack.zzaoC, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private final MediaTrack zzaqO;

        public Builder(long l, int n) throws IllegalArgumentException {
            this.zzaqO = new MediaTrack(l, n);
        }

        public Builder setContentId(String string2) {
            this.zzaqO.setContentId(string2);
            return this;
        }

        public Builder setContentType(String string2) {
            this.zzaqO.setContentType(string2);
            return this;
        }

        public Builder setName(String string2) {
            this.zzaqO.setName(string2);
            return this;
        }

        public Builder setLanguage(String string2) {
            this.zzaqO.setLanguage(string2);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzaqO.setLanguage(zzayd.zzb(locale));
            return this;
        }

        public Builder setSubtype(int n) throws IllegalArgumentException {
            this.zzaqO.zzW(n);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzaqO.setCustomData(jSONObject);
            return this;
        }

        public MediaTrack build() {
            return this.zzaqO;
        }
    }
}

