/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzaxs;
import com.google.android.gms.internal.zzayd;
import com.google.android.gms.internal.zzayp;
import com.google.android.gms.internal.zzayq;
import com.google.android.gms.internal.zzays;
import com.google.android.gms.internal.zzayt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzayo
extends zzaxs {
    public static final String NAMESPACE = zzayd.zzcj("com.google.cast.media");
    private long zzayA;
    private MediaStatus zzayB;
    private final List<zzayt> zzawS;
    private zzayp zzayC;
    private final zzayt zzayD;
    private final zzayt zzayE;
    private final zzayt zzayF;
    private final zzayt zzayG;
    private final zzayt zzayH;
    private final zzayt zzayI;
    private final zzayt zzayJ;
    private final zzayt zzayK;
    private final zzayt zzayL;
    private final zzayt zzayM;
    private final zzayt zzayN;
    private final zzayt zzayO;
    private final zzayt zzayP;
    private final zzayt zzayQ;

    public zzayo(String string2) {
        super(NAMESPACE, zzi.zzrY(), "MediaControlChannel", null, 1000L);
        this.zzayD = new zzayt(this.zzvy, 86400000L);
        this.zzayE = new zzayt(this.zzvy, 86400000L);
        this.zzayF = new zzayt(this.zzvy, 86400000L);
        this.zzayG = new zzayt(this.zzvy, 86400000L);
        this.zzayH = new zzayt(this.zzvy, 86400000L);
        this.zzayI = new zzayt(this.zzvy, 86400000L);
        this.zzayJ = new zzayt(this.zzvy, 86400000L);
        this.zzayK = new zzayt(this.zzvy, 86400000L);
        this.zzayL = new zzayt(this.zzvy, 86400000L);
        this.zzayM = new zzayt(this.zzvy, 86400000L);
        this.zzayN = new zzayt(this.zzvy, 86400000L);
        this.zzayO = new zzayt(this.zzvy, 86400000L);
        this.zzayP = new zzayt(this.zzvy, 86400000L);
        this.zzayQ = new zzayt(this.zzvy, 86400000L);
        this.zzawS = new ArrayList<zzayt>();
        this.zzawS.add(this.zzayD);
        this.zzawS.add(this.zzayE);
        this.zzawS.add(this.zzayF);
        this.zzawS.add(this.zzayG);
        this.zzawS.add(this.zzayH);
        this.zzawS.add(this.zzayI);
        this.zzawS.add(this.zzayJ);
        this.zzawS.add(this.zzayK);
        this.zzawS.add(this.zzayL);
        this.zzawS.add(this.zzayM);
        this.zzawS.add(this.zzayN);
        this.zzawS.add(this.zzayO);
        this.zzawS.add(this.zzayP);
        this.zzawS.add(this.zzayQ);
        this.zzoM();
    }

    public final void zza(zzayp zzayp2) {
        this.zzayC = zzayp2;
    }

    public final long zza(zzays zzays2, MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzoA();
        this.zzayD.zza(l2, zzays2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.toJson());
            jSONObject2.put("autoplay", bl);
            jSONObject2.put("currentTime", (double)l / 1000.0);
            if (lArray != null) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzays zzays2, JSONObject jSONObject) throws IOException, zzayq {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoA();
        this.zzayE.zza(l, zzays2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zznk());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzb(zzays zzays2, JSONObject jSONObject) throws IOException, zzayq {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoA();
        this.zzayG.zza(l, zzays2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zznk());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzc(zzays zzays2, JSONObject jSONObject) throws IOException, zzayq {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoA();
        this.zzayF.zza(l, zzays2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zznk());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzays zzays2, long l, int n, JSONObject jSONObject) throws IOException, zzayq {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzoA();
        this.zzayH.zza(l2, zzays2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zznk());
            jSONObject2.put("currentTime", (double)l / 1000.0);
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzays zzays2, double d, JSONObject jSONObject) throws IOException, zzayq, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoA();
        this.zzayI.zza(l, zzays2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zznk());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzays zzays2, boolean bl, JSONObject jSONObject) throws IOException, zzayq {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoA();
        this.zzayJ.zza(l, zzays2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zznk());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzays zzays2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzoA();
        this.zzayK.zza(l, zzays2);
        this.zzZ(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzayB != null) {
                jSONObject.put("mediaSessionId", this.zzayB.zznk());
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzays zzays2, long[] lArray) throws IOException, zzayq {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzoA();
        this.zzayL.zza(l, zzays2);
        this.zzZ(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zznk());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzays zzays2, TextTrackStyle textTrackStyle) throws IOException, zzayq {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzoA();
        this.zzayM.zza(l, zzays2);
        this.zzZ(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zznk());
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zzayA == 0L) {
            return 0L;
        }
        double d = this.zzayB.getPlaybackRate();
        long l = this.zzayB.getStreamPosition();
        int n = this.zzayB.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        long l2 = mediaInfo.getStreamDuration();
        zzayo zzayo2 = this;
        long l3 = zzayo2.zzvy.elapsedRealtime() - zzayo2.zzayA;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l;
        }
        long l4 = l + (long)((double)l3 * d);
        if (l2 > 0L && l4 > l2) {
            l4 = l2;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public final long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo != null) {
            return mediaInfo.getStreamDuration();
        }
        return 0L;
    }

    public final MediaStatus getMediaStatus() {
        return this.zzayB;
    }

    public final MediaInfo getMediaInfo() {
        if (this.zzayB == null) {
            return null;
        }
        return this.zzayB.getMediaInfo();
    }

    public final long zza(zzays zzays2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IOException, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= mediaQueueItemArray.length) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Invalid startIndex: ").append(n).toString());
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzoA();
        this.zzayD.zza(l2, zzays2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            switch (n2) {
                case 0: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                    break;
                }
                case 1: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                    break;
                }
                case 2: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                    break;
                }
                case 3: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(32).append("Invalid repeat mode: ").append(n2).toString());
                }
            }
            jSONObject2.put("startIndex", n);
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzays zzays2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, int n3, long l, JSONObject jSONObject) throws IOException, zzayq, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        if (n3 != -1 && (n3 < 0 || n3 >= mediaQueueItemArray.length)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "currentItemIndexInItemsToInsert %d out of range [0, %d).", n3, mediaQueueItemArray.length));
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzoA();
        this.zzayN.zza(l2, zzays2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zznk());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (n3 != -1) {
                jSONObject2.put("currentItemIndex", n3);
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzays zzays2, int n, long l, MediaQueueItem[] mediaQueueItemArray, int n2, Integer n3, JSONObject jSONObject) throws IllegalArgumentException, IOException, zzayq {
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(53).append("playPosition cannot be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzoA();
        this.zzayO.zza(l2, zzays2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zznk());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && mediaQueueItemArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                    jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                        break;
                    }
                    case 1: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                        break;
                    }
                    case 2: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                        break;
                    }
                    case 3: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    }
                }
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzays zzays2, int[] nArray, JSONObject jSONObject) throws IOException, zzayq, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoA();
        this.zzayP.zza(l, zzays2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zznk());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzays zzays2, int[] nArray, int n, JSONObject jSONObject) throws IOException, zzayq, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoA();
        this.zzayQ.zza(l, zzays2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zznk());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    @Override
    public final void zzch(String string2) {
        this.zzarK.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            switch (string3) {
                case "MEDIA_STATUS": {
                    JSONArray jSONArray = jSONObject.getJSONArray("status");
                    if (jSONArray.length() > 0) {
                        this.zza(l, jSONArray.getJSONObject(0));
                        return;
                    }
                    this.zzayB = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.onQueueStatusUpdated();
                    this.onPreloadStatusUpdated();
                    this.zzayK.zzc(l, 0, null);
                    return;
                }
                case "INVALID_PLAYER_STATE": {
                    this.zzarK.zzf("received unexpected error: Invalid Player State.", new Object[0]);
                    JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                    Iterator<zzayt> iterator = this.zzawS.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().zzc(l, 2100, jSONObject2);
                    }
                    return;
                }
                case "LOAD_FAILED": {
                    JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                    this.zzayD.zzc(l, 2100, jSONObject3);
                    return;
                }
                case "LOAD_CANCELLED": {
                    JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                    this.zzayD.zzc(l, 2101, jSONObject4);
                    return;
                }
                case "INVALID_REQUEST": {
                    this.zzarK.zzf("received unexpected error: Invalid Request.", new Object[0]);
                    JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                    Iterator<zzayt> iterator = this.zzawS.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().zzc(l, 2100, jSONObject5);
                    }
                    break;
                }
            }
            return;
        }
        catch (JSONException jSONException) {
            this.zzarK.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
    }

    private final void zza(long l, JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = this.zzayD.test(l);
        boolean bl2 = this.zzayH.zzoO() && !this.zzayH.test(l);
        boolean bl3 = this.zzayI.zzoO() && !this.zzayI.test(l) || this.zzayJ.zzoO() && !this.zzayJ.test(l);
        int n2 = 0;
        if (bl2) {
            n2 = 2;
        }
        if (bl3) {
            n2 |= 1;
        }
        if (bl || this.zzayB == null) {
            this.zzayB = new MediaStatus(jSONObject);
            this.zzayA = this.zzvy.elapsedRealtime();
            n = 127;
        } else {
            n = this.zzayB.zza(jSONObject, n2);
        }
        if ((n & 1) != 0) {
            this.zzayA = this.zzvy.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 2) != 0) {
            this.zzayA = this.zzvy.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 4) != 0) {
            this.onMetadataUpdated();
        }
        if ((n & 8) != 0) {
            this.onQueueStatusUpdated();
        }
        if ((n & 0x10) != 0) {
            this.onPreloadStatusUpdated();
        }
        if ((n & 0x20) != 0) {
            this.zzayA = this.zzvy.elapsedRealtime();
            zzayo zzayo2 = this;
            if (zzayo2.zzayC != null) {
                zzayo2.zzayC.onAdBreakStatusUpdated();
            }
        }
        if ((n & 0x40) != 0) {
            this.zzayA = this.zzvy.elapsedRealtime();
            this.onStatusUpdated();
        }
        Iterator<zzayt> iterator = this.zzawS.iterator();
        while (iterator.hasNext()) {
            long l2 = l;
            iterator.next().zzc(l2, 0, null);
        }
    }

    private final long zznk() throws zzayq {
        if (this.zzayB == null) {
            throw new zzayq();
        }
        return this.zzayB.zznk();
    }

    private final void onStatusUpdated() {
        if (this.zzayC != null) {
            this.zzayC.onStatusUpdated();
        }
    }

    private final void onMetadataUpdated() {
        if (this.zzayC != null) {
            this.zzayC.onMetadataUpdated();
        }
    }

    private final void onQueueStatusUpdated() {
        if (this.zzayC != null) {
            this.zzayC.onQueueStatusUpdated();
        }
    }

    private final void onPreloadStatusUpdated() {
        if (this.zzayC != null) {
            this.zzayC.onPreloadStatusUpdated();
        }
    }

    private final void zzoM() {
        this.zzayA = 0L;
        this.zzayB = null;
        Iterator<zzayt> iterator = this.zzawS.iterator();
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
    }

    @Override
    public final void zzoz() {
        super.zzoz();
        this.zzoM();
    }

    @Override
    public final void zzc(long l, int n) {
        Iterator<zzayt> iterator = this.zzawS.iterator();
        while (iterator.hasNext()) {
            int n2 = n;
            long l2 = l;
            iterator.next().zzc(l2, n2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zzz(long l) {
        Iterator<zzayt> iterator = this.zzawS.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzd(l, 2102);
        }
        boolean bl = false;
        Object object = zzayt.zzrn;
        synchronized (object) {
            Iterator<zzayt> iterator2 = this.zzawS.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().zzoO()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

