/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.zzbi;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzaye;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle
extends zza {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    public static final Parcelable.Creator<TextTrackStyle> CREATOR = new zzbi();
    private float zzary;
    private int zzarz;
    private int zzHs;
    private int zzarA;
    private int zzarB;
    private int zzarC;
    private int zzarD;
    private int zzarE;
    private String zzarF;
    private int zzarG;
    private int zzarH;
    private String zzaoC;
    private JSONObject zzaoD;

    TextTrackStyle(float f, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string2, int n8, int n9, String string3) {
        this.zzary = f;
        this.zzarz = n;
        this.zzHs = n2;
        this.zzarA = n3;
        this.zzarB = n4;
        this.zzarC = n5;
        this.zzarD = n6;
        this.zzarE = n7;
        this.zzarF = string2;
        this.zzarG = n8;
        this.zzarH = n9;
        this.zzaoC = string3;
        if (this.zzaoC != null) {
            try {
                this.zzaoD = new JSONObject(this.zzaoC);
                return;
            }
            catch (JSONException jSONException) {
                this.zzaoD = null;
                this.zzaoC = null;
                return;
            }
        }
        this.zzaoD = null;
    }

    public TextTrackStyle() {
        this(1.0f, 0, 0, -1, 0, -1, 0, 0, null, -1, -1, null);
    }

    public final void setFontScale(float f) {
        this.zzary = f;
    }

    public final float getFontScale() {
        return this.zzary;
    }

    public final void setForegroundColor(int n) {
        this.zzarz = n;
    }

    public final int getForegroundColor() {
        return this.zzarz;
    }

    public final void setBackgroundColor(int n) {
        this.zzHs = n;
    }

    public final int getBackgroundColor() {
        return this.zzHs;
    }

    public final void setEdgeType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzarA = n;
    }

    public final int getEdgeType() {
        return this.zzarA;
    }

    public final void setEdgeColor(int n) {
        this.zzarB = n;
    }

    public final int getEdgeColor() {
        return this.zzarB;
    }

    public final void setWindowType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzarC = n;
    }

    public final int getWindowType() {
        return this.zzarC;
    }

    public final void setWindowColor(int n) {
        this.zzarD = n;
    }

    public final int getWindowColor() {
        return this.zzarD;
    }

    public final void setWindowCornerRadius(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzarE = n;
    }

    public final int getWindowCornerRadius() {
        return this.zzarE;
    }

    public final void setFontFamily(String string2) {
        this.zzarF = string2;
    }

    public final String getFontFamily() {
        return this.zzarF;
    }

    public final void setFontGenericFamily(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzarG = n;
    }

    public final int getFontGenericFamily() {
        return this.zzarG;
    }

    public final void setFontStyle(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzarH = n;
    }

    public final int getFontStyle() {
        return this.zzarH;
    }

    public final void setCustomData(JSONObject jSONObject) {
        this.zzaoD = jSONObject;
    }

    public final JSONObject getCustomData() {
        return this.zzaoD;
    }

    @TargetApi(value=19)
    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzq.zzsc()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (!Typeface.SANS_SERIF.equals((Object)typeface) && Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public final void zzl(JSONObject jSONObject) throws JSONException {
        String string2;
        this.zzary = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzarz = TextTrackStyle.zzcb(jSONObject.optString("foregroundColor"));
        this.zzHs = TextTrackStyle.zzcb(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.zzarA = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.zzarA = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.zzarA = 2;
            } else if ("RAISED".equals(string2)) {
                this.zzarA = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.zzarA = 4;
            }
        }
        this.zzarB = TextTrackStyle.zzcb(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.zzarC = 0;
            } else if ("NORMAL".equals(string2)) {
                this.zzarC = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.zzarC = 2;
            }
        }
        this.zzarD = TextTrackStyle.zzcb(jSONObject.optString("windowColor"));
        if (this.zzarC == 2) {
            this.zzarE = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzarF = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.zzarG = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.zzarG = 1;
            } else if ("SERIF".equals(string2)) {
                this.zzarG = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.zzarG = 3;
            } else if ("CASUAL".equals(string2)) {
                this.zzarG = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.zzarG = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.zzarG = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.zzarH = 0;
            } else if ("BOLD".equals(string2)) {
                this.zzarH = 1;
            } else if ("ITALIC".equals(string2)) {
                this.zzarH = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.zzarH = 3;
            }
        }
        this.zzaoD = jSONObject.optJSONObject("customData");
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzary);
            if (this.zzarz != 0) {
                jSONObject.put("foregroundColor", (Object)TextTrackStyle.zzu(this.zzarz));
            }
            if (this.zzHs != 0) {
                jSONObject.put("backgroundColor", (Object)TextTrackStyle.zzu(this.zzHs));
            }
            switch (this.zzarA) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                }
            }
            if (this.zzarB != 0) {
                jSONObject.put("edgeColor", (Object)TextTrackStyle.zzu(this.zzarB));
            }
            switch (this.zzarC) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                }
            }
            if (this.zzarD != 0) {
                jSONObject.put("windowColor", (Object)TextTrackStyle.zzu(this.zzarD));
            }
            if (this.zzarC == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzarE);
            }
            if (this.zzarF != null) {
                jSONObject.put("fontFamily", (Object)this.zzarF);
            }
            switch (this.zzarG) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                }
            }
            switch (this.zzarH) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                }
            }
            if (this.zzaoD != null) {
                jSONObject.put("customData", (Object)this.zzaoD);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    private static String zzu(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private static int zzcb(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string2.substring(1, 3), 16);
                int n2 = Integer.parseInt(string2.substring(3, 5), 16);
                int n3 = Integer.parseInt(string2.substring(5, 7), 16);
                return Color.argb((int)Integer.parseInt(string2.substring(7, 9), 16), (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)((Object)object);
        if (this.zzaoD == null != (textTrackStyle.zzaoD == null)) {
            return false;
        }
        if (this.zzaoD != null && textTrackStyle.zzaoD != null && !zzo.zzc((Object)this.zzaoD, (Object)textTrackStyle.zzaoD)) {
            return false;
        }
        return this.zzary == textTrackStyle.zzary && this.zzarz == textTrackStyle.zzarz && this.zzHs == textTrackStyle.zzHs && this.zzarA == textTrackStyle.zzarA && this.zzarB == textTrackStyle.zzarB && this.zzarC == textTrackStyle.zzarC && this.zzarE == textTrackStyle.zzarE && zzaye.zza(this.zzarF, textTrackStyle.zzarF) && this.zzarG == textTrackStyle.zzarG && this.zzarH == textTrackStyle.zzarH;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.zzary), this.zzarz, this.zzHs, this.zzarA, this.zzarB, this.zzarC, this.zzarD, this.zzarE, this.zzarF, this.zzarG, this.zzarH, String.valueOf(this.zzaoD)});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzaoC = this.zzaoD == null ? null : this.zzaoD.toString();
        Parcel parcel2 = parcel;
        TextTrackStyle textTrackStyle = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (float)textTrackStyle.getFontScale());
        zzd.zzc((Parcel)parcel2, (int)3, (int)textTrackStyle.getForegroundColor());
        zzd.zzc((Parcel)parcel2, (int)4, (int)textTrackStyle.getBackgroundColor());
        zzd.zzc((Parcel)parcel2, (int)5, (int)textTrackStyle.getEdgeType());
        zzd.zzc((Parcel)parcel2, (int)6, (int)textTrackStyle.getEdgeColor());
        zzd.zzc((Parcel)parcel2, (int)7, (int)textTrackStyle.getWindowType());
        zzd.zzc((Parcel)parcel2, (int)8, (int)textTrackStyle.getWindowColor());
        zzd.zzc((Parcel)parcel2, (int)9, (int)textTrackStyle.getWindowCornerRadius());
        zzd.zza((Parcel)parcel2, (int)10, (String)textTrackStyle.getFontFamily(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)11, (int)textTrackStyle.getFontGenericFamily());
        zzd.zzc((Parcel)parcel2, (int)12, (int)textTrackStyle.getFontStyle());
        zzd.zza((Parcel)parcel2, (int)13, (String)textTrackStyle.zzaoC, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

