/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.internal.zzaxq;
import com.google.android.gms.internal.zzaxy;
import com.google.android.gms.internal.zzaxz;
import com.google.android.gms.internal.zzaye;
import com.google.android.gms.internal.zzayf;
import com.google.android.gms.internal.zzayj;
import com.google.android.gms.internal.zzayk;
import com.google.android.gms.internal.zzayo;
import com.google.android.gms.internal.zzbaz;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class zzaxx
extends zzz<zzayj> {
    private static final zzayo zzapq = new zzayo("CastClientImpl");
    private ApplicationMetadata zzaxL;
    private final CastDevice zzasf;
    private final Cast.Listener zzaoY;
    private final Map<String, Cast.MessageReceivedCallback> zzaxM;
    private final long zzaxN;
    private final Bundle mExtras;
    private zzaxz zzaxO;
    private String zzaxP;
    private boolean zzaqE;
    private boolean zzaxQ;
    private boolean zzaxR;
    private boolean zzaxS;
    private double zzaqD;
    private int zzaxT;
    private int zzaxU;
    private final AtomicLong zzaxV;
    private String zzaxW;
    private String zzaxX;
    private Bundle zzaxY;
    private final Map<Long, zzbaz<Status>> zzaxZ;
    private zzbaz<Cast.ApplicationConnectionResult> zzaya;
    private zzbaz<Status> zzayb;
    private static final Object zzayc = new Object();
    private static final Object zzayd = new Object();

    public zzaxx(Context context, Looper looper, zzq zzq2, CastDevice castDevice, long l, Cast.Listener listener, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzasf = castDevice;
        this.zzaoY = listener;
        this.zzaxN = l;
        this.mExtras = bundle;
        this.zzaxM = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzaxV = new AtomicLong(0L);
        this.zzaxZ = new HashMap<Long, zzbaz<Status>>();
        this.zzoB();
    }

    private final void zzoB() {
        this.zzaxS = false;
        this.zzaxT = -1;
        this.zzaxU = -1;
        this.zzaxL = null;
        this.zzaxP = null;
        this.zzaqD = 0.0;
        this.zzaqE = false;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzapq.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzaxS = true;
            this.zzaxQ = true;
            this.zzaxR = true;
        } else {
            this.zzaxS = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzaxY = new Bundle();
            this.zzaxY.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    public final void disconnect() {
        zzapq.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzaxO, this.isConnected());
        zzaxz zzaxz2 = this.zzaxO;
        this.zzaxO = null;
        if (zzaxz2 == null || zzaxz2.zzoI() == null) {
            zzapq.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzoD();
        try {
            ((zzayj)super.zzrf()).disconnect();
            return;
        }
        catch (RemoteException | IllegalStateException throwable) {
            zzapq.zzb(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
            return;
        }
        finally {
            super.disconnect();
        }
    }

    public final Bundle zzoC() {
        if (this.zzaxY != null) {
            Bundle bundle = this.zzaxY;
            this.zzaxY = null;
            return bundle;
        }
        return super.zzoC();
    }

    @NonNull
    protected final String zzdb() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @NonNull
    protected final String zzdc() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected final Bundle zzmo() {
        Bundle bundle = new Bundle();
        zzapq.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzaxW, this.zzaxX);
        this.zzasf.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzaxN);
        if (this.mExtras != null) {
            bundle.putAll(this.mExtras);
        }
        this.zzaxO = new zzaxz(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzaxO.asBinder()));
        if (this.zzaxW != null) {
            bundle.putString("last_application_id", this.zzaxW);
            if (this.zzaxX != null) {
                bundle.putString("last_session_id", this.zzaxX);
            }
        }
        return bundle;
    }

    public final void zza(String string2, String string3, zzbaz<Status> zzbaz2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzaye.zzci(string2);
        this.zzoE();
        long l = this.zzaxV.incrementAndGet();
        try {
            this.zzaxZ.put(l, zzbaz2);
            ((zzayj)super.zzrf()).zzb(string2, string3, l);
            return;
        }
        catch (Throwable throwable) {
            this.zzaxZ.remove(l);
            throw throwable;
        }
    }

    public final void zza(String string2, LaunchOptions launchOptions, zzbaz<Cast.ApplicationConnectionResult> zzbaz2) throws IllegalStateException, RemoteException {
        this.zza(zzbaz2);
        ((zzayj)super.zzrf()).zzb(string2, launchOptions);
    }

    public final void zza(String string2, String string3, com.google.android.gms.cast.zzz zzz2, zzbaz<Cast.ApplicationConnectionResult> zzbaz2) throws IllegalStateException, RemoteException {
        this.zza(zzbaz2);
        if (zzz2 == null) {
            zzz2 = new com.google.android.gms.cast.zzz();
        }
        ((zzayj)super.zzrf()).zza(string2, string3, zzz2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzbaz<Cast.ApplicationConnectionResult> zzbaz2) {
        Object object = zzayc;
        synchronized (object) {
            if (this.zzaya != null) {
                this.zzaya.setResult((Object)new zzaxy(new Status(2002)));
            }
            this.zzaya = zzbaz2;
            return;
        }
    }

    public final void zzb(zzbaz<Status> zzbaz2) throws IllegalStateException, RemoteException {
        this.zzc(zzbaz2);
        ((zzayj)super.zzrf()).zzoK();
    }

    public final void zza(String string2, zzbaz<Status> zzbaz2) throws IllegalStateException, RemoteException {
        this.zzc(zzbaz2);
        ((zzayj)super.zzrf()).zzcc(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzc(zzbaz<Status> zzbaz2) {
        Object object = zzayd;
        synchronized (object) {
            if (this.zzayb != null) {
                zzbaz2.setResult((Object)new Status(2001));
                return;
            }
            this.zzayb = zzbaz2;
            return;
        }
    }

    public final void requestStatus() throws IllegalStateException, RemoteException {
        ((zzayj)super.zzrf()).requestStatus();
    }

    public final void setVolume(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        ((zzayj)super.zzrf()).zza(d, this.zzaqD, this.zzaqE);
    }

    public final void setMute(boolean bl) throws IllegalStateException, RemoteException {
        ((zzayj)super.zzrf()).zza(bl, this.zzaqD, this.zzaqE);
    }

    public final double getVolume() throws IllegalStateException {
        this.zzoE();
        return this.zzaqD;
    }

    public final boolean isMute() throws IllegalStateException {
        this.zzoE();
        return this.zzaqE;
    }

    public final int getActiveInputState() throws IllegalStateException {
        this.zzoE();
        return this.zzaxT;
    }

    public final int getStandbyState() throws IllegalStateException {
        this.zzoE();
        return this.zzaxU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzaye.zzci(string2);
        this.removeMessageReceivedCallbacks(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzaxM;
            synchronized (map) {
                this.zzaxM.put(string2, messageReceivedCallback);
            }
            ((zzayj)super.zzrf()).zzcl(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMessageReceivedCallbacks(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzaxM;
        synchronized (map) {
            messageReceivedCallback = this.zzaxM.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzayj)super.zzrf()).zzcm(string2);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                zzapq.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public final ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzoE();
        return this.zzaxL;
    }

    public final String getApplicationStatus() throws IllegalStateException {
        this.zzoE();
        return this.zzaxP;
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzoD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzoD() {
        zzapq.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzaxM;
        synchronized (map) {
            this.zzaxM.clear();
            return;
        }
    }

    private final void zza(zzayf zzayf2) {
        boolean bl;
        ApplicationMetadata applicationMetadata = zzayf2.getApplicationMetadata();
        if (!zzaye.zza(applicationMetadata, this.zzaxL)) {
            this.zzaxL = applicationMetadata;
            this.zzaoY.onApplicationMetadataChanged(this.zzaxL);
        }
        boolean bl2 = false;
        double d = zzayf2.getVolume();
        if (!Double.isNaN(d) && Math.abs(d - this.zzaqD) > 1.0E-7) {
            this.zzaqD = d;
            bl2 = true;
        }
        if ((bl = zzayf2.zzoJ()) != this.zzaqE) {
            this.zzaqE = bl;
            bl2 = true;
        }
        zzapq.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzaxR);
        if (this.zzaoY != null && (bl2 || this.zzaxR)) {
            this.zzaoY.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = zzayf2.getActiveInputState();
        if (n != this.zzaxT) {
            this.zzaxT = n;
            bl3 = true;
        }
        zzapq.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzaxR);
        if (this.zzaoY != null && (bl3 || this.zzaxR)) {
            this.zzaoY.onActiveInputStateChanged(this.zzaxT);
        }
        boolean bl4 = false;
        int n2 = zzayf2.getStandbyState();
        if (n2 != this.zzaxU) {
            this.zzaxU = n2;
            bl4 = true;
        }
        zzapq.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzaxR);
        if (this.zzaoY != null && (bl4 || this.zzaxR)) {
            this.zzaoY.onStandbyStateChanged(this.zzaxU);
        }
        this.zzaxR = false;
    }

    private final void zza(zzaxq zzaxq2) {
        boolean bl = false;
        String string2 = zzaxq2.zzoy();
        if (!zzaye.zza(string2, this.zzaxP)) {
            this.zzaxP = string2;
            bl = true;
        }
        zzapq.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzaxQ);
        if (this.zzaoY != null && (bl || this.zzaxQ)) {
            this.zzaoY.onApplicationStatusChanged();
        }
        this.zzaxQ = false;
    }

    private final void zzoE() throws IllegalStateException {
        if (!this.zzaxS || this.zzaxO == null || this.zzaxO.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.cast.internal.ICastDeviceController");
        if (iInterface instanceof zzayj) {
            return (zzayj)iInterface;
        }
        return new zzayk(iBinder2);
    }

    static /* synthetic */ void zzb(zzaxx zzaxx2) {
        zzaxx2.zzoB();
    }

    static /* synthetic */ zzayo zzoF() {
        return zzapq;
    }

    static /* synthetic */ ApplicationMetadata zza(zzaxx zzaxx2, ApplicationMetadata applicationMetadata) {
        zzaxx2.zzaxL = applicationMetadata;
        return zzaxx2.zzaxL;
    }

    static /* synthetic */ String zza(zzaxx zzaxx2, String string2) {
        zzaxx2.zzaxW = string2;
        return zzaxx2.zzaxW;
    }

    static /* synthetic */ String zzb(zzaxx zzaxx2, String string2) {
        zzaxx2.zzaxX = string2;
        return zzaxx2.zzaxX;
    }

    static /* synthetic */ String zzc(zzaxx zzaxx2, String string2) {
        zzaxx2.zzaxP = string2;
        return zzaxx2.zzaxP;
    }

    static /* synthetic */ Object zzoG() {
        return zzayc;
    }

    static /* synthetic */ zzbaz zzc(zzaxx zzaxx2) {
        return zzaxx2.zzaya;
    }

    static /* synthetic */ zzbaz zza(zzaxx zzaxx2, zzbaz zzbaz2) {
        zzaxx2.zzaya = null;
        return null;
    }

    static /* synthetic */ Cast.Listener zzd(zzaxx zzaxx2) {
        return zzaxx2.zzaoY;
    }

    static /* synthetic */ void zza(zzaxx zzaxx2, zzayf zzayf2) {
        zzaxx2.zza(zzayf2);
    }

    static /* synthetic */ void zza(zzaxx zzaxx2, zzaxq zzaxq2) {
        zzaxx2.zza(zzaxq2);
    }

    static /* synthetic */ Map zze(zzaxx zzaxx2) {
        return zzaxx2.zzaxM;
    }

    static /* synthetic */ CastDevice zzf(zzaxx zzaxx2) {
        return zzaxx2.zzasf;
    }

    static /* synthetic */ Map zzg(zzaxx zzaxx2) {
        return zzaxx2.zzaxZ;
    }

    static /* synthetic */ Object zzoH() {
        return zzayd;
    }

    static /* synthetic */ zzbaz zzh(zzaxx zzaxx2) {
        return zzaxx2.zzayb;
    }

    static /* synthetic */ zzbaz zzb(zzaxx zzaxx2, zzbaz zzbaz2) {
        zzaxx2.zzayb = null;
        return null;
    }
}

