/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.cast.zzn;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.internal.zzazf;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
extends zza
implements ReflectedParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final int CAPABILITY_MULTIZONE_GROUP = 32;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzn();
    private String zzeil;
    private String zzeim;
    private Inet4Address zzein;
    private String zzeio;
    private String zzeip;
    private String zzeiq;
    private int zzeir;
    private List<WebImage> zzeis;
    private int zzeit;
    private int zzbyx;
    private String zzeiu;
    private String zzeiv;
    private int zzeiw;

    CastDevice(String string, String string2, String string3, String string4, String string5, int n, List<WebImage> arrayList, int n2, int n3, String string6, String string7, int n4) {
        this.zzeil = CastDevice.zzev(string);
        this.zzeim = CastDevice.zzev(string2);
        if (!TextUtils.isEmpty((CharSequence)this.zzeim)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzeim);
                if (inetAddress instanceof Inet4Address) {
                    this.zzein = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                String string8 = this.zzeim;
                String string9 = unknownHostException.getMessage();
                Log.i((String)"CastDevice", (String)new StringBuilder(48 + String.valueOf(string8).length() + String.valueOf(string9).length()).append("Unable to convert host address (").append(string8).append(") to ipaddress: ").append(string9).toString());
            }
        }
        this.zzeio = CastDevice.zzev(string3);
        this.zzeip = CastDevice.zzev(string4);
        this.zzeiq = CastDevice.zzev(string5);
        this.zzeir = n;
        this.zzeis = arrayList != null ? arrayList : new ArrayList();
        this.zzeit = n2;
        this.zzbyx = n3;
        this.zzeiu = CastDevice.zzev(string6);
        this.zzeiv = string7;
        this.zzeiw = n4;
    }

    public String getDeviceId() {
        if (this.zzeil.startsWith("__cast_nearby__")) {
            return this.zzeil.substring(16);
        }
        return this.zzeil;
    }

    public Inet4Address getIpAddress() {
        return this.zzein;
    }

    public String getFriendlyName() {
        return this.zzeio;
    }

    public String getModelName() {
        return this.zzeip;
    }

    public String getDeviceVersion() {
        return this.zzeiq;
    }

    public int getServicePort() {
        return this.zzeir;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzeis);
    }

    public WebImage getIcon(int n, int n2) {
        if (this.zzeis.isEmpty()) {
            return null;
        }
        if (n <= 0 || n2 <= 0) {
            return this.zzeis.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzeis) {
            int n3 = webImage3.getWidth();
            int n4 = webImage3.getHeight();
            if (n3 >= n && n4 >= n2) {
                if (webImage != null && (webImage.getWidth() <= n3 || webImage.getHeight() <= n4)) continue;
                webImage = webImage3;
                continue;
            }
            if (n3 >= n || n4 >= n2 || webImage2 != null && (webImage2.getWidth() >= n3 || webImage2.getHeight() >= n4)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzeis.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzeis.isEmpty();
    }

    public boolean hasCapability(int n) {
        return (this.zzeit & n) == n;
    }

    public boolean hasCapabilities(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.hasCapability(n2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzeio, this.zzeil);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastDevice castDevice = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)castDevice.zzeil, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (String)castDevice.zzeim, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)castDevice.getFriendlyName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)castDevice.getModelName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)castDevice.getDeviceVersion(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)castDevice.getServicePort());
        zzd.zzc((Parcel)parcel2, (int)8, castDevice.getIcons(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)9, (int)castDevice.zzeit);
        zzd.zzc((Parcel)parcel2, (int)10, (int)castDevice.zzbyx);
        zzd.zza((Parcel)parcel2, (int)11, (String)castDevice.zzeiu, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)12, (String)castDevice.zzeiv, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)13, (int)castDevice.zzeiw);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)((Object)object);
        if (this.zzeil == null) {
            return castDevice.zzeil == null;
        }
        return zzazf.zza(this.zzeil, castDevice.zzeil) && zzazf.zza(this.zzein, castDevice.zzein) && zzazf.zza(this.zzeip, castDevice.zzeip) && zzazf.zza(this.zzeio, castDevice.zzeio) && zzazf.zza(this.zzeiq, castDevice.zzeiq) && this.zzeir == castDevice.zzeir && zzazf.zza(this.zzeis, castDevice.zzeis) && this.zzeit == castDevice.zzeit && this.zzbyx == castDevice.zzbyx && zzazf.zza(this.zzeiu, castDevice.zzeiu) && zzazf.zza(this.zzeiw, castDevice.zzeiw);
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.zzeil == null) {
            return castDevice.zzeil == null;
        }
        return zzazf.zza(this.zzeil, castDevice.zzeil);
    }

    public int hashCode() {
        if (this.zzeil == null) {
            return 0;
        }
        return this.zzeil.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)bundle.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzeil.startsWith("__cast_nearby__");
    }

    private static String zzev(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

