/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayClient;
import com.google.android.gms.cast.zzaa;
import com.google.android.gms.cast.zzu;
import com.google.android.gms.cast.zzv;
import com.google.android.gms.cast.zzw;
import com.google.android.gms.cast.zzx;
import com.google.android.gms.cast.zzy;
import com.google.android.gms.cast.zzz;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzazp;
import com.google.android.gms.tasks.OnCompleteListener;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=19)
public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzazp zzejl = new zzazp("CastRemoteDisplayLocalService");
    private static final int zzejm = R.id.cast_notification_id;
    private static final Object zzejn = new Object();
    private static AtomicBoolean zzejo = new AtomicBoolean(false);
    private String zzehw;
    private Callbacks zzejp;
    private zzb zzejq;
    private NotificationSettings zzejr;
    private Notification mNotification;
    private boolean zzejs;
    private PendingIntent zzejt;
    private CastDevice zzeju;
    private Display zzcih;
    private Context zzejv;
    private ServiceConnection zzejw;
    private Handler mHandler;
    private MediaRouter zzejx;
    private boolean zzejy = false;
    private CastRemoteDisplayClient zzejz;
    private final MediaRouter.Callback zzeka = new zzu(this);
    private static CastRemoteDisplayLocalService zzekb;
    private final IBinder zzekc = new zza(null);

    public CastRemoteDisplayLocalService() {
    }

    public IBinder onBind(Intent intent) {
        this.zzdo("onBind");
        return this.zzekc;
    }

    public void onCreate() {
        this.zzdo("onCreate");
        super.onCreate();
        this.mHandler = new Handler(this.getMainLooper());
        this.mHandler.postDelayed((Runnable)new zzv(this), 100L);
        this.zzejz = CastRemoteDisplay.getClient((Context)this);
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        this.zzdo("onStartCommand");
        this.zzejy = true;
        return 2;
    }

    protected static void setDebugEnabled() {
        zzejl.zzbc(true);
    }

    protected Display getDisplay() {
        return this.zzcih;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzejn;
        synchronized (object) {
            return zzekb;
        }
    }

    public static void startService(Context context, Class<? extends CastRemoteDisplayLocalService> clazz, String string2, CastDevice castDevice, NotificationSettings notificationSettings, Callbacks callbacks) {
        CastRemoteDisplayLocalService.startServiceWithOptions(context, clazz, string2, castDevice, new Options(), notificationSettings, callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServiceWithOptions(@NonNull Context context, @NonNull Class<? extends CastRemoteDisplayLocalService> clazz, @NonNull String string2, @NonNull CastDevice castDevice, @NonNull Options options, @NonNull NotificationSettings notificationSettings, @NonNull Callbacks callbacks) {
        zzejl.zzb("Starting Service", new Object[0]);
        Object object = zzejn;
        synchronized (object) {
            if (zzekb != null) {
                zzejl.zzf("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzas(true);
            }
        }
        Class<? extends CastRemoteDisplayLocalService> clazz2 = clazz;
        Context context2 = context;
        try {
            ComponentName componentName = new ComponentName(context2, clazz2);
            ServiceInfo serviceInfo = context2.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
        zzbp.zzb((Object)context, (Object)"activityContext is required.");
        zzbp.zzb(clazz, (Object)"serviceClass is required.");
        zzbp.zzb((Object)string2, (Object)"applicationId is required.");
        zzbp.zzb((Object)((Object)castDevice), (Object)"device is required.");
        zzbp.zzb((Object)options, (Object)"options is required.");
        zzbp.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzbp.zzb((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.zzekk == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzejo.getAndSet(true)) {
            zzejl.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(context, clazz);
        context.startService((Intent)object);
        context.bindService((Intent)object, (ServiceConnection)new zzw(string2, castDevice, options, notificationSettings, context, callbacks), 64);
    }

    private final void zzar(boolean bl) {
        this.zzdo("Stopping Service");
        zzbp.zzfx((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.zzejx != null) {
            this.zzdo("Setting default route");
            this.zzejx.selectRoute(this.zzejx.getDefaultRoute());
        }
        if (this.zzejq != null) {
            this.zzdo("Unregistering notification receiver");
            this.unregisterReceiver(this.zzejq);
        }
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zzdo("stopRemoteDisplaySession");
        CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = castRemoteDisplayLocalService;
        castRemoteDisplayLocalService2.zzdo("stopRemoteDisplay");
        castRemoteDisplayLocalService2.zzejz.stopRemoteDisplay().addOnCompleteListener((OnCompleteListener)new zzaa(castRemoteDisplayLocalService2));
        castRemoteDisplayLocalService.onDismissPresentation();
        castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zzdo("Stopping the remote display Service");
        castRemoteDisplayLocalService.stopForeground(true);
        castRemoteDisplayLocalService.stopSelf();
        castRemoteDisplayLocalService = this;
        if (castRemoteDisplayLocalService.zzejx != null) {
            zzbp.zzfx((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            castRemoteDisplayLocalService.zzdo("removeMediaRouterCallback");
            castRemoteDisplayLocalService.zzejx.removeCallback(castRemoteDisplayLocalService.zzeka);
        }
        if (this.zzejv != null && this.zzejw != null) {
            try {
                this.zzejv.unbindService(this.zzejw);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzdo("No need to unbind service, already unbound");
            }
            this.zzejw = null;
            this.zzejv = null;
        }
        this.zzehw = null;
        this.mNotification = null;
        this.zzcih = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzas(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zzejl.zzb("Stopping Service", new Object[0]);
        zzejo.set(false);
        Object object = zzejn;
        synchronized (object) {
            if (zzekb == null) {
                zzejl.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzekb;
            zzekb = null;
        }
        boolean bl2 = bl;
        CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = castRemoteDisplayLocalService;
        if (castRemoteDisplayLocalService2.mHandler != null) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                castRemoteDisplayLocalService2.mHandler.post((Runnable)new zzx(castRemoteDisplayLocalService2, bl2));
                return;
            }
            castRemoteDisplayLocalService2.zzar(bl2);
        }
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzas(false);
    }

    public void updateNotificationSettings(NotificationSettings notificationSettings) {
        zzbp.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzbp.zzb((Object)this.mHandler, (Object)"Service is not ready yet.");
        this.mHandler.post((Runnable)new zzy(this, notificationSettings));
    }

    private final void zza(NotificationSettings notificationSettings) {
        zzbp.zzfx((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (this.zzejr == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.zzejs) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzekk != null) {
                this.zzejr.zzekk = notificationSettings.zzekk;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzekl)) {
                this.zzejr.zzekl = notificationSettings.zzekl;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzekm)) {
                this.zzejr.zzekm = notificationSettings.zzekm;
            }
            this.mNotification = this.zzat(true);
        } else {
            zzbp.zzb((Object)notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.zzejr.mNotification = this.mNotification;
        }
        this.startForeground(zzejm, this.mNotification);
    }

    private final void zza(Display display) {
        this.zzcih = display;
        if (this.zzejs) {
            this.mNotification = this.zzat(true);
            this.startForeground(zzejm, this.mNotification);
        }
        if (this.zzejp != null) {
            this.zzejp.onRemoteDisplaySessionStarted(this);
            this.zzejp = null;
        }
        this.onCreatePresentation(this.zzcih);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zzdo("startRemoteDisplaySession");
        zzbp.zzfx((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = zzejn;
        synchronized (object) {
            if (zzekb != null) {
                zzejl.zzf("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            zzekb = this;
        }
        this.zzejp = callbacks;
        this.zzehw = string2;
        this.zzeju = castDevice;
        this.zzejv = context;
        this.zzejw = serviceConnection;
        this.zzejx = MediaRouter.getInstance((Context)this.getApplicationContext());
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zzehw)).build();
        this.zzdo("addMediaRouterCallback");
        this.zzejx.addCallback((MediaRouteSelector)object, this.zzeka, 4);
        this.mNotification = notificationSettings.mNotification;
        this.zzejq = new zzb(null);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
        intentFilter.addAction("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED");
        this.registerReceiver(this.zzejq, intentFilter);
        this.zzejr = new NotificationSettings(notificationSettings, null);
        if (this.zzejr.mNotification == null) {
            this.zzejs = true;
            this.mNotification = this.zzat(false);
        } else {
            this.zzejs = false;
            this.mNotification = this.zzejr.mNotification;
        }
        this.startForeground(zzejm, this.mNotification);
        Options options2 = options;
        CastDevice castDevice2 = castDevice;
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zzdo("startRemoteDisplay");
        Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED");
        intent.setPackage(castRemoteDisplayLocalService.zzejv.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)castRemoteDisplayLocalService, (int)0, (Intent)intent, (int)0x10000000);
        castRemoteDisplayLocalService.zzejz.startRemoteDisplay(castDevice2, castRemoteDisplayLocalService.zzehw, options2.getConfigPreset(), pendingIntent).addOnCompleteListener((OnCompleteListener)new zzz(castRemoteDisplayLocalService));
        if (this.zzejp != null) {
            this.zzejp.onServiceCreated(this);
        }
        return true;
    }

    private final void zzabj() {
        if (this.zzejp != null) {
            this.zzejp.onRemoteDisplaySessionError(new Status(2200));
            this.zzejp = null;
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private final Notification zzat(boolean bl) {
        int n;
        int n2;
        this.zzdo("createDefaultNotification");
        String string2 = this.zzejr.zzekl;
        String string3 = this.zzejr.zzekm;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? (String)this.getPackageManager().getApplicationLabel(this.getApplicationInfo()) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzeju.getFriendlyName()}) : string3;
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzejr.zzekk).setSmallIcon(n).setOngoing(true);
        String string6 = this.getString(R.string.cast_notification_disconnect);
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        if (castRemoteDisplayLocalService.zzejt == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            intent.setPackage(castRemoteDisplayLocalService.zzejv.getPackageName());
            castRemoteDisplayLocalService.zzejt = PendingIntent.getBroadcast((Context)castRemoteDisplayLocalService, (int)0, (Intent)intent, (int)0x10000000);
        }
        return builder.addAction(17301560, (CharSequence)string6, castRemoteDisplayLocalService.zzejt).build();
    }

    private final void zzdo(String string2) {
        zzejl.zzb("[Instance: %s] %s", new Object[]{this, string2});
    }

    private final void zzdr(String string2) {
        zzejl.zzc("[Instance: %s] %s", new Object[]{this, string2});
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2) {
        castRemoteDisplayLocalService.zzdo(string2);
    }

    static /* synthetic */ CastDevice zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzeju;
    }

    static /* synthetic */ boolean zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzejy;
    }

    static /* synthetic */ void zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2) {
        castRemoteDisplayLocalService.zzdr(string2);
    }

    static /* synthetic */ boolean zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        return castRemoteDisplayLocalService.zza(string2, castDevice, options, notificationSettings, context, serviceConnection, callbacks);
    }

    static /* synthetic */ zzazp zzabk() {
        return zzejl;
    }

    static /* synthetic */ AtomicBoolean zzabl() {
        return zzejo;
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, boolean bl) {
        castRemoteDisplayLocalService.zzar(bl);
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, NotificationSettings notificationSettings) {
        castRemoteDisplayLocalService.zza(notificationSettings);
    }

    static /* synthetic */ void zzc(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        castRemoteDisplayLocalService.zzabj();
    }

    static /* synthetic */ Object zzabm() {
        return zzejn;
    }

    static /* synthetic */ CastRemoteDisplayLocalService zzabn() {
        return zzekb;
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display display) {
        castRemoteDisplayLocalService.zza(display);
    }

    static /* synthetic */ Context zzd(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzejv;
    }

    static /* synthetic */ ServiceConnection zze(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzejw;
    }

    static /* synthetic */ ServiceConnection zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, ServiceConnection serviceConnection) {
        castRemoteDisplayLocalService.zzejw = null;
        return null;
    }

    static /* synthetic */ Context zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Context context) {
        castRemoteDisplayLocalService.zzejv = null;
        return null;
    }

    static /* synthetic */ Display zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display display) {
        castRemoteDisplayLocalService.zzcih = null;
        return null;
    }

    final class zza
    extends Binder {
        private zza() {
        }

        /* synthetic */ zza(zzu zzu2) {
            this();
        }
    }

    static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public final void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                CastRemoteDisplayLocalService.stopService();
                return;
            }
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED")) {
                CastRemoteDisplayLocalService.zzas(false);
            }
        }

        /* synthetic */ zzb(zzu zzu2) {
            this();
        }
    }

    public static class Options {
        @CastRemoteDisplay.Configuration
        private int zzeiy = 2;

        public Options() {
        }

        public void setConfigPreset(@CastRemoteDisplay.Configuration int n) {
            this.zzeiy = n;
        }

        @CastRemoteDisplay.Configuration
        public int getConfigPreset() {
            return this.zzeiy;
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent zzekk;
        private String zzekl;
        private String zzekm;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings notificationSettings) {
            this.mNotification = notificationSettings.mNotification;
            this.zzekk = notificationSettings.zzekk;
            this.zzekl = notificationSettings.zzekl;
            this.zzekm = notificationSettings.zzekm;
        }

        /* synthetic */ NotificationSettings(zzu zzu2) {
            this();
        }

        /* synthetic */ NotificationSettings(NotificationSettings notificationSettings, zzu zzu2) {
            this(notificationSettings);
        }

        public static final class Builder {
            private NotificationSettings zzekn = new NotificationSettings(null);

            public Builder() {
            }

            public final Builder setNotification(Notification notification) {
                this.zzekn.mNotification = notification;
                return this;
            }

            public final Builder setNotificationPendingIntent(PendingIntent pendingIntent) {
                this.zzekn.zzekk = pendingIntent;
                return this;
            }

            public final Builder setNotificationTitle(String string2) {
                this.zzekn.zzekl = string2;
                return this;
            }

            public final Builder setNotificationText(String string2) {
                this.zzekn.zzekm = string2;
                return this;
            }

            public final NotificationSettings build() {
                if (this.zzekn.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zzekn.zzekl)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zzekn.zzekm)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zzekn.zzekk != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zzekn.zzekl) && TextUtils.isEmpty((CharSequence)this.zzekn.zzekm) && this.zzekn.zzekk == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zzekn;
            }
        }
    }

    public static interface Callbacks {
        public void onServiceCreated(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);
    }
}

