/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.zzae;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.internal.zzazf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaInfo
extends zza
implements ReflectedParcelable {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    public static final Parcelable.Creator<MediaInfo> CREATOR = new zzae();
    private final String zzekr;
    private int zzeks;
    private String zzekt;
    private MediaMetadata zzeku;
    private long zzekv;
    private List<MediaTrack> zzekw;
    private TextTrackStyle zzekx;
    private String zzehm;
    private List<AdBreakInfo> zzeky;
    private List<AdBreakClipInfo> zzekz;
    private JSONObject zzehn;

    MediaInfo(String string2, int n, String string3, MediaMetadata mediaMetadata, long l, List<MediaTrack> list, TextTrackStyle textTrackStyle, String string4, List<AdBreakInfo> list2, List<AdBreakClipInfo> list3) {
        this.zzekr = string2;
        this.zzeks = n;
        this.zzekt = string3;
        this.zzeku = mediaMetadata;
        this.zzekv = l;
        this.zzekw = list;
        this.zzekx = textTrackStyle;
        this.zzehm = string4;
        if (this.zzehm != null) {
            try {
                this.zzehn = new JSONObject(this.zzehm);
            }
            catch (JSONException jSONException) {
                this.zzehn = null;
                this.zzehm = null;
            }
        } else {
            this.zzehn = null;
        }
        this.zzeky = list2;
        this.zzekz = list3;
    }

    MediaInfo(String string2) throws IllegalArgumentException {
        this(string2, -1, null, null, -1L, null, null, null, null, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
    }

    MediaInfo(JSONObject jSONObject) throws JSONException {
        this(jSONObject.getString("contentId"), -1, null, null, -1L, null, null, null, null, null);
        double d;
        int n;
        JSONObject jSONObject2;
        String string2 = jSONObject.getString("streamType");
        this.zzeks = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzekt = jSONObject.getString("contentType");
        if (jSONObject.has("metadata")) {
            jSONObject2 = jSONObject.getJSONObject("metadata");
            n = jSONObject2.getInt("metadataType");
            this.zzeku = new MediaMetadata(n);
            this.zzeku.zzl(jSONObject2);
        }
        this.zzekv = -1L;
        if (jSONObject.has("duration") && !jSONObject.isNull("duration") && !Double.isNaN(d = jSONObject.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzekv = (long)(d * 1000.0);
        }
        if (jSONObject.has("tracks")) {
            this.zzekw = new ArrayList<MediaTrack>();
            jSONObject2 = jSONObject.getJSONArray("tracks");
            for (n = 0; n < jSONObject2.length(); ++n) {
                JSONObject jSONObject3 = jSONObject2.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject3);
                this.zzekw.add(mediaTrack);
            }
        } else {
            this.zzekw = null;
        }
        if (jSONObject.has("textTrackStyle")) {
            jSONObject2 = jSONObject.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzl(jSONObject2);
            this.zzekx = textTrackStyle;
        } else {
            this.zzekx = null;
        }
        this.zzk(jSONObject);
        this.zzehn = jSONObject.optJSONObject("customData");
    }

    public String getContentId() {
        return this.zzekr;
    }

    final void setStreamType(int n) throws IllegalArgumentException {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzeks = n;
    }

    public int getStreamType() {
        return this.zzeks;
    }

    final void setContentType(String string2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzekt = string2;
    }

    public String getContentType() {
        return this.zzekt;
    }

    final void zza(MediaMetadata mediaMetadata) {
        this.zzeku = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzeku;
    }

    final void zzw(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzekv = l;
    }

    public long getStreamDuration() {
        return this.zzekv;
    }

    final void zzw(List<MediaTrack> list) {
        this.zzekw = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzekw;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzekx = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzekx;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzehn = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.zzehn;
    }

    public List<AdBreakInfo> getAdBreaks() {
        if (this.zzeky == null) {
            return null;
        }
        return Collections.unmodifiableList(this.zzeky);
    }

    public List<AdBreakClipInfo> getAdBreakClips() {
        if (this.zzekz == null) {
            return null;
        }
        return Collections.unmodifiableList(this.zzekz);
    }

    public final void zzx(List<AdBreakInfo> list) {
        this.zzeky = list;
    }

    final void zzk(JSONObject jSONObject) throws JSONException {
        zza zza2;
        int n;
        JSONArray jSONArray;
        if (jSONObject.has("breaks")) {
            jSONArray = jSONObject.getJSONArray("breaks");
            this.zzeky = new ArrayList<AdBreakInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zza2 = AdBreakInfo.zzi(jSONArray.getJSONObject(n));
                if (zza2 == null) {
                    this.zzeky.clear();
                    break;
                }
                this.zzeky.add((AdBreakInfo)zza2);
            }
        }
        if (jSONObject.has("breakClips")) {
            jSONArray = jSONObject.getJSONArray("breakClips");
            this.zzekz = new ArrayList<AdBreakClipInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zza2 = AdBreakClipInfo.zzh(jSONArray.getJSONObject(n));
                if (zza2 == null) {
                    this.zzekz.clear();
                    return;
                }
                this.zzekz.add((AdBreakClipInfo)zza2);
            }
        }
    }

    private final void zzabo() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzekr)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzekt)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzeks == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.zzekr);
            switch (this.zzeks) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzekt != null) {
                jSONObject.put("contentType", (Object)this.zzekt);
            }
            if (this.zzeku != null) {
                jSONObject.put("metadata", (Object)this.zzeku.toJson());
            }
            if (this.zzekv <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", (double)this.zzekv / 1000.0);
            }
            if (this.zzekw != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzekw) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzekx != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzekx.toJson());
            }
            if (this.zzehn != null) {
                jSONObject.put("customData", (Object)this.zzehn);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)((Object)object);
        if (this.zzehn == null != (mediaInfo.zzehn == null)) {
            return false;
        }
        if (this.zzehn != null && mediaInfo.zzehn != null && !zzn.zzc((Object)this.zzehn, (Object)mediaInfo.zzehn)) {
            return false;
        }
        return zzazf.zza(this.zzekr, mediaInfo.zzekr) && this.zzeks == mediaInfo.zzeks && zzazf.zza(this.zzekt, mediaInfo.zzekt) && zzazf.zza(this.zzeku, mediaInfo.zzeku) && this.zzekv == mediaInfo.zzekv && zzazf.zza(this.zzekw, mediaInfo.zzekw) && zzazf.zza(this.zzekx, mediaInfo.zzekx) && zzazf.zza(this.zzeky, mediaInfo.zzeky) && zzazf.zza(this.zzekz, mediaInfo.zzekz);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzekr, this.zzeks, this.zzekt, this.zzeku, this.zzekv, String.valueOf(this.zzehn), this.zzekw, this.zzekx, this.zzeky, this.zzekz});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzehm = this.zzehn == null ? null : this.zzehn.toString();
        Parcel parcel2 = parcel;
        MediaInfo mediaInfo = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)mediaInfo.getContentId(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, (int)mediaInfo.getStreamType());
        zzd.zza((Parcel)parcel2, (int)4, (String)mediaInfo.getContentType(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)mediaInfo.getMetadata(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (long)mediaInfo.getStreamDuration());
        zzd.zzc((Parcel)parcel2, (int)7, mediaInfo.getMediaTracks(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)8, (Parcelable)mediaInfo.getTextTrackStyle(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (String)mediaInfo.zzehm, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)10, mediaInfo.getAdBreaks(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)11, mediaInfo.getAdBreakClips(), (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private final MediaInfo zzela;

        public Builder(String string2) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzela = new MediaInfo(string2);
        }

        public Builder setStreamType(int n) throws IllegalArgumentException {
            this.zzela.setStreamType(n);
            return this;
        }

        public Builder setContentType(String string2) throws IllegalArgumentException {
            this.zzela.setContentType(string2);
            return this;
        }

        public Builder setMetadata(MediaMetadata mediaMetadata) {
            this.zzela.zza(mediaMetadata);
            return this;
        }

        public Builder setStreamDuration(long l) throws IllegalArgumentException {
            this.zzela.zzw(l);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzela.setCustomData(jSONObject);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> list) {
            this.zzela.zzw(list);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzela.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzela.zzabo();
            return this.zzela;
        }
    }
}

