/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.zzag;
import com.google.android.gms.cast.zzah;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.internal.zzazf;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem
extends zza {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    public static final Parcelable.Creator<MediaQueueItem> CREATOR = new zzah();
    private MediaInfo zzeli;
    private int zzelj;
    private boolean zzelk;
    private double zzell;
    private double zzelm;
    private double zzeln;
    private long[] zzelo;
    private String zzehm;
    private JSONObject zzehn;

    MediaQueueItem(MediaInfo mediaInfo, int n, boolean bl, double d, double d2, double d3, long[] lArray, String string2) {
        this.zzeli = mediaInfo;
        this.zzelj = n;
        this.zzelk = bl;
        this.zzell = d;
        this.zzelm = d2;
        this.zzeln = d3;
        this.zzelo = lArray;
        this.zzehm = string2;
        if (this.zzehm != null) {
            try {
                this.zzehn = new JSONObject(this.zzehm);
                return;
            }
            catch (JSONException jSONException) {
                this.zzehn = null;
                this.zzehm = null;
                return;
            }
        }
        this.zzehn = null;
    }

    private MediaQueueItem(MediaInfo mediaInfo) throws IllegalArgumentException {
        this(mediaInfo, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        if (mediaInfo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
    }

    MediaQueueItem(JSONObject jSONObject) throws JSONException {
        this(null, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        this.zzm(jSONObject);
    }

    private MediaQueueItem(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
        this(mediaQueueItem.getMedia(), mediaQueueItem.getItemId(), mediaQueueItem.getAutoplay(), mediaQueueItem.getStartTime(), mediaQueueItem.getPlaybackDuration(), mediaQueueItem.getPreloadTime(), mediaQueueItem.getActiveTrackIds(), null);
        if (this.zzeli == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzehn = mediaQueueItem.getCustomData();
    }

    public final boolean zzm(JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzeli = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzelj != (n = jSONObject.getInt("itemId"))) {
            this.zzelj = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzelk != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzelk = n;
            bl = true;
        }
        if (jSONObject.has("startTime")) {
            double d;
            double d2 = jSONObject.getDouble("startTime");
            if (Math.abs(d - this.zzell) > 1.0E-7) {
                this.zzell = d2;
                bl = true;
            }
        }
        if (jSONObject.has("playbackDuration")) {
            double d;
            double d3 = jSONObject.getDouble("playbackDuration");
            if (Math.abs(d - this.zzelm) > 1.0E-7) {
                this.zzelm = d3;
                bl = true;
            }
        }
        if (jSONObject.has("preloadTime")) {
            double d;
            double d4 = jSONObject.getDouble("preloadTime");
            if (Math.abs(d - this.zzeln) > 1.0E-7) {
                this.zzeln = d4;
                bl = true;
            }
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzelo == null) {
                bl2 = true;
            } else if (this.zzelo.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzelo[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzelo = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzehn = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zzeli;
    }

    public int getItemId() {
        return this.zzelj;
    }

    final void zzaz(int n) {
        this.zzelj = 0;
    }

    public boolean getAutoplay() {
        return this.zzelk;
    }

    final void zzav(boolean bl) {
        this.zzelk = bl;
    }

    public double getStartTime() {
        return this.zzell;
    }

    final void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzell = d;
    }

    public double getPlaybackDuration() {
        return this.zzelm;
    }

    final void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.zzelm = d;
    }

    public double getPreloadTime() {
        return this.zzeln;
    }

    final void zze(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzeln = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzelo;
    }

    final void zza(long[] lArray) {
        this.zzelo = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzehn;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzehn = jSONObject;
    }

    final void zzabo() throws IllegalArgumentException {
        if (this.zzeli == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzell) || this.zzell < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzelm)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzeln) || this.zzeln < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzeli.toJson());
            if (this.zzelj != 0) {
                jSONObject.put("itemId", this.zzelj);
            }
            jSONObject.put("autoplay", this.zzelk);
            jSONObject.put("startTime", this.zzell);
            if (this.zzelm != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzelm);
            }
            jSONObject.put("preloadTime", this.zzeln);
            if (this.zzelo != null) {
                JSONArray jSONArray = new JSONArray();
                long[] lArray = this.zzelo;
                int n = this.zzelo.length;
                for (int i = 0; i < n; ++i) {
                    long l = lArray[i];
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzehn != null) {
                jSONObject.put("customData", (Object)this.zzehn);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)((Object)object);
        if (this.zzehn == null != (mediaQueueItem.zzehn == null)) {
            return false;
        }
        if (this.zzehn != null && mediaQueueItem.zzehn != null && !zzn.zzc((Object)this.zzehn, (Object)mediaQueueItem.zzehn)) {
            return false;
        }
        return zzazf.zza(this.zzeli, mediaQueueItem.zzeli) && this.zzelj == mediaQueueItem.zzelj && this.zzelk == mediaQueueItem.zzelk && this.zzell == mediaQueueItem.zzell && this.zzelm == mediaQueueItem.zzelm && this.zzeln == mediaQueueItem.zzeln && Arrays.equals(this.zzelo, mediaQueueItem.zzelo);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzeli, this.zzelj, this.zzelk, this.zzell, this.zzelm, this.zzeln, Arrays.hashCode(this.zzelo), String.valueOf(this.zzehn)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzehm = this.zzehn == null ? null : this.zzehn.toString();
        Parcel parcel2 = parcel;
        MediaQueueItem mediaQueueItem = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)mediaQueueItem.getMedia(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, (int)mediaQueueItem.getItemId());
        zzd.zza((Parcel)parcel2, (int)4, (boolean)mediaQueueItem.getAutoplay());
        zzd.zza((Parcel)parcel2, (int)5, (double)mediaQueueItem.getStartTime());
        zzd.zza((Parcel)parcel2, (int)6, (double)mediaQueueItem.getPlaybackDuration());
        zzd.zza((Parcel)parcel2, (int)7, (double)mediaQueueItem.getPreloadTime());
        zzd.zza((Parcel)parcel2, (int)8, (long[])mediaQueueItem.getActiveTrackIds(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (String)mediaQueueItem.zzehm, (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ MediaQueueItem(MediaInfo mediaInfo, zzag zzag2) throws IllegalArgumentException {
        this(mediaInfo);
    }

    /* synthetic */ MediaQueueItem(MediaQueueItem mediaQueueItem, zzag zzag2) throws IllegalArgumentException {
        this(mediaQueueItem);
    }

    public static class Builder {
        private final MediaQueueItem zzelp;

        public Builder(MediaInfo mediaInfo) throws IllegalArgumentException {
            this.zzelp = new MediaQueueItem(mediaInfo, null);
        }

        public Builder(JSONObject jSONObject) throws JSONException {
            this.zzelp = new MediaQueueItem(jSONObject);
        }

        public Builder(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
            this.zzelp = new MediaQueueItem(mediaQueueItem, null);
        }

        public Builder clearItemId() {
            this.zzelp.zzaz(0);
            return this;
        }

        public Builder setAutoplay(boolean bl) {
            this.zzelp.zzav(bl);
            return this;
        }

        public Builder setStartTime(double d) throws IllegalArgumentException {
            this.zzelp.zzc(d);
            return this;
        }

        public Builder setPlaybackDuration(double d) {
            this.zzelp.zzd(d);
            return this;
        }

        public Builder setPreloadTime(double d) throws IllegalArgumentException {
            this.zzelp.zze(d);
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.zzelp.zza(lArray);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzelp.setCustomData(jSONObject);
            return this;
        }

        public MediaQueueItem build() {
            this.zzelp.zzabo();
            return this.zzelp;
        }
    }
}

