/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.zzbk;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzazf;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle
extends zza {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    public static final Parcelable.Creator<TextTrackStyle> CREATOR = new zzbk();
    private float zzens;
    private int zzent;
    private int zzbrh;
    private int zzenu;
    private int zzenv;
    private int zzenw;
    private int zzenx;
    private int zzeny;
    private String zzenz;
    private int zzeoa;
    private int zzeob;
    private String zzehm;
    private JSONObject zzehn;

    TextTrackStyle(float f, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string2, int n8, int n9, String string3) {
        this.zzens = f;
        this.zzent = n;
        this.zzbrh = n2;
        this.zzenu = n3;
        this.zzenv = n4;
        this.zzenw = n5;
        this.zzenx = n6;
        this.zzeny = n7;
        this.zzenz = string2;
        this.zzeoa = n8;
        this.zzeob = n9;
        this.zzehm = string3;
        if (this.zzehm != null) {
            try {
                this.zzehn = new JSONObject(this.zzehm);
                return;
            }
            catch (JSONException jSONException) {
                this.zzehn = null;
                this.zzehm = null;
                return;
            }
        }
        this.zzehn = null;
    }

    public TextTrackStyle() {
        this(1.0f, 0, 0, -1, 0, -1, 0, 0, null, -1, -1, null);
    }

    public final void setFontScale(float f) {
        this.zzens = f;
    }

    public final float getFontScale() {
        return this.zzens;
    }

    public final void setForegroundColor(int n) {
        this.zzent = n;
    }

    public final int getForegroundColor() {
        return this.zzent;
    }

    public final void setBackgroundColor(int n) {
        this.zzbrh = n;
    }

    public final int getBackgroundColor() {
        return this.zzbrh;
    }

    public final void setEdgeType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzenu = n;
    }

    public final int getEdgeType() {
        return this.zzenu;
    }

    public final void setEdgeColor(int n) {
        this.zzenv = n;
    }

    public final int getEdgeColor() {
        return this.zzenv;
    }

    public final void setWindowType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzenw = n;
    }

    public final int getWindowType() {
        return this.zzenw;
    }

    public final void setWindowColor(int n) {
        this.zzenx = n;
    }

    public final int getWindowColor() {
        return this.zzenx;
    }

    public final void setWindowCornerRadius(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzeny = n;
    }

    public final int getWindowCornerRadius() {
        return this.zzeny;
    }

    public final void setFontFamily(String string2) {
        this.zzenz = string2;
    }

    public final String getFontFamily() {
        return this.zzenz;
    }

    public final void setFontGenericFamily(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzeoa = n;
    }

    public final int getFontGenericFamily() {
        return this.zzeoa;
    }

    public final void setFontStyle(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzeob = n;
    }

    public final int getFontStyle() {
        return this.zzeob;
    }

    public final void setCustomData(JSONObject jSONObject) {
        this.zzehn = jSONObject;
    }

    public final JSONObject getCustomData() {
        return this.zzehn;
    }

    @TargetApi(value=19)
    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzp.zzalh()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (!Typeface.SANS_SERIF.equals((Object)typeface) && Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public final void zzl(JSONObject jSONObject) throws JSONException {
        String string2;
        this.zzens = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzent = TextTrackStyle.zzez(jSONObject.optString("foregroundColor"));
        this.zzbrh = TextTrackStyle.zzez(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.zzenu = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.zzenu = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.zzenu = 2;
            } else if ("RAISED".equals(string2)) {
                this.zzenu = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.zzenu = 4;
            }
        }
        this.zzenv = TextTrackStyle.zzez(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.zzenw = 0;
            } else if ("NORMAL".equals(string2)) {
                this.zzenw = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.zzenw = 2;
            }
        }
        this.zzenx = TextTrackStyle.zzez(jSONObject.optString("windowColor"));
        if (this.zzenw == 2) {
            this.zzeny = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzenz = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.zzeoa = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.zzeoa = 1;
            } else if ("SERIF".equals(string2)) {
                this.zzeoa = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.zzeoa = 3;
            } else if ("CASUAL".equals(string2)) {
                this.zzeoa = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.zzeoa = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.zzeoa = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.zzeob = 0;
            } else if ("BOLD".equals(string2)) {
                this.zzeob = 1;
            } else if ("ITALIC".equals(string2)) {
                this.zzeob = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.zzeob = 3;
            }
        }
        this.zzehn = jSONObject.optJSONObject("customData");
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzens);
            if (this.zzent != 0) {
                jSONObject.put("foregroundColor", (Object)TextTrackStyle.zzbc(this.zzent));
            }
            if (this.zzbrh != 0) {
                jSONObject.put("backgroundColor", (Object)TextTrackStyle.zzbc(this.zzbrh));
            }
            switch (this.zzenu) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                }
            }
            if (this.zzenv != 0) {
                jSONObject.put("edgeColor", (Object)TextTrackStyle.zzbc(this.zzenv));
            }
            switch (this.zzenw) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                }
            }
            if (this.zzenx != 0) {
                jSONObject.put("windowColor", (Object)TextTrackStyle.zzbc(this.zzenx));
            }
            if (this.zzenw == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzeny);
            }
            if (this.zzenz != null) {
                jSONObject.put("fontFamily", (Object)this.zzenz);
            }
            switch (this.zzeoa) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                }
            }
            switch (this.zzeob) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                }
            }
            if (this.zzehn != null) {
                jSONObject.put("customData", (Object)this.zzehn);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    private static String zzbc(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private static int zzez(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string2.substring(1, 3), 16);
                int n2 = Integer.parseInt(string2.substring(3, 5), 16);
                int n3 = Integer.parseInt(string2.substring(5, 7), 16);
                return Color.argb((int)Integer.parseInt(string2.substring(7, 9), 16), (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)((Object)object);
        if (this.zzehn == null != (textTrackStyle.zzehn == null)) {
            return false;
        }
        if (this.zzehn != null && textTrackStyle.zzehn != null && !zzn.zzc((Object)this.zzehn, (Object)textTrackStyle.zzehn)) {
            return false;
        }
        return this.zzens == textTrackStyle.zzens && this.zzent == textTrackStyle.zzent && this.zzbrh == textTrackStyle.zzbrh && this.zzenu == textTrackStyle.zzenu && this.zzenv == textTrackStyle.zzenv && this.zzenw == textTrackStyle.zzenw && this.zzeny == textTrackStyle.zzeny && zzazf.zza(this.zzenz, textTrackStyle.zzenz) && this.zzeoa == textTrackStyle.zzeoa && this.zzeob == textTrackStyle.zzeob;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.zzens), this.zzent, this.zzbrh, this.zzenu, this.zzenv, this.zzenw, this.zzenx, this.zzeny, this.zzenz, this.zzeoa, this.zzeob, String.valueOf(this.zzehn)});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzehm = this.zzehn == null ? null : this.zzehn.toString();
        Parcel parcel2 = parcel;
        TextTrackStyle textTrackStyle = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (float)textTrackStyle.getFontScale());
        zzd.zzc((Parcel)parcel2, (int)3, (int)textTrackStyle.getForegroundColor());
        zzd.zzc((Parcel)parcel2, (int)4, (int)textTrackStyle.getBackgroundColor());
        zzd.zzc((Parcel)parcel2, (int)5, (int)textTrackStyle.getEdgeType());
        zzd.zzc((Parcel)parcel2, (int)6, (int)textTrackStyle.getEdgeColor());
        zzd.zzc((Parcel)parcel2, (int)7, (int)textTrackStyle.getWindowType());
        zzd.zzc((Parcel)parcel2, (int)8, (int)textTrackStyle.getWindowColor());
        zzd.zzc((Parcel)parcel2, (int)9, (int)textTrackStyle.getWindowCornerRadius());
        zzd.zza((Parcel)parcel2, (int)10, (String)textTrackStyle.getFontFamily(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)11, (int)textTrackStyle.getFontGenericFamily());
        zzd.zzc((Parcel)parcel2, (int)12, (int)textTrackStyle.getFontStyle());
        zzd.zza((Parcel)parcel2, (int)13, (String)textTrackStyle.zzehm, (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }
}

