/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.zzab;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzayr;
import com.google.android.gms.internal.zzayz;
import com.google.android.gms.internal.zzaza;
import com.google.android.gms.internal.zzazf;
import com.google.android.gms.internal.zzazg;
import com.google.android.gms.internal.zzazk;
import com.google.android.gms.internal.zzazl;
import com.google.android.gms.internal.zzazp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class zzayy
extends zzaa<zzazk> {
    private static final zzazp zzejl = new zzazp("CastClientImpl");
    private ApplicationMetadata zzfao;
    private final CastDevice zzepb;
    private final Cast.Listener zzeii;
    private final Map<String, Cast.MessageReceivedCallback> zzfap;
    private final long zzfaq;
    private final Bundle mExtras;
    private zzaza zzfar;
    private String zzfas;
    private boolean zzely;
    private boolean zzfat;
    private boolean zzfau;
    private boolean zzfav;
    private double zzelx;
    private int zzfaw;
    private int zzfax;
    private final AtomicLong zzfay;
    private String zzfaz;
    private String zzfba;
    private Bundle zzfbb;
    private final Map<Long, zzn<Status>> zzfbc;
    private zzn<Cast.ApplicationConnectionResult> zzfbd;
    private zzn<Status> zzfbe;
    private static final Object zzfbf = new Object();
    private static final Object zzfbg = new Object();

    public zzayy(Context context, Looper looper, zzq zzq2, CastDevice castDevice, long l, Cast.Listener listener, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzepb = castDevice;
        this.zzeii = listener;
        this.zzfaq = l;
        this.mExtras = bundle;
        this.zzfap = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzfay = new AtomicLong(0L);
        this.zzfbc = new HashMap<Long, zzn<Status>>();
        this.zzaef();
    }

    private final void zzaef() {
        this.zzfav = false;
        this.zzfaw = -1;
        this.zzfax = -1;
        this.zzfao = null;
        this.zzfas = null;
        this.zzelx = 0.0;
        this.zzely = false;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzejl.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzfav = true;
            this.zzfat = true;
            this.zzfau = true;
        } else {
            this.zzfav = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzfbb = new Bundle();
            this.zzfbb.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    public final void disconnect() {
        zzejl.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzfar, this.isConnected());
        zzaza zzaza2 = this.zzfar;
        this.zzfar = null;
        if (zzaza2 == null || zzaza2.zzaem() == null) {
            zzejl.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzaeh();
        try {
            ((zzazk)super.zzajj()).disconnect();
            return;
        }
        catch (RemoteException | IllegalStateException throwable) {
            zzejl.zzb(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
            return;
        }
        finally {
            super.disconnect();
        }
    }

    public final Bundle zzaeg() {
        if (this.zzfbb != null) {
            Bundle bundle = this.zzfbb;
            this.zzfbb = null;
            return bundle;
        }
        return super.zzaeg();
    }

    @NonNull
    protected final String zzhc() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @NonNull
    protected final String zzhd() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected final Bundle zzzs() {
        Bundle bundle = new Bundle();
        zzejl.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzfaz, this.zzfba);
        this.zzepb.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzfaq);
        if (this.mExtras != null) {
            bundle.putAll(this.mExtras);
        }
        this.zzfar = new zzaza(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzfar.asBinder()));
        if (this.zzfaz != null) {
            bundle.putString("last_application_id", this.zzfaz);
            if (this.zzfba != null) {
                bundle.putString("last_session_id", this.zzfba);
            }
        }
        return bundle;
    }

    public final void zza(String string2, String string3, zzn<Status> zzn2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzazf.zzfg(string2);
        this.zzaei();
        long l = this.zzfay.incrementAndGet();
        try {
            this.zzfbc.put(l, zzn2);
            ((zzazk)super.zzajj()).zzb(string2, string3, l);
            return;
        }
        catch (Throwable throwable) {
            this.zzfbc.remove(l);
            throw throwable;
        }
    }

    public final void zza(String string2, LaunchOptions launchOptions, zzn<Cast.ApplicationConnectionResult> zzn2) throws IllegalStateException, RemoteException {
        this.zza(zzn2);
        ((zzazk)super.zzajj()).zzb(string2, launchOptions);
    }

    public final void zza(String string2, String string3, zzab zzab2, zzn<Cast.ApplicationConnectionResult> zzn2) throws IllegalStateException, RemoteException {
        this.zza(zzn2);
        if (zzab2 == null) {
            zzab2 = new zzab();
        }
        ((zzazk)super.zzajj()).zza(string2, string3, zzab2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzn<Cast.ApplicationConnectionResult> zzn2) {
        Object object = zzfbf;
        synchronized (object) {
            if (this.zzfbd != null) {
                this.zzfbd.setResult((Object)new zzayz(new Status(2002)));
            }
            this.zzfbd = zzn2;
            return;
        }
    }

    public final void zzb(zzn<Status> zzn2) throws IllegalStateException, RemoteException {
        this.zzc(zzn2);
        ((zzazk)super.zzajj()).zzaeo();
    }

    public final void zza(String string2, zzn<Status> zzn2) throws IllegalStateException, RemoteException {
        this.zzc(zzn2);
        ((zzazk)super.zzajj()).zzfa(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzc(zzn<Status> zzn2) {
        Object object = zzfbg;
        synchronized (object) {
            if (this.zzfbe != null) {
                zzn2.setResult((Object)new Status(2001));
                return;
            }
            this.zzfbe = zzn2;
            return;
        }
    }

    public final void requestStatus() throws IllegalStateException, RemoteException {
        ((zzazk)super.zzajj()).requestStatus();
    }

    public final void setVolume(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        ((zzazk)super.zzajj()).zza(d, this.zzelx, this.zzely);
    }

    public final void setMute(boolean bl) throws IllegalStateException, RemoteException {
        ((zzazk)super.zzajj()).zza(bl, this.zzelx, this.zzely);
    }

    public final double getVolume() throws IllegalStateException {
        this.zzaei();
        return this.zzelx;
    }

    public final boolean isMute() throws IllegalStateException {
        this.zzaei();
        return this.zzely;
    }

    public final int getActiveInputState() throws IllegalStateException {
        this.zzaei();
        return this.zzfaw;
    }

    public final int getStandbyState() throws IllegalStateException {
        this.zzaei();
        return this.zzfax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzazf.zzfg(string2);
        this.removeMessageReceivedCallbacks(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzfap;
            synchronized (map) {
                this.zzfap.put(string2, messageReceivedCallback);
            }
            ((zzazk)super.zzajj()).zzfj(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMessageReceivedCallbacks(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzfap;
        synchronized (map) {
            messageReceivedCallback = this.zzfap.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzazk)super.zzajj()).zzfk(string2);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                zzejl.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public final ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzaei();
        return this.zzfao;
    }

    public final String getApplicationStatus() throws IllegalStateException {
        this.zzaei();
        return this.zzfas;
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzaeh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzaeh() {
        zzejl.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzfap;
        synchronized (map) {
            this.zzfap.clear();
            return;
        }
    }

    private final void zza(zzazg zzazg2) {
        boolean bl;
        ApplicationMetadata applicationMetadata = zzazg2.getApplicationMetadata();
        if (!zzazf.zza(applicationMetadata, this.zzfao)) {
            this.zzfao = applicationMetadata;
            this.zzeii.onApplicationMetadataChanged(this.zzfao);
        }
        boolean bl2 = false;
        double d = zzazg2.getVolume();
        if (!Double.isNaN(d) && Math.abs(d - this.zzelx) > 1.0E-7) {
            this.zzelx = d;
            bl2 = true;
        }
        if ((bl = zzazg2.zzaen()) != this.zzely) {
            this.zzely = bl;
            bl2 = true;
        }
        zzejl.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzfau);
        if (this.zzeii != null && (bl2 || this.zzfau)) {
            this.zzeii.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = zzazg2.getActiveInputState();
        if (n != this.zzfaw) {
            this.zzfaw = n;
            bl3 = true;
        }
        zzejl.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzfau);
        if (this.zzeii != null && (bl3 || this.zzfau)) {
            this.zzeii.onActiveInputStateChanged(this.zzfaw);
        }
        boolean bl4 = false;
        int n2 = zzazg2.getStandbyState();
        if (n2 != this.zzfax) {
            this.zzfax = n2;
            bl4 = true;
        }
        zzejl.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzfau);
        if (this.zzeii != null && (bl4 || this.zzfau)) {
            this.zzeii.onStandbyStateChanged(this.zzfax);
        }
        this.zzfau = false;
    }

    private final void zza(zzayr zzayr2) {
        boolean bl = false;
        String string2 = zzayr2.zzaec();
        if (!zzazf.zza(string2, this.zzfas)) {
            this.zzfas = string2;
            bl = true;
        }
        zzejl.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzfat);
        if (this.zzeii != null && (bl || this.zzfat)) {
            this.zzeii.onApplicationStatusChanged();
        }
        this.zzfat = false;
    }

    private final void zzaei() throws IllegalStateException {
        if (!this.zzfav || this.zzfar == null || this.zzfar.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected final /* synthetic */ IInterface zze(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.cast.internal.ICastDeviceController");
        if (iInterface instanceof zzazk) {
            return (zzazk)iInterface;
        }
        return new zzazl(iBinder2);
    }

    static /* synthetic */ void zzb(zzayy zzayy2) {
        zzayy2.zzaef();
    }

    static /* synthetic */ zzazp zzaej() {
        return zzejl;
    }

    static /* synthetic */ ApplicationMetadata zza(zzayy zzayy2, ApplicationMetadata applicationMetadata) {
        zzayy2.zzfao = applicationMetadata;
        return zzayy2.zzfao;
    }

    static /* synthetic */ String zza(zzayy zzayy2, String string2) {
        zzayy2.zzfaz = string2;
        return zzayy2.zzfaz;
    }

    static /* synthetic */ String zzb(zzayy zzayy2, String string2) {
        zzayy2.zzfba = string2;
        return zzayy2.zzfba;
    }

    static /* synthetic */ String zzc(zzayy zzayy2, String string2) {
        zzayy2.zzfas = string2;
        return zzayy2.zzfas;
    }

    static /* synthetic */ Object zzaek() {
        return zzfbf;
    }

    static /* synthetic */ zzn zzc(zzayy zzayy2) {
        return zzayy2.zzfbd;
    }

    static /* synthetic */ zzn zza(zzayy zzayy2, zzn zzn2) {
        zzayy2.zzfbd = null;
        return null;
    }

    static /* synthetic */ Cast.Listener zzd(zzayy zzayy2) {
        return zzayy2.zzeii;
    }

    static /* synthetic */ void zza(zzayy zzayy2, zzazg zzazg2) {
        zzayy2.zza(zzazg2);
    }

    static /* synthetic */ void zza(zzayy zzayy2, zzayr zzayr2) {
        zzayy2.zza(zzayr2);
    }

    static /* synthetic */ Map zze(zzayy zzayy2) {
        return zzayy2.zzfap;
    }

    static /* synthetic */ CastDevice zzf(zzayy zzayy2) {
        return zzayy2.zzepb;
    }

    static /* synthetic */ Map zzg(zzayy zzayy2) {
        return zzayy2.zzfbc;
    }

    static /* synthetic */ Object zzael() {
        return zzfbg;
    }

    static /* synthetic */ zzn zzh(zzayy zzayy2) {
        return zzayy2.zzfbe;
    }

    static /* synthetic */ zzn zzb(zzayy zzayy2, zzn zzn2) {
        zzayy2.zzfbe = null;
        return null;
    }
}

