/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.internal.zzayu;
import com.google.android.gms.internal.zzazf;
import com.google.android.gms.internal.zzazr;
import com.google.android.gms.internal.zzazs;
import com.google.android.gms.internal.zzazu;
import com.google.android.gms.internal.zzazv;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzazq
extends zzayu {
    public static final String NAMESPACE = zzazf.zzfh("com.google.cast.media");
    private long zzfce;
    private MediaStatus zzfcf;
    private final List<zzazv> zzeyv;
    private zzazr zzfcg;
    private final zzazv zzfch;
    private final zzazv zzfci;
    private final zzazv zzfcj;
    private final zzazv zzfck;
    private final zzazv zzfcl;
    private final zzazv zzfcm;
    private final zzazv zzfcn;
    private final zzazv zzfco;
    private final zzazv zzfcp;
    private final zzazv zzfcq;
    private final zzazv zzfcr;
    private final zzazv zzfcs;
    private final zzazv zzfct;
    private final zzazv zzfcu;

    public zzazq(String string2, zzd zzd2) {
        super(NAMESPACE, zzd2, "MediaControlChannel", null, 1000L);
        this.zzfch = new zzazv(this.zzasl, 86400000L);
        this.zzfci = new zzazv(this.zzasl, 86400000L);
        this.zzfcj = new zzazv(this.zzasl, 86400000L);
        this.zzfck = new zzazv(this.zzasl, 86400000L);
        this.zzfcl = new zzazv(this.zzasl, 86400000L);
        this.zzfcm = new zzazv(this.zzasl, 86400000L);
        this.zzfcn = new zzazv(this.zzasl, 86400000L);
        this.zzfco = new zzazv(this.zzasl, 86400000L);
        this.zzfcp = new zzazv(this.zzasl, 86400000L);
        this.zzfcq = new zzazv(this.zzasl, 86400000L);
        this.zzfcr = new zzazv(this.zzasl, 86400000L);
        this.zzfcs = new zzazv(this.zzasl, 86400000L);
        this.zzfct = new zzazv(this.zzasl, 86400000L);
        this.zzfcu = new zzazv(this.zzasl, 86400000L);
        this.zzeyv = new ArrayList<zzazv>();
        this.zzeyv.add(this.zzfch);
        this.zzeyv.add(this.zzfci);
        this.zzeyv.add(this.zzfcj);
        this.zzeyv.add(this.zzfck);
        this.zzeyv.add(this.zzfcl);
        this.zzeyv.add(this.zzfcm);
        this.zzeyv.add(this.zzfcn);
        this.zzeyv.add(this.zzfco);
        this.zzeyv.add(this.zzfcp);
        this.zzeyv.add(this.zzfcq);
        this.zzeyv.add(this.zzfcr);
        this.zzeyv.add(this.zzfcs);
        this.zzeyv.add(this.zzfct);
        this.zzeyv.add(this.zzfcu);
        this.zzaeq();
    }

    public final void zza(zzazr zzazr2) {
        this.zzfcg = zzazr2;
    }

    public final long zza(zzazu zzazu2, MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzaee();
        this.zzfch.zza(l2, zzazu2);
        this.zzbb(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.toJson());
            jSONObject2.put("autoplay", bl);
            jSONObject2.put("currentTime", (double)l / 1000.0);
            if (lArray != null) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzazu zzazu2, JSONObject jSONObject) throws IOException, zzazs {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaee();
        this.zzfci.zza(l, zzazu2);
        this.zzbb(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzabp());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzb(zzazu zzazu2, JSONObject jSONObject) throws IOException, zzazs {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaee();
        this.zzfck.zza(l, zzazu2);
        this.zzbb(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzabp());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzc(zzazu zzazu2, JSONObject jSONObject) throws IOException, zzazs {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaee();
        this.zzfcj.zza(l, zzazu2);
        this.zzbb(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzabp());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzazu zzazu2, long l, int n, JSONObject jSONObject) throws IOException, zzazs {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzaee();
        this.zzfcl.zza(l2, zzazu2);
        this.zzbb(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zzabp());
            jSONObject2.put("currentTime", (double)l / 1000.0);
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzazu zzazu2, double d, JSONObject jSONObject) throws IOException, zzazs, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaee();
        this.zzfcm.zza(l, zzazu2);
        this.zzbb(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzabp());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzazu zzazu2, boolean bl, JSONObject jSONObject) throws IOException, zzazs {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaee();
        this.zzfcn.zza(l, zzazu2);
        this.zzbb(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzabp());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzazu zzazu2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzaee();
        this.zzfco.zza(l, zzazu2);
        this.zzbb(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzfcf != null) {
                jSONObject.put("mediaSessionId", this.zzfcf.zzabp());
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzazu zzazu2, long[] lArray) throws IOException, zzazs {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzaee();
        this.zzfcp.zza(l, zzazu2);
        this.zzbb(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzabp());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzazu zzazu2, TextTrackStyle textTrackStyle) throws IOException, zzazs {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzaee();
        this.zzfcq.zza(l, zzazu2);
        this.zzbb(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zzabp());
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zzfce == 0L) {
            return 0L;
        }
        double d = this.zzfcf.getPlaybackRate();
        long l = this.zzfcf.getStreamPosition();
        int n = this.zzfcf.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        long l2 = mediaInfo.getStreamDuration();
        zzazq zzazq2 = this;
        long l3 = zzazq2.zzasl.elapsedRealtime() - zzazq2.zzfce;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l;
        }
        long l4 = l + (long)((double)l3 * d);
        if (l2 > 0L && l4 > l2) {
            l4 = l2;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public final long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo != null) {
            return mediaInfo.getStreamDuration();
        }
        return 0L;
    }

    public final MediaStatus getMediaStatus() {
        return this.zzfcf;
    }

    public final MediaInfo getMediaInfo() {
        if (this.zzfcf == null) {
            return null;
        }
        return this.zzfcf.getMediaInfo();
    }

    public final long zza(zzazu zzazu2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IOException, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= mediaQueueItemArray.length) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Invalid startIndex: ").append(n).toString());
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzaee();
        this.zzfch.zza(l2, zzazu2);
        this.zzbb(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            switch (n2) {
                case 0: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                    break;
                }
                case 1: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                    break;
                }
                case 2: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                    break;
                }
                case 3: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(32).append("Invalid repeat mode: ").append(n2).toString());
                }
            }
            jSONObject2.put("startIndex", n);
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzazu zzazu2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, int n3, long l, JSONObject jSONObject) throws IOException, zzazs, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        if (n3 != -1 && (n3 < 0 || n3 >= mediaQueueItemArray.length)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "currentItemIndexInItemsToInsert %d out of range [0, %d).", n3, mediaQueueItemArray.length));
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzaee();
        this.zzfcr.zza(l2, zzazu2);
        this.zzbb(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zzabp());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (n3 != -1) {
                jSONObject2.put("currentItemIndex", n3);
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzazu zzazu2, int n, long l, MediaQueueItem[] mediaQueueItemArray, int n2, Integer n3, JSONObject jSONObject) throws IllegalArgumentException, IOException, zzazs {
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(53).append("playPosition cannot be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzaee();
        this.zzfcs.zza(l2, zzazu2);
        this.zzbb(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zzabp());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && mediaQueueItemArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                    jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                        break;
                    }
                    case 1: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                        break;
                    }
                    case 2: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                        break;
                    }
                    case 3: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    }
                }
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzazu zzazu2, int[] nArray, JSONObject jSONObject) throws IOException, zzazs, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaee();
        this.zzfct.zza(l, zzazu2);
        this.zzbb(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zzabp());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzazu zzazu2, int[] nArray, int n, JSONObject jSONObject) throws IOException, zzazs, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaee();
        this.zzfcu.zza(l, zzazu2);
        this.zzbb(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zzabp());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    @Override
    public final void zzff(String string2) {
        this.zzejb.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            switch (string3) {
                case "MEDIA_STATUS": {
                    JSONArray jSONArray = jSONObject.getJSONArray("status");
                    if (jSONArray.length() > 0) {
                        this.zza(l, jSONArray.getJSONObject(0));
                        return;
                    }
                    this.zzfcf = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.onQueueStatusUpdated();
                    this.onPreloadStatusUpdated();
                    this.zzfco.zzc(l, 0, null);
                    return;
                }
                case "INVALID_PLAYER_STATE": {
                    this.zzejb.zzf("received unexpected error: Invalid Player State.", new Object[0]);
                    JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                    Iterator<zzazv> iterator = this.zzeyv.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().zzc(l, 2100, jSONObject2);
                    }
                    return;
                }
                case "LOAD_FAILED": {
                    JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                    this.zzfch.zzc(l, 2100, jSONObject3);
                    return;
                }
                case "LOAD_CANCELLED": {
                    JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                    this.zzfch.zzc(l, 2101, jSONObject4);
                    return;
                }
                case "INVALID_REQUEST": {
                    this.zzejb.zzf("received unexpected error: Invalid Request.", new Object[0]);
                    JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                    Iterator<zzazv> iterator = this.zzeyv.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().zzc(l, 2100, jSONObject5);
                    }
                    break;
                }
            }
            return;
        }
        catch (JSONException jSONException) {
            this.zzejb.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
    }

    private final void zza(long l, JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = this.zzfch.test(l);
        boolean bl2 = this.zzfcl.zzaes() && !this.zzfcl.test(l);
        boolean bl3 = this.zzfcm.zzaes() && !this.zzfcm.test(l) || this.zzfcn.zzaes() && !this.zzfcn.test(l);
        int n2 = 0;
        if (bl2) {
            n2 = 2;
        }
        if (bl3) {
            n2 |= 1;
        }
        if (bl || this.zzfcf == null) {
            this.zzfcf = new MediaStatus(jSONObject);
            this.zzfce = this.zzasl.elapsedRealtime();
            n = 127;
        } else {
            n = this.zzfcf.zza(jSONObject, n2);
        }
        if ((n & 1) != 0) {
            this.zzfce = this.zzasl.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 2) != 0) {
            this.zzfce = this.zzasl.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 4) != 0) {
            this.onMetadataUpdated();
        }
        if ((n & 8) != 0) {
            this.onQueueStatusUpdated();
        }
        if ((n & 0x10) != 0) {
            this.onPreloadStatusUpdated();
        }
        if ((n & 0x20) != 0) {
            this.zzfce = this.zzasl.elapsedRealtime();
            zzazq zzazq2 = this;
            if (zzazq2.zzfcg != null) {
                zzazq2.zzfcg.onAdBreakStatusUpdated();
            }
        }
        if ((n & 0x40) != 0) {
            this.zzfce = this.zzasl.elapsedRealtime();
            this.onStatusUpdated();
        }
        Iterator<zzazv> iterator = this.zzeyv.iterator();
        while (iterator.hasNext()) {
            long l2 = l;
            iterator.next().zzc(l2, 0, null);
        }
    }

    private final long zzabp() throws zzazs {
        if (this.zzfcf == null) {
            throw new zzazs();
        }
        return this.zzfcf.zzabp();
    }

    private final void onStatusUpdated() {
        if (this.zzfcg != null) {
            this.zzfcg.onStatusUpdated();
        }
    }

    private final void onMetadataUpdated() {
        if (this.zzfcg != null) {
            this.zzfcg.onMetadataUpdated();
        }
    }

    private final void onQueueStatusUpdated() {
        if (this.zzfcg != null) {
            this.zzfcg.onQueueStatusUpdated();
        }
    }

    private final void onPreloadStatusUpdated() {
        if (this.zzfcg != null) {
            this.zzfcg.onPreloadStatusUpdated();
        }
    }

    private final void zzaeq() {
        this.zzfce = 0L;
        this.zzfcf = null;
        Iterator<zzazv> iterator = this.zzeyv.iterator();
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
    }

    @Override
    public final void zzaed() {
        super.zzaed();
        this.zzaeq();
    }

    @Override
    public final void zzc(long l, int n) {
        Iterator<zzazv> iterator = this.zzeyv.iterator();
        while (iterator.hasNext()) {
            int n2 = n;
            long l2 = l;
            iterator.next().zzc(l2, n2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zzz(long l) {
        Iterator<zzazv> iterator = this.zzeyv.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzd(l, 2102);
        }
        boolean bl = false;
        Object object = zzazv.zzajk;
        synchronized (object) {
            Iterator<zzazv> iterator2 = this.zzeyv.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().zzaes()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

