/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.zzd;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ApplicationMetadata
extends zzbfm {
    public static final Parcelable.Creator<ApplicationMetadata> CREATOR = new zzd();
    private String zzenh;
    private String mName;
    private List<WebImage> zzbtt;
    private List<String> zzeni;
    private String zzenj;
    private Uri zzenk;

    ApplicationMetadata(String string, String string2, List<WebImage> list, List<String> list2, String string3, Uri uri) {
        this.zzenh = string;
        this.mName = string2;
        this.zzbtt = list;
        this.zzeni = list2;
        this.zzenj = string3;
        this.zzenk = uri;
    }

    private ApplicationMetadata() {
        this.zzbtt = new ArrayList<WebImage>();
        this.zzeni = new ArrayList<String>();
    }

    public String getApplicationId() {
        return this.zzenh;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isNamespaceSupported(String string) {
        return this.zzeni != null && this.zzeni.contains(string);
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzeni);
    }

    public boolean areNamespacesSupported(List<String> list) {
        return this.zzeni != null && this.zzeni.containsAll(list);
    }

    public String getSenderAppIdentifier() {
        return this.zzenj;
    }

    public List<WebImage> getImages() {
        return this.zzbtt;
    }

    public String toString() {
        return "applicationId: " + this.zzenh + ", name: " + this.mName + ", images.count: " + (this.zzbtt == null ? 0 : this.zzbtt.size()) + ", namespaces.count: " + (this.zzeni == null ? 0 : this.zzeni.size()) + ", senderAppIdentifier: " + this.zzenj + ", senderAppLaunchUrl: " + this.zzenk;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ApplicationMetadata applicationMetadata = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)applicationMetadata.getApplicationId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (String)applicationMetadata.getName(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)4, applicationMetadata.getImages(), (boolean)false);
        zzbfp.zzb((Parcel)parcel2, (int)5, applicationMetadata.getSupportedNamespaces(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (String)applicationMetadata.getSenderAppIdentifier(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (Parcelable)applicationMetadata.zzenk, (int)n, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzenh, this.mName, this.zzbtt, this.zzeni, this.zzenj, this.zzenk});
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ApplicationMetadata)) {
            return false;
        }
        ApplicationMetadata applicationMetadata = (ApplicationMetadata)((Object)object);
        return zzbcm.zza(this.zzenh, applicationMetadata.zzenh) && zzbcm.zza(this.zzbtt, applicationMetadata.zzbtt) && zzbcm.zza(this.mName, applicationMetadata.mName) && zzbcm.zza(this.zzeni, applicationMetadata.zzeni) && zzbcm.zza(this.zzenj, applicationMetadata.zzenj) && zzbcm.zza(this.zzenk, applicationMetadata.zzenk);
    }
}

