/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.cast.zzn;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
extends zzbfm
implements ReflectedParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final int CAPABILITY_MULTIZONE_GROUP = 32;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzn();
    private String zzenw;
    private String zzenx;
    private Inet4Address zzeny;
    private String zzenz;
    private String zzeoa;
    private String zzeob;
    private int zzeoc;
    private List<WebImage> zzeod;
    private int zzeoe;
    private int zzcbc;
    private String zzeof;
    private String zzeog;
    private int zzeoh;

    CastDevice(String string, String string2, String string3, String string4, String string5, int n, List<WebImage> arrayList, int n2, int n3, String string6, String string7, int n4) {
        this.zzenw = CastDevice.zzfc(string);
        this.zzenx = CastDevice.zzfc(string2);
        if (!TextUtils.isEmpty((CharSequence)this.zzenx)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzenx);
                if (inetAddress instanceof Inet4Address) {
                    this.zzeny = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                String string8 = this.zzenx;
                String string9 = unknownHostException.getMessage();
                Log.i((String)"CastDevice", (String)new StringBuilder(48 + String.valueOf(string8).length() + String.valueOf(string9).length()).append("Unable to convert host address (").append(string8).append(") to ipaddress: ").append(string9).toString());
            }
        }
        this.zzenz = CastDevice.zzfc(string3);
        this.zzeoa = CastDevice.zzfc(string4);
        this.zzeob = CastDevice.zzfc(string5);
        this.zzeoc = n;
        this.zzeod = arrayList != null ? arrayList : new ArrayList();
        this.zzeoe = n2;
        this.zzcbc = n3;
        this.zzeof = CastDevice.zzfc(string6);
        this.zzeog = string7;
        this.zzeoh = n4;
    }

    public String getDeviceId() {
        if (this.zzenw.startsWith("__cast_nearby__")) {
            return this.zzenw.substring(16);
        }
        return this.zzenw;
    }

    public Inet4Address getIpAddress() {
        return this.zzeny;
    }

    public String getFriendlyName() {
        return this.zzenz;
    }

    public String getModelName() {
        return this.zzeoa;
    }

    public String getDeviceVersion() {
        return this.zzeob;
    }

    public int getServicePort() {
        return this.zzeoc;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzeod);
    }

    public WebImage getIcon(int n, int n2) {
        if (this.zzeod.isEmpty()) {
            return null;
        }
        if (n <= 0 || n2 <= 0) {
            return this.zzeod.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzeod) {
            int n3 = webImage3.getWidth();
            int n4 = webImage3.getHeight();
            if (n3 >= n && n4 >= n2) {
                if (webImage != null && (webImage.getWidth() <= n3 || webImage.getHeight() <= n4)) continue;
                webImage = webImage3;
                continue;
            }
            if (n3 >= n || n4 >= n2 || webImage2 != null && (webImage2.getWidth() >= n3 || webImage2.getHeight() >= n4)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzeod.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzeod.isEmpty();
    }

    public boolean hasCapability(int n) {
        return (this.zzeoe & n) == n;
    }

    public boolean hasCapabilities(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.hasCapability(n2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzenz, this.zzenw);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastDevice castDevice = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)castDevice.zzenw, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (String)castDevice.zzenx, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (String)castDevice.getFriendlyName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (String)castDevice.getModelName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (String)castDevice.getDeviceVersion(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)7, (int)castDevice.getServicePort());
        zzbfp.zzc((Parcel)parcel2, (int)8, castDevice.getIcons(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)9, (int)castDevice.zzeoe);
        zzbfp.zzc((Parcel)parcel2, (int)10, (int)castDevice.zzcbc);
        zzbfp.zza((Parcel)parcel2, (int)11, (String)castDevice.zzeof, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)12, (String)castDevice.zzeog, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)13, (int)castDevice.zzeoh);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)((Object)object);
        if (this.zzenw == null) {
            return castDevice.zzenw == null;
        }
        return zzbcm.zza(this.zzenw, castDevice.zzenw) && zzbcm.zza(this.zzeny, castDevice.zzeny) && zzbcm.zza(this.zzeoa, castDevice.zzeoa) && zzbcm.zza(this.zzenz, castDevice.zzenz) && zzbcm.zza(this.zzeob, castDevice.zzeob) && this.zzeoc == castDevice.zzeoc && zzbcm.zza(this.zzeod, castDevice.zzeod) && this.zzeoe == castDevice.zzeoe && this.zzcbc == castDevice.zzcbc && zzbcm.zza(this.zzeof, castDevice.zzeof) && zzbcm.zza(this.zzeoh, castDevice.zzeoh);
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.zzenw == null) {
            return castDevice.zzenw == null;
        }
        return zzbcm.zza(this.zzenw, castDevice.zzenw);
    }

    public int hashCode() {
        if (this.zzenw == null) {
            return 0;
        }
        return this.zzenw.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)bundle.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzenw.startsWith("__cast_nearby__");
    }

    private static String zzfc(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

