/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.zzae;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaInfo
extends zzbfm
implements ReflectedParcelable {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    public static final Parcelable.Creator<MediaInfo> CREATOR = new zzae();
    private final String zzeqc;
    private int zzeqd;
    private String zzeqe;
    private MediaMetadata zzeqf;
    private long zzeqg;
    private List<MediaTrack> zzeqh;
    private TextTrackStyle zzeqi;
    private String zzemx;
    private List<AdBreakInfo> zzeqj;
    private List<AdBreakClipInfo> zzeqk;
    private JSONObject zzemy;

    MediaInfo(String string2, int n, String string3, MediaMetadata mediaMetadata, long l, List<MediaTrack> list, TextTrackStyle textTrackStyle, String string4, List<AdBreakInfo> list2, List<AdBreakClipInfo> list3) {
        this.zzeqc = string2;
        this.zzeqd = n;
        this.zzeqe = string3;
        this.zzeqf = mediaMetadata;
        this.zzeqg = l;
        this.zzeqh = list;
        this.zzeqi = textTrackStyle;
        this.zzemx = string4;
        if (this.zzemx != null) {
            try {
                this.zzemy = new JSONObject(this.zzemx);
            }
            catch (JSONException jSONException) {
                this.zzemy = null;
                this.zzemx = null;
            }
        } else {
            this.zzemy = null;
        }
        this.zzeqj = list2;
        this.zzeqk = list3;
    }

    MediaInfo(String string2) throws IllegalArgumentException {
        this(string2, -1, null, null, -1L, null, null, null, null, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
    }

    MediaInfo(JSONObject jSONObject) throws JSONException {
        this(jSONObject.getString("contentId"), -1, null, null, -1L, null, null, null, null, null);
        double d;
        int n;
        JSONObject jSONObject2;
        String string2 = jSONObject.getString("streamType");
        this.zzeqd = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzeqe = jSONObject.getString("contentType");
        if (jSONObject.has("metadata")) {
            jSONObject2 = jSONObject.getJSONObject("metadata");
            n = jSONObject2.getInt("metadataType");
            this.zzeqf = new MediaMetadata(n);
            this.zzeqf.zzu(jSONObject2);
        }
        this.zzeqg = -1L;
        if (jSONObject.has("duration") && !jSONObject.isNull("duration") && !Double.isNaN(d = jSONObject.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzeqg = (long)(d * 1000.0);
        }
        if (jSONObject.has("tracks")) {
            this.zzeqh = new ArrayList<MediaTrack>();
            jSONObject2 = jSONObject.getJSONArray("tracks");
            for (n = 0; n < jSONObject2.length(); ++n) {
                JSONObject jSONObject3 = jSONObject2.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject3);
                this.zzeqh.add(mediaTrack);
            }
        } else {
            this.zzeqh = null;
        }
        if (jSONObject.has("textTrackStyle")) {
            jSONObject2 = jSONObject.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzu(jSONObject2);
            this.zzeqi = textTrackStyle;
        } else {
            this.zzeqi = null;
        }
        this.zzt(jSONObject);
        this.zzemy = jSONObject.optJSONObject("customData");
    }

    public String getContentId() {
        return this.zzeqc;
    }

    final void setStreamType(int n) throws IllegalArgumentException {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzeqd = n;
    }

    public int getStreamType() {
        return this.zzeqd;
    }

    final void setContentType(String string2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzeqe = string2;
    }

    public String getContentType() {
        return this.zzeqe;
    }

    final void zza(MediaMetadata mediaMetadata) {
        this.zzeqf = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzeqf;
    }

    final void zzw(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzeqg = l;
    }

    public long getStreamDuration() {
        return this.zzeqg;
    }

    final void zzz(List<MediaTrack> list) {
        this.zzeqh = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzeqh;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzeqi = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzeqi;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzemy = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.zzemy;
    }

    public List<AdBreakInfo> getAdBreaks() {
        if (this.zzeqj == null) {
            return null;
        }
        return Collections.unmodifiableList(this.zzeqj);
    }

    public List<AdBreakClipInfo> getAdBreakClips() {
        if (this.zzeqk == null) {
            return null;
        }
        return Collections.unmodifiableList(this.zzeqk);
    }

    public final void zzaa(List<AdBreakInfo> list) {
        this.zzeqj = list;
    }

    final void zzt(JSONObject jSONObject) throws JSONException {
        zzbfm zzbfm2;
        int n;
        JSONArray jSONArray;
        if (jSONObject.has("breaks")) {
            jSONArray = jSONObject.getJSONArray("breaks");
            this.zzeqj = new ArrayList<AdBreakInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zzbfm2 = AdBreakInfo.zzr(jSONArray.getJSONObject(n));
                if (zzbfm2 == null) {
                    this.zzeqj.clear();
                    break;
                }
                this.zzeqj.add((AdBreakInfo)zzbfm2);
            }
        }
        if (jSONObject.has("breakClips")) {
            jSONArray = jSONObject.getJSONArray("breakClips");
            this.zzeqk = new ArrayList<AdBreakClipInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zzbfm2 = AdBreakClipInfo.zzq(jSONArray.getJSONObject(n));
                if (zzbfm2 == null) {
                    this.zzeqk.clear();
                    return;
                }
                this.zzeqk.add((AdBreakClipInfo)zzbfm2);
            }
        }
    }

    private final void zzacq() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzeqc)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzeqe)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzeqd == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.zzeqc);
            switch (this.zzeqd) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzeqe != null) {
                jSONObject.put("contentType", (Object)this.zzeqe);
            }
            if (this.zzeqf != null) {
                jSONObject.put("metadata", (Object)this.zzeqf.toJson());
            }
            if (this.zzeqg <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", (double)this.zzeqg / 1000.0);
            }
            if (this.zzeqh != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzeqh) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzeqi != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzeqi.toJson());
            }
            if (this.zzemy != null) {
                jSONObject.put("customData", (Object)this.zzemy);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)((Object)object);
        if (this.zzemy == null != (mediaInfo.zzemy == null)) {
            return false;
        }
        if (this.zzemy != null && mediaInfo.zzemy != null && !zzo.zzc((Object)this.zzemy, (Object)mediaInfo.zzemy)) {
            return false;
        }
        return zzbcm.zza(this.zzeqc, mediaInfo.zzeqc) && this.zzeqd == mediaInfo.zzeqd && zzbcm.zza(this.zzeqe, mediaInfo.zzeqe) && zzbcm.zza(this.zzeqf, mediaInfo.zzeqf) && this.zzeqg == mediaInfo.zzeqg && zzbcm.zza(this.zzeqh, mediaInfo.zzeqh) && zzbcm.zza(this.zzeqi, mediaInfo.zzeqi) && zzbcm.zza(this.zzeqj, mediaInfo.zzeqj) && zzbcm.zza(this.zzeqk, mediaInfo.zzeqk);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzeqc, this.zzeqd, this.zzeqe, this.zzeqf, this.zzeqg, String.valueOf(this.zzemy), this.zzeqh, this.zzeqi, this.zzeqj, this.zzeqk});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzemx = this.zzemy == null ? null : this.zzemy.toString();
        Parcel parcel2 = parcel;
        MediaInfo mediaInfo = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)mediaInfo.getContentId(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)3, (int)mediaInfo.getStreamType());
        zzbfp.zza((Parcel)parcel2, (int)4, (String)mediaInfo.getContentType(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (Parcelable)mediaInfo.getMetadata(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (long)mediaInfo.getStreamDuration());
        zzbfp.zzc((Parcel)parcel2, (int)7, mediaInfo.getMediaTracks(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)8, (Parcelable)mediaInfo.getTextTrackStyle(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)9, (String)mediaInfo.zzemx, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)10, mediaInfo.getAdBreaks(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)11, mediaInfo.getAdBreakClips(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private final MediaInfo zzeql;

        public Builder(String string2) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzeql = new MediaInfo(string2);
        }

        public Builder setStreamType(int n) throws IllegalArgumentException {
            this.zzeql.setStreamType(n);
            return this;
        }

        public Builder setContentType(String string2) throws IllegalArgumentException {
            this.zzeql.setContentType(string2);
            return this;
        }

        public Builder setMetadata(MediaMetadata mediaMetadata) {
            this.zzeql.zza(mediaMetadata);
            return this;
        }

        public Builder setStreamDuration(long l) throws IllegalArgumentException {
            this.zzeql.zzw(l);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzeql.setCustomData(jSONObject);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> list) {
            this.zzeql.zzz(list);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzeql.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzeql.zzacq();
            return this.zzeql;
        }
    }
}

