/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.zzaf;
import org.json.JSONObject;

public class MediaLoadOptions {
    public static final double PLAYBACK_RATE_MIN = 0.5;
    public static final double PLAYBACK_RATE_MAX = 2.0;
    private boolean zzeqm;
    private long zzeqn;
    private double zzeqo;
    private long[] zzeqp;
    private JSONObject zzemy;

    private MediaLoadOptions(boolean bl, long l, double d, long[] lArray, JSONObject jSONObject) {
        this.zzeqm = bl;
        this.zzeqn = l;
        this.zzeqo = d;
        this.zzeqp = lArray;
        this.zzemy = jSONObject;
    }

    public boolean getAutoplay() {
        return this.zzeqm;
    }

    public long getPlayPosition() {
        return this.zzeqn;
    }

    public double getPlaybackRate() {
        return this.zzeqo;
    }

    public long[] getActiveTrackIds() {
        return this.zzeqp;
    }

    public JSONObject getCustomData() {
        return this.zzemy;
    }

    /* synthetic */ MediaLoadOptions(boolean bl, long l, double d, long[] lArray, JSONObject jSONObject, zzaf zzaf2) {
        this(bl, l, d, lArray, jSONObject);
    }

    public static class Builder {
        private boolean zzeqm = true;
        private long zzeqn = 0L;
        private double zzeqo = 1.0;
        private long[] zzeqp = null;
        private JSONObject zzemy = null;

        public Builder() {
        }

        public Builder setAutoplay(boolean bl) {
            this.zzeqm = bl;
            return this;
        }

        public Builder setPlayPosition(long l) {
            this.zzeqn = l;
            return this;
        }

        public Builder setPlaybackRate(double d) {
            if (Double.compare(d, 2.0) > 0 || Double.compare(d, 0.5) < 0) {
                throw new IllegalArgumentException("playbackRate must be between PLAYBACK_RATE_MIN and PLAYBACK_RATE_MAX");
            }
            this.zzeqo = d;
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.zzeqp = lArray;
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzemy = jSONObject;
            return this;
        }

        public MediaLoadOptions build() {
            return new MediaLoadOptions(this.zzeqm, this.zzeqn, this.zzeqo, this.zzeqp, this.zzemy, null);
        }
    }
}

