/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.zzah;
import com.google.android.gms.cast.zzai;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem
extends zzbfm {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    public static final Parcelable.Creator<MediaQueueItem> CREATOR = new zzai();
    private MediaInfo zzeqx;
    private int zzeqy;
    private boolean zzeqm;
    private double zzeqz;
    private double zzera;
    private double zzerb;
    private long[] zzeqp;
    private String zzemx;
    private JSONObject zzemy;

    MediaQueueItem(MediaInfo mediaInfo, int n, boolean bl, double d, double d2, double d3, long[] lArray, String string2) {
        this.zzeqx = mediaInfo;
        this.zzeqy = n;
        this.zzeqm = bl;
        this.zzeqz = d;
        this.zzera = d2;
        this.zzerb = d3;
        this.zzeqp = lArray;
        this.zzemx = string2;
        if (this.zzemx != null) {
            try {
                this.zzemy = new JSONObject(this.zzemx);
                return;
            }
            catch (JSONException jSONException) {
                this.zzemy = null;
                this.zzemx = null;
                return;
            }
        }
        this.zzemy = null;
    }

    private MediaQueueItem(MediaInfo mediaInfo) throws IllegalArgumentException {
        this(mediaInfo, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        if (mediaInfo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
    }

    MediaQueueItem(JSONObject jSONObject) throws JSONException {
        this(null, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        this.zzv(jSONObject);
    }

    private MediaQueueItem(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
        this(mediaQueueItem.getMedia(), mediaQueueItem.getItemId(), mediaQueueItem.getAutoplay(), mediaQueueItem.getStartTime(), mediaQueueItem.getPlaybackDuration(), mediaQueueItem.getPreloadTime(), mediaQueueItem.getActiveTrackIds(), null);
        if (this.zzeqx == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzemy = mediaQueueItem.getCustomData();
    }

    public final boolean zzv(JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzeqx = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzeqy != (n = jSONObject.getInt("itemId"))) {
            this.zzeqy = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzeqm != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzeqm = n;
            bl = true;
        }
        if (jSONObject.has("startTime")) {
            double d;
            double d2 = jSONObject.getDouble("startTime");
            if (Math.abs(d - this.zzeqz) > 1.0E-7) {
                this.zzeqz = d2;
                bl = true;
            }
        }
        if (jSONObject.has("playbackDuration")) {
            double d;
            double d3 = jSONObject.getDouble("playbackDuration");
            if (Math.abs(d - this.zzera) > 1.0E-7) {
                this.zzera = d3;
                bl = true;
            }
        }
        if (jSONObject.has("preloadTime")) {
            double d;
            double d4 = jSONObject.getDouble("preloadTime");
            if (Math.abs(d - this.zzerb) > 1.0E-7) {
                this.zzerb = d4;
                bl = true;
            }
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzeqp == null) {
                bl2 = true;
            } else if (this.zzeqp.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzeqp[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzeqp = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzemy = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zzeqx;
    }

    public int getItemId() {
        return this.zzeqy;
    }

    final void zzbb(int n) {
        this.zzeqy = 0;
    }

    public boolean getAutoplay() {
        return this.zzeqm;
    }

    final void zzaw(boolean bl) {
        this.zzeqm = bl;
    }

    public double getStartTime() {
        return this.zzeqz;
    }

    final void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzeqz = d;
    }

    public double getPlaybackDuration() {
        return this.zzera;
    }

    final void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.zzera = d;
    }

    public double getPreloadTime() {
        return this.zzerb;
    }

    final void zze(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzerb = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzeqp;
    }

    final void zza(long[] lArray) {
        this.zzeqp = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzemy;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzemy = jSONObject;
    }

    final void zzacq() throws IllegalArgumentException {
        if (this.zzeqx == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzeqz) || this.zzeqz < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzera)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzerb) || this.zzerb < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzeqx.toJson());
            if (this.zzeqy != 0) {
                jSONObject.put("itemId", this.zzeqy);
            }
            jSONObject.put("autoplay", this.zzeqm);
            jSONObject.put("startTime", this.zzeqz);
            if (this.zzera != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzera);
            }
            jSONObject.put("preloadTime", this.zzerb);
            if (this.zzeqp != null) {
                JSONArray jSONArray = new JSONArray();
                long[] lArray = this.zzeqp;
                int n = this.zzeqp.length;
                for (int i = 0; i < n; ++i) {
                    long l = lArray[i];
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzemy != null) {
                jSONObject.put("customData", (Object)this.zzemy);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)((Object)object);
        if (this.zzemy == null != (mediaQueueItem.zzemy == null)) {
            return false;
        }
        if (this.zzemy != null && mediaQueueItem.zzemy != null && !zzo.zzc((Object)this.zzemy, (Object)mediaQueueItem.zzemy)) {
            return false;
        }
        return zzbcm.zza(this.zzeqx, mediaQueueItem.zzeqx) && this.zzeqy == mediaQueueItem.zzeqy && this.zzeqm == mediaQueueItem.zzeqm && this.zzeqz == mediaQueueItem.zzeqz && this.zzera == mediaQueueItem.zzera && this.zzerb == mediaQueueItem.zzerb && Arrays.equals(this.zzeqp, mediaQueueItem.zzeqp);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzeqx, this.zzeqy, this.zzeqm, this.zzeqz, this.zzera, this.zzerb, Arrays.hashCode(this.zzeqp), String.valueOf(this.zzemy)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzemx = this.zzemy == null ? null : this.zzemy.toString();
        Parcel parcel2 = parcel;
        MediaQueueItem mediaQueueItem = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (Parcelable)mediaQueueItem.getMedia(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)3, (int)mediaQueueItem.getItemId());
        zzbfp.zza((Parcel)parcel2, (int)4, (boolean)mediaQueueItem.getAutoplay());
        zzbfp.zza((Parcel)parcel2, (int)5, (double)mediaQueueItem.getStartTime());
        zzbfp.zza((Parcel)parcel2, (int)6, (double)mediaQueueItem.getPlaybackDuration());
        zzbfp.zza((Parcel)parcel2, (int)7, (double)mediaQueueItem.getPreloadTime());
        zzbfp.zza((Parcel)parcel2, (int)8, (long[])mediaQueueItem.getActiveTrackIds(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)9, (String)mediaQueueItem.zzemx, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ MediaQueueItem(MediaInfo mediaInfo, zzah zzah2) throws IllegalArgumentException {
        this(mediaInfo);
    }

    /* synthetic */ MediaQueueItem(MediaQueueItem mediaQueueItem, zzah zzah2) throws IllegalArgumentException {
        this(mediaQueueItem);
    }

    public static class Builder {
        private final MediaQueueItem zzerc;

        public Builder(MediaInfo mediaInfo) throws IllegalArgumentException {
            this.zzerc = new MediaQueueItem(mediaInfo, null);
        }

        public Builder(JSONObject jSONObject) throws JSONException {
            this.zzerc = new MediaQueueItem(jSONObject);
        }

        public Builder(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
            this.zzerc = new MediaQueueItem(mediaQueueItem, null);
        }

        public Builder clearItemId() {
            this.zzerc.zzbb(0);
            return this;
        }

        public Builder setAutoplay(boolean bl) {
            this.zzerc.zzaw(bl);
            return this;
        }

        public Builder setStartTime(double d) throws IllegalArgumentException {
            this.zzerc.zzc(d);
            return this;
        }

        public Builder setPlaybackDuration(double d) {
            this.zzerc.zzd(d);
            return this;
        }

        public Builder setPreloadTime(double d) throws IllegalArgumentException {
            this.zzerc.zze(d);
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.zzerc.zza(lArray);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzerc.setCustomData(jSONObject);
            return this;
        }

        public MediaQueueItem build() {
            this.zzerc.zzacq();
            return this.zzerc;
        }
    }
}

