/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.cast.zzbo;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class VideoInfo
extends zzbfm {
    public static final int HDR_TYPE_UNKNOWN = 0;
    public static final int HDR_TYPE_SDR = 1;
    public static final int HDR_TYPE_HDR10 = 2;
    public static final int HDR_TYPE_DV = 3;
    public static final int HDR_TYPE_HDR = 4;
    public static final Parcelable.Creator<VideoInfo> CREATOR = new zzbo();
    private int zzalv;
    private int zzalw;
    private int zzets;

    VideoInfo(int n, int n2, int n3) {
        this.zzalv = n;
        this.zzalw = n2;
        this.zzets = n3;
    }

    public final int getWidth() {
        return this.zzalv;
    }

    public final int getHeight() {
        return this.zzalw;
    }

    public final int getHdrType() {
        return this.zzets;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoInfo videoInfo = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)2, (int)videoInfo.getWidth());
        zzbfp.zzc((Parcel)parcel2, (int)3, (int)videoInfo.getHeight());
        zzbfp.zzc((Parcel)parcel2, (int)4, (int)videoInfo.getHdrType());
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VideoInfo)) {
            return false;
        }
        VideoInfo videoInfo = (VideoInfo)((Object)object);
        return this.zzalw == videoInfo.getHeight() && this.zzalv == videoInfo.getWidth() && this.zzets == videoInfo.getHdrType();
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzalw, this.zzalv, this.zzets});
    }

    static VideoInfo zzw(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        try {
            int n;
            String string2;
            switch (string2 = jSONObject.getString("hdrType")) {
                case "dv": {
                    n = 3;
                    break;
                }
                case "hdr10": {
                    n = 2;
                    break;
                }
                case "hdr": {
                    n = 4;
                    break;
                }
                case "sdr": {
                    n = 1;
                    break;
                }
                default: {
                    Log.d((String)"VideoInfo", (String)String.format(Locale.ROOT, "Unknown HDR type: %s", string2));
                    n = 0;
                }
            }
            return new VideoInfo(jSONObject.getInt("width"), jSONObject.getInt("height"), n);
        }
        catch (JSONException jSONException) {
            Log.d((String)"VideoInfo", (String)String.format(Locale.ROOT, "Error while creating a VideoInfo instance from JSON: %s", jSONException.getMessage()));
            return null;
        }
    }
}

