/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.zzab;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzbbt;
import com.google.android.gms.internal.zzbcg;
import com.google.android.gms.internal.zzbch;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.internal.zzbcr;
import com.google.android.gms.internal.zzbcs;
import com.google.android.gms.internal.zzbcy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class zzbcf
extends com.google.android.gms.common.internal.zzab<zzbcr> {
    private static final zzbcy zzeow = new zzbcy("CastClientImpl");
    private ApplicationMetadata zzfga;
    private final CastDevice zzeuq;
    private final Cast.Listener zzent;
    private final Map<String, Cast.MessageReceivedCallback> zzfgb;
    private final long zzfgc;
    private final Bundle mExtras;
    private zzbch zzfgd;
    private String zzfge;
    private boolean zzerk;
    private boolean zzfgf;
    private boolean zzfgg;
    private boolean zzfgh;
    private double zzerj;
    private int zzfgi;
    private int zzfgj;
    private final AtomicLong zzfgk;
    private String zzfgl;
    private String zzfgm;
    private Bundle zzfgn;
    private final Map<Long, zzn<Status>> zzfgo;
    private zzn<Cast.ApplicationConnectionResult> zzfgp;
    private zzn<Status> zzfgq;
    private static final Object zzfgr = new Object();
    private static final Object zzfgs = new Object();

    public zzbcf(Context context, Looper looper, zzr zzr2, CastDevice castDevice, long l, Cast.Listener listener, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zzeuq = castDevice;
        this.zzent = listener;
        this.zzfgc = l;
        this.mExtras = bundle;
        this.zzfgb = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzfgk = new AtomicLong(0L);
        this.zzfgo = new HashMap<Long, zzn<Status>>();
        this.zzafh();
    }

    private final void zzafh() {
        this.zzfgh = false;
        this.zzfgi = -1;
        this.zzfgj = -1;
        this.zzfga = null;
        this.zzfge = null;
        this.zzerj = 0.0;
        this.zzerk = false;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzeow.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzfgh = true;
            this.zzfgf = true;
            this.zzfgg = true;
        } else {
            this.zzfgh = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzfgn = new Bundle();
            this.zzfgn.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    public final void disconnect() {
        zzeow.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzfgd, this.isConnected());
        zzbch zzbch2 = this.zzfgd;
        this.zzfgd = null;
        if (zzbch2 == null || zzbch2.zzafo() == null) {
            zzeow.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzafj();
        try {
            ((zzbcr)super.zzakn()).disconnect();
            return;
        }
        catch (RemoteException | IllegalStateException throwable) {
            zzeow.zzb(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
            return;
        }
        finally {
            super.disconnect();
        }
    }

    public final Bundle zzafi() {
        if (this.zzfgn != null) {
            Bundle bundle = this.zzfgn;
            this.zzfgn = null;
            return bundle;
        }
        return super.zzafi();
    }

    @NonNull
    protected final String zzhi() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @NonNull
    protected final String zzhj() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected final Bundle zzaap() {
        Bundle bundle = new Bundle();
        zzeow.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzfgl, this.zzfgm);
        this.zzeuq.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzfgc);
        if (this.mExtras != null) {
            bundle.putAll(this.mExtras);
        }
        this.zzfgd = new zzbch(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzfgd.asBinder()));
        if (this.zzfgl != null) {
            bundle.putString("last_application_id", this.zzfgl);
            if (this.zzfgm != null) {
                bundle.putString("last_session_id", this.zzfgm);
            }
        }
        return bundle;
    }

    public final void zza(String string2, String string3, zzn<Status> zzn2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzbcm.zzfn(string2);
        this.zzafk();
        long l = this.zzfgk.incrementAndGet();
        try {
            this.zzfgo.put(l, zzn2);
            ((zzbcr)super.zzakn()).zzb(string2, string3, l);
            return;
        }
        catch (Throwable throwable) {
            this.zzfgo.remove(l);
            throw throwable;
        }
    }

    public final void zza(String string2, LaunchOptions launchOptions, zzn<Cast.ApplicationConnectionResult> zzn2) throws IllegalStateException, RemoteException {
        this.zza(zzn2);
        ((zzbcr)super.zzakn()).zzb(string2, launchOptions);
    }

    public final void zza(String string2, String string3, zzab zzab2, zzn<Cast.ApplicationConnectionResult> zzn2) throws IllegalStateException, RemoteException {
        this.zza(zzn2);
        if (zzab2 == null) {
            zzab2 = new zzab();
        }
        ((zzbcr)super.zzakn()).zza(string2, string3, zzab2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzn<Cast.ApplicationConnectionResult> zzn2) {
        Object object = zzfgr;
        synchronized (object) {
            if (this.zzfgp != null) {
                this.zzfgp.setResult((Object)new zzbcg(new Status(2002)));
            }
            this.zzfgp = zzn2;
            return;
        }
    }

    public final void zzb(zzn<Status> zzn2) throws IllegalStateException, RemoteException {
        this.zzc(zzn2);
        ((zzbcr)super.zzakn()).zzafq();
    }

    public final void zza(String string2, zzn<Status> zzn2) throws IllegalStateException, RemoteException {
        this.zzc(zzn2);
        ((zzbcr)super.zzakn()).zzfh(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzc(zzn<Status> zzn2) {
        Object object = zzfgs;
        synchronized (object) {
            if (this.zzfgq != null) {
                zzn2.setResult((Object)new Status(2001));
                return;
            }
            this.zzfgq = zzn2;
            return;
        }
    }

    public final void requestStatus() throws IllegalStateException, RemoteException {
        ((zzbcr)super.zzakn()).requestStatus();
    }

    public final void setVolume(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        ((zzbcr)super.zzakn()).zza(d, this.zzerj, this.zzerk);
    }

    public final void setMute(boolean bl) throws IllegalStateException, RemoteException {
        ((zzbcr)super.zzakn()).zza(bl, this.zzerj, this.zzerk);
    }

    public final double getVolume() throws IllegalStateException {
        this.zzafk();
        return this.zzerj;
    }

    public final boolean isMute() throws IllegalStateException {
        this.zzafk();
        return this.zzerk;
    }

    public final int getActiveInputState() throws IllegalStateException {
        this.zzafk();
        return this.zzfgi;
    }

    public final int getStandbyState() throws IllegalStateException {
        this.zzafk();
        return this.zzfgj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzbcm.zzfn(string2);
        this.removeMessageReceivedCallbacks(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzfgb;
            synchronized (map) {
                this.zzfgb.put(string2, messageReceivedCallback);
            }
            ((zzbcr)super.zzakn()).zzfq(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMessageReceivedCallbacks(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzfgb;
        synchronized (map) {
            messageReceivedCallback = this.zzfgb.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzbcr)super.zzakn()).zzfr(string2);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                zzeow.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public final ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzafk();
        return this.zzfga;
    }

    public final String getApplicationStatus() throws IllegalStateException {
        this.zzafk();
        return this.zzfge;
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzafj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzafj() {
        zzeow.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzfgb;
        synchronized (map) {
            this.zzfgb.clear();
            return;
        }
    }

    private final void zza(zzbcn zzbcn2) {
        boolean bl;
        ApplicationMetadata applicationMetadata = zzbcn2.getApplicationMetadata();
        if (!zzbcm.zza(applicationMetadata, this.zzfga)) {
            this.zzfga = applicationMetadata;
            this.zzent.onApplicationMetadataChanged(this.zzfga);
        }
        boolean bl2 = false;
        double d = zzbcn2.getVolume();
        if (!Double.isNaN(d) && Math.abs(d - this.zzerj) > 1.0E-7) {
            this.zzerj = d;
            bl2 = true;
        }
        if ((bl = zzbcn2.zzafp()) != this.zzerk) {
            this.zzerk = bl;
            bl2 = true;
        }
        zzeow.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzfgg);
        if (this.zzent != null && (bl2 || this.zzfgg)) {
            this.zzent.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = zzbcn2.getActiveInputState();
        if (n != this.zzfgi) {
            this.zzfgi = n;
            bl3 = true;
        }
        zzeow.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzfgg);
        if (this.zzent != null && (bl3 || this.zzfgg)) {
            this.zzent.onActiveInputStateChanged(this.zzfgi);
        }
        boolean bl4 = false;
        int n2 = zzbcn2.getStandbyState();
        if (n2 != this.zzfgj) {
            this.zzfgj = n2;
            bl4 = true;
        }
        zzeow.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzfgg);
        if (this.zzent != null && (bl4 || this.zzfgg)) {
            this.zzent.onStandbyStateChanged(this.zzfgj);
        }
        this.zzfgg = false;
    }

    private final void zza(zzbbt zzbbt2) {
        boolean bl = false;
        String string2 = zzbbt2.zzafe();
        if (!zzbcm.zza(string2, this.zzfge)) {
            this.zzfge = string2;
            bl = true;
        }
        zzeow.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzfgf);
        if (this.zzent != null && (bl || this.zzfgf)) {
            this.zzent.onApplicationStatusChanged();
        }
        this.zzfgf = false;
    }

    private final void zzafk() throws IllegalStateException {
        if (!this.zzfgh || this.zzfgd == null || this.zzfgd.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.cast.internal.ICastDeviceController");
        if (iInterface instanceof zzbcr) {
            return (zzbcr)iInterface;
        }
        return new zzbcs(iBinder2);
    }

    static /* synthetic */ void zzc(zzbcf zzbcf2) {
        zzbcf2.zzafh();
    }

    static /* synthetic */ zzbcy zzafl() {
        return zzeow;
    }

    static /* synthetic */ ApplicationMetadata zza(zzbcf zzbcf2, ApplicationMetadata applicationMetadata) {
        zzbcf2.zzfga = applicationMetadata;
        return zzbcf2.zzfga;
    }

    static /* synthetic */ String zza(zzbcf zzbcf2, String string2) {
        zzbcf2.zzfgl = string2;
        return zzbcf2.zzfgl;
    }

    static /* synthetic */ String zzb(zzbcf zzbcf2, String string2) {
        zzbcf2.zzfgm = string2;
        return zzbcf2.zzfgm;
    }

    static /* synthetic */ String zzc(zzbcf zzbcf2, String string2) {
        zzbcf2.zzfge = string2;
        return zzbcf2.zzfge;
    }

    static /* synthetic */ Object zzafm() {
        return zzfgr;
    }

    static /* synthetic */ zzn zzd(zzbcf zzbcf2) {
        return zzbcf2.zzfgp;
    }

    static /* synthetic */ zzn zza(zzbcf zzbcf2, zzn zzn2) {
        zzbcf2.zzfgp = null;
        return null;
    }

    static /* synthetic */ Cast.Listener zze(zzbcf zzbcf2) {
        return zzbcf2.zzent;
    }

    static /* synthetic */ void zza(zzbcf zzbcf2, zzbcn zzbcn2) {
        zzbcf2.zza(zzbcn2);
    }

    static /* synthetic */ void zza(zzbcf zzbcf2, zzbbt zzbbt2) {
        zzbcf2.zza(zzbbt2);
    }

    static /* synthetic */ Map zzf(zzbcf zzbcf2) {
        return zzbcf2.zzfgb;
    }

    static /* synthetic */ CastDevice zzg(zzbcf zzbcf2) {
        return zzbcf2.zzeuq;
    }

    static /* synthetic */ Map zzh(zzbcf zzbcf2) {
        return zzbcf2.zzfgo;
    }

    static /* synthetic */ Object zzafn() {
        return zzfgs;
    }

    static /* synthetic */ zzn zzi(zzbcf zzbcf2) {
        return zzbcf2.zzfgq;
    }

    static /* synthetic */ zzn zzb(zzbcf zzbcf2, zzn zzn2) {
        zzbcf2.zzfgq = null;
        return null;
    }
}

