/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaLoadOptions;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.zzbl;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.internal.zzbbw;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbda;
import com.google.android.gms.internal.zzbdb;
import com.google.android.gms.internal.zzbdd;
import com.google.android.gms.internal.zzbde;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbcz
extends zzbbw {
    public static final String NAMESPACE = zzbcm.zzfo("com.google.cast.media");
    private long zzfhq;
    private MediaStatus zzfhr;
    private final List<zzbde> zzfeg;
    private zzbda zzfhs;
    private final zzbde zzfht;
    private final zzbde zzfhu;
    private final zzbde zzfhv;
    private final zzbde zzfhw;
    private final zzbde zzfhx;
    private final zzbde zzfhy;
    private final zzbde zzfhz;
    private final zzbde zzfia;
    private final zzbde zzfib;
    private final zzbde zzfic;
    private final zzbde zzfid;
    private final zzbde zzfie;
    private final zzbde zzfif;
    private final zzbde zzfig;
    private final zzbde zzfih;

    public zzbcz(String string2, zzd zzd2) {
        super(NAMESPACE, zzd2, "MediaControlChannel", null, 1000L);
        this.zzfht = new zzbde(this.zzata, 86400000L);
        this.zzfhu = new zzbde(this.zzata, 86400000L);
        this.zzfhv = new zzbde(this.zzata, 86400000L);
        this.zzfhw = new zzbde(this.zzata, 86400000L);
        this.zzfhx = new zzbde(this.zzata, 86400000L);
        this.zzfhy = new zzbde(this.zzata, 86400000L);
        this.zzfhz = new zzbde(this.zzata, 86400000L);
        this.zzfia = new zzbde(this.zzata, 86400000L);
        this.zzfib = new zzbde(this.zzata, 86400000L);
        this.zzfic = new zzbde(this.zzata, 86400000L);
        this.zzfid = new zzbde(this.zzata, 86400000L);
        this.zzfie = new zzbde(this.zzata, 86400000L);
        this.zzfif = new zzbde(this.zzata, 86400000L);
        this.zzfig = new zzbde(this.zzata, 86400000L);
        this.zzfih = new zzbde(this.zzata, 86400000L);
        this.zzfeg = new ArrayList<zzbde>();
        this.zzfeg.add(this.zzfht);
        this.zzfeg.add(this.zzfhu);
        this.zzfeg.add(this.zzfhv);
        this.zzfeg.add(this.zzfhw);
        this.zzfeg.add(this.zzfhx);
        this.zzfeg.add(this.zzfhy);
        this.zzfeg.add(this.zzfhz);
        this.zzfeg.add(this.zzfia);
        this.zzfeg.add(this.zzfib);
        this.zzfeg.add(this.zzfic);
        this.zzfeg.add(this.zzfid);
        this.zzfeg.add(this.zzfie);
        this.zzfeg.add(this.zzfif);
        this.zzfeg.add(this.zzfig);
        this.zzfeg.add(this.zzfih);
        this.zzafr();
    }

    public final void zza(zzbda zzbda2) {
        this.zzfhs = zzbda2;
    }

    public final long zza(@NonNull zzbdd zzbdd2, @NonNull MediaInfo mediaInfo, @NonNull MediaLoadOptions mediaLoadOptions) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzafg();
        this.zzfht.zza(l, zzbdd2);
        this.zzbc(true);
        try {
            JSONArray jSONArray;
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"LOAD");
            jSONObject.put("media", (Object)mediaInfo.toJson());
            jSONObject.put("autoplay", mediaLoadOptions.getAutoplay());
            jSONObject.put("currentTime", (double)mediaLoadOptions.getPlayPosition() / 1000.0);
            jSONObject.put("playbackRate", mediaLoadOptions.getPlaybackRate());
            long[] lArray = mediaLoadOptions.getActiveTrackIds();
            if (lArray != null) {
                jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if ((jSONArray = mediaLoadOptions.getCustomData()) != null) {
                jSONObject.put("customData", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzbdd zzbdd2, JSONObject jSONObject) throws IOException, zzbdb {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzafg();
        this.zzfhu.zza(l, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzacr());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzb(zzbdd zzbdd2, JSONObject jSONObject) throws IOException, zzbdb {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzafg();
        this.zzfhw.zza(l, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzacr());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzc(zzbdd zzbdd2, JSONObject jSONObject) throws IOException, zzbdb {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzafg();
        this.zzfhv.zza(l, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzacr());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzbdd zzbdd2, long l, int n, JSONObject jSONObject) throws IOException, zzbdb {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzafg();
        this.zzfhx.zza(l2, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zzacr());
            jSONObject2.put("currentTime", (double)l / 1000.0);
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzbdd zzbdd2, double d, JSONObject jSONObject) throws IOException, zzbdb, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzafg();
        this.zzfhy.zza(l, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzacr());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzbdd zzbdd2, boolean bl, JSONObject jSONObject) throws IOException, zzbdb {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzafg();
        this.zzfhz.zza(l, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzacr());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzb(zzbdd zzbdd2, double d, JSONObject jSONObject) throws IOException, zzbdb {
        if (this.zzfhr == null) {
            throw new zzbdb();
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzafg();
        this.zzfih.zza(l, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_PLAYBACK_RATE");
            jSONObject2.put("playbackRate", d);
            jSONObject2.put("mediaSessionId", this.zzfhr.zzacr());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzbdd zzbdd2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzafg();
        this.zzfia.zza(l, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzfhr != null) {
                jSONObject.put("mediaSessionId", this.zzfhr.zzacr());
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzbdd zzbdd2, long[] lArray) throws IOException, zzbdb {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzafg();
        this.zzfib.zza(l, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzacr());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzbdd zzbdd2, TextTrackStyle textTrackStyle) throws IOException, zzbdb {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzafg();
        this.zzfic.zza(l, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zzacr());
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zzfhq == 0L) {
            return 0L;
        }
        double d = this.zzfhr.getPlaybackRate();
        long l = this.zzfhr.getStreamPosition();
        int n = this.zzfhr.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        long l2 = mediaInfo.getStreamDuration();
        zzbcz zzbcz2 = this;
        long l3 = zzbcz2.zzata.elapsedRealtime() - zzbcz2.zzfhq;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l;
        }
        long l4 = l + (long)((double)l3 * d);
        if (l2 > 0L && l4 > l2) {
            l4 = l2;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public final long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo != null) {
            return mediaInfo.getStreamDuration();
        }
        return 0L;
    }

    public final MediaStatus getMediaStatus() {
        return this.zzfhr;
    }

    public final MediaInfo getMediaInfo() {
        if (this.zzfhr == null) {
            return null;
        }
        return this.zzfhr.getMediaInfo();
    }

    public final long zza(zzbdd zzbdd2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IOException, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= mediaQueueItemArray.length) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Invalid startIndex: ").append(n).toString());
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzafg();
        this.zzfht.zza(l2, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            switch (n2) {
                case 0: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                    break;
                }
                case 1: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                    break;
                }
                case 2: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                    break;
                }
                case 3: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(32).append("Invalid repeat mode: ").append(n2).toString());
                }
            }
            jSONObject2.put("startIndex", n);
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzbdd zzbdd2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, int n3, long l, JSONObject jSONObject) throws IOException, zzbdb, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        if (n3 != -1 && (n3 < 0 || n3 >= mediaQueueItemArray.length)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "currentItemIndexInItemsToInsert %d out of range [0, %d).", n3, mediaQueueItemArray.length));
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzafg();
        this.zzfid.zza(l2, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zzacr());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (n3 != -1) {
                jSONObject2.put("currentItemIndex", n3);
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzbdd zzbdd2, int n, long l, MediaQueueItem[] mediaQueueItemArray, int n2, Integer n3, JSONObject jSONObject) throws IllegalArgumentException, IOException, zzbdb {
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(53).append("playPosition cannot be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzafg();
        this.zzfie.zza(l2, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zzacr());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && mediaQueueItemArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                    jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                        break;
                    }
                    case 1: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                        break;
                    }
                    case 2: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                        break;
                    }
                    case 3: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    }
                }
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzbdd zzbdd2, int[] nArray, JSONObject jSONObject) throws IOException, zzbdb, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzafg();
        this.zzfif.zza(l, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zzacr());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzbdd zzbdd2, int[] nArray, int n, JSONObject jSONObject) throws IOException, zzbdb, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzafg();
        this.zzfig.zza(l, zzbdd2);
        this.zzbc(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zzacr());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzb(String string2, List<zzbl> list) throws IOException {
        long l = this.zzafg();
        this.zza(zzbcz.zza(string2, list, l), l, null);
        return l;
    }

    private static String zza(String string2, List<zzbl> list, long l) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"PRECACHE");
            if (string2 != null) {
                jSONObject.put("precacheData", (Object)string2);
            }
            if (list != null && !list.isEmpty()) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < list.size(); ++i) {
                    jSONArray.put(i, (Object)list.get(i).toJson());
                }
                jSONObject.put("requestItems", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject.toString();
    }

    @Override
    public final void zzfm(String string2) {
        this.zzeom.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            switch (string3) {
                case "MEDIA_STATUS": {
                    JSONArray jSONArray = jSONObject.getJSONArray("status");
                    if (jSONArray.length() > 0) {
                        this.zza(l, jSONArray.getJSONObject(0));
                        return;
                    }
                    this.zzfhr = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.onQueueStatusUpdated();
                    this.onPreloadStatusUpdated();
                    this.zzfia.zzc(l, 0, null);
                    return;
                }
                case "INVALID_PLAYER_STATE": {
                    this.zzeom.zzf("received unexpected error: Invalid Player State.", new Object[0]);
                    JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                    Iterator<zzbde> iterator = this.zzfeg.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().zzc(l, 2100, jSONObject2);
                    }
                    return;
                }
                case "LOAD_FAILED": {
                    JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                    this.zzfht.zzc(l, 2100, jSONObject3);
                    return;
                }
                case "LOAD_CANCELLED": {
                    JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                    this.zzfht.zzc(l, 2101, jSONObject4);
                    return;
                }
                case "INVALID_REQUEST": {
                    this.zzeom.zzf("received unexpected error: Invalid Request.", new Object[0]);
                    JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                    Iterator<zzbde> iterator = this.zzfeg.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().zzc(l, 2100, jSONObject5);
                    }
                    break;
                }
            }
            return;
        }
        catch (JSONException jSONException) {
            this.zzeom.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
    }

    private final void zza(long l, JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = this.zzfht.test(l);
        boolean bl2 = this.zzfhx.zzaft() && !this.zzfhx.test(l);
        boolean bl3 = this.zzfhy.zzaft() && !this.zzfhy.test(l) || this.zzfhz.zzaft() && !this.zzfhz.test(l);
        int n2 = 0;
        if (bl2) {
            n2 = 2;
        }
        if (bl3) {
            n2 |= 1;
        }
        if (bl || this.zzfhr == null) {
            this.zzfhr = new MediaStatus(jSONObject);
            this.zzfhq = this.zzata.elapsedRealtime();
            n = 127;
        } else {
            n = this.zzfhr.zza(jSONObject, n2);
        }
        if ((n & 1) != 0) {
            this.zzfhq = this.zzata.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 2) != 0) {
            this.zzfhq = this.zzata.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 4) != 0) {
            this.onMetadataUpdated();
        }
        if ((n & 8) != 0) {
            this.onQueueStatusUpdated();
        }
        if ((n & 0x10) != 0) {
            this.onPreloadStatusUpdated();
        }
        if ((n & 0x20) != 0) {
            this.zzfhq = this.zzata.elapsedRealtime();
            zzbcz zzbcz2 = this;
            if (zzbcz2.zzfhs != null) {
                zzbcz2.zzfhs.onAdBreakStatusUpdated();
            }
        }
        if ((n & 0x40) != 0) {
            this.zzfhq = this.zzata.elapsedRealtime();
            this.onStatusUpdated();
        }
        Iterator<zzbde> iterator = this.zzfeg.iterator();
        while (iterator.hasNext()) {
            long l2 = l;
            iterator.next().zzc(l2, 0, null);
        }
    }

    private final long zzacr() throws zzbdb {
        if (this.zzfhr == null) {
            throw new zzbdb();
        }
        return this.zzfhr.zzacr();
    }

    private final void onStatusUpdated() {
        if (this.zzfhs != null) {
            this.zzfhs.onStatusUpdated();
        }
    }

    private final void onMetadataUpdated() {
        if (this.zzfhs != null) {
            this.zzfhs.onMetadataUpdated();
        }
    }

    private final void onQueueStatusUpdated() {
        if (this.zzfhs != null) {
            this.zzfhs.onQueueStatusUpdated();
        }
    }

    private final void onPreloadStatusUpdated() {
        if (this.zzfhs != null) {
            this.zzfhs.onPreloadStatusUpdated();
        }
    }

    private final void zzafr() {
        this.zzfhq = 0L;
        this.zzfhr = null;
        Iterator<zzbde> iterator = this.zzfeg.iterator();
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
    }

    @Override
    public final void zzaff() {
        super.zzaff();
        this.zzafr();
    }

    @Override
    public final void zzc(long l, int n) {
        Iterator<zzbde> iterator = this.zzfeg.iterator();
        while (iterator.hasNext()) {
            int n2 = n;
            long l2 = l;
            iterator.next().zzc(l2, n2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zzz(long l) {
        Iterator<zzbde> iterator = this.zzfeg.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzd(l, 2102);
        }
        boolean bl = false;
        Object object = zzbde.zzakl;
        synchronized (object) {
            Iterator<zzbde> iterator2 = this.zzfeg.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().zzaft()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

