/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdBreakInfo
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<AdBreakInfo> CREATOR = new zzb();
    private final long zza;
    private final String zzb;
    private final long zzc;
    private final boolean zzd;
    private String[] zze;
    private final boolean zzf;

    @Hide
    public AdBreakInfo(long l, String string, long l2, boolean bl, String[] stringArray, boolean bl2) {
        this.zza = l;
        this.zzb = string;
        this.zzc = l2;
        this.zzd = bl;
        this.zze = stringArray;
        this.zzf = bl2;
    }

    public long getPlaybackPositionInMs() {
        return this.zza;
    }

    public String getId() {
        return this.zzb;
    }

    public long getDurationInMs() {
        return this.zzc;
    }

    public boolean isWatched() {
        return this.zzd;
    }

    public boolean isEmbedded() {
        return this.zzf;
    }

    public String[] getBreakClipIds() {
        return this.zze;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AdBreakInfo adBreakInfo = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)adBreakInfo.getPlaybackPositionInMs());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)adBreakInfo.getId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (long)adBreakInfo.getDurationInMs());
        zzbgo.zza((Parcel)parcel2, (int)5, (boolean)adBreakInfo.isWatched());
        zzbgo.zza((Parcel)parcel2, (int)6, (String[])adBreakInfo.getBreakClipIds(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (boolean)adBreakInfo.isEmbedded());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return this.zzb.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdBreakInfo)) {
            return false;
        }
        AdBreakInfo adBreakInfo = (AdBreakInfo)((Object)object);
        return zzbdw.zza(this.zzb, adBreakInfo.zzb) && this.zza == adBreakInfo.zza && this.zzc == adBreakInfo.zzc && this.zzd == adBreakInfo.zzd && Arrays.equals(this.zze, adBreakInfo.zze) && this.zzf == adBreakInfo.zzf;
    }

    static AdBreakInfo zza(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        if (!jSONObject.has("id") || !jSONObject.has("position")) {
            return null;
        }
        try {
            int n;
            String string = jSONObject.getString("id");
            long l = (long)((double)jSONObject.getLong("position") * 1000.0);
            boolean bl = jSONObject.optBoolean("isWatched");
            long l2 = (long)((double)jSONObject.optLong("duration") * 1000.0);
            JSONArray jSONArray = jSONObject.optJSONArray("breakClipIds");
            String[] stringArray = null;
            if (jSONArray != null) {
                stringArray = new String[jSONArray.length()];
                for (n = 0; n < jSONArray.length(); ++n) {
                    stringArray[n] = jSONArray.getString(n);
                }
            }
            n = jSONObject.optBoolean("isEmbedded");
            return new AdBreakInfo(l, string, l2, bl, stringArray, n != 0);
        }
        catch (JSONException jSONException) {
            Log.d((String)"AdBreakInfo", (String)String.format(Locale.ROOT, "Error while creating an AdBreakInfo from JSON: %s", jSONException.getMessage()));
            return null;
        }
    }

    @Hide
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("id", (Object)this.zzb);
            jSONObject.put("position", (double)this.zza / 1000.0);
            jSONObject.put("isWatched", this.zzd);
            jSONObject.put("isEmbedded", this.zzf);
            jSONObject.put("duration", (double)this.zzc / 1000.0);
            if (this.zze != null) {
                JSONArray jSONArray = new JSONArray();
                String[] stringArray = this.zze;
                int n = this.zze.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    jSONArray.put((Object)string);
                }
                jSONObject.put("breakClipIds", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public static class Builder {
        private long zza = 0L;
        private String zzb = null;
        private long zzc = 0L;
        private boolean zzd = false;
        private boolean zze = false;
        private String[] zzf = null;

        public Builder(long l) {
            this.zza = l;
        }

        public Builder setId(String string) {
            this.zzb = string;
            return this;
        }

        public Builder setDurationInMs(long l) {
            this.zzc = l;
            return this;
        }

        public Builder setIsWatched(boolean bl) {
            this.zzd = bl;
            return this;
        }

        public Builder setIsEmbedded(boolean bl) {
            this.zze = bl;
            return this;
        }

        public Builder setBreakClipIds(String[] stringArray) {
            this.zzf = stringArray;
            return this;
        }

        public AdBreakInfo build() {
            return new AdBreakInfo(this.zza, this.zzb, this.zzc, this.zzd, this.zzf, this.zze);
        }
    }
}

