/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.cast.zzc;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class AdBreakStatus
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<AdBreakStatus> CREATOR = new zzc();
    public static final int AD_BREAK_CLIP_NOT_SKIPPABLE = -1;
    private final long zza;
    private final long zzb;
    private final String zzc;
    private final String zzd;
    private final long zze;

    AdBreakStatus(long l, long l2, String string, String string2, long l3) {
        this.zza = l;
        this.zzb = l2;
        this.zzc = string;
        this.zzd = string2;
        this.zze = l3;
    }

    public String getBreakId() {
        return this.zzc;
    }

    public String getBreakClipId() {
        return this.zzd;
    }

    public long getCurrentBreakTimeInMs() {
        return this.zza;
    }

    public long getCurrentBreakClipTimeInMs() {
        return this.zzb;
    }

    public long getWhenSkippableInMs() {
        return this.zze;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AdBreakStatus adBreakStatus = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)adBreakStatus.getCurrentBreakTimeInMs());
        zzbgo.zza((Parcel)parcel2, (int)3, (long)adBreakStatus.getCurrentBreakClipTimeInMs());
        zzbgo.zza((Parcel)parcel2, (int)4, (String)adBreakStatus.getBreakId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)adBreakStatus.getBreakClipId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (long)adBreakStatus.getWhenSkippableInMs());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdBreakStatus)) {
            return false;
        }
        AdBreakStatus adBreakStatus = (AdBreakStatus)((Object)object);
        return this.zza == adBreakStatus.zza && this.zzb == adBreakStatus.zzb && zzbdw.zza(this.zzc, adBreakStatus.zzc) && zzbdw.zza(this.zzd, adBreakStatus.zzd) && this.zze == adBreakStatus.zze;
    }

    static AdBreakStatus zza(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        if (!jSONObject.has("currentBreakTime") || !jSONObject.has("currentBreakClipTime")) {
            return null;
        }
        try {
            long l = (long)((double)jSONObject.getLong("currentBreakTime") * 1000.0);
            long l2 = (long)((double)jSONObject.getLong("currentBreakClipTime") * 1000.0);
            String string = jSONObject.optString("breakId", null);
            String string2 = jSONObject.optString("breakClipId", null);
            long l3 = jSONObject.optLong("whenSkippable", -1L);
            if (l3 != -1L) {
                l3 = (long)((double)l3 * 1000.0);
            }
            return new AdBreakStatus(l, l2, string, string2, l3);
        }
        catch (JSONException jSONException) {
            Log.d((String)"AdBreakInfo", (String)String.format(Locale.ROOT, "Error while creating an AdBreakClipInfo from JSON: %s", jSONException.getMessage()));
            return null;
        }
    }
}

