/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.cast.zzn;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CastDevice
extends zzbgl
implements ReflectedParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final int CAPABILITY_MULTIZONE_GROUP = 32;
    @Hide
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzn();
    private String zza;
    private String zzb;
    private Inet4Address zzc;
    private String zzd;
    private String zze;
    private String zzf;
    private int zzg;
    private List<WebImage> zzh;
    private int zzi;
    private int zzj;
    private String zzk;
    private String zzl;
    private int zzm;
    private String zzn;
    private byte[] zzo;

    CastDevice(String string, String string2, String string3, String string4, String string5, int n, List<WebImage> arrayList, int n2, int n3, String string6, String string7, int n4, String string8, byte[] byArray) {
        this.zza = CastDevice.zza(string);
        this.zzb = CastDevice.zza(string2);
        if (!TextUtils.isEmpty((CharSequence)this.zzb)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzb);
                if (inetAddress instanceof Inet4Address) {
                    this.zzc = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                String string9 = this.zzb;
                String string10 = unknownHostException.getMessage();
                Log.i((String)"CastDevice", (String)new StringBuilder(48 + String.valueOf(string9).length() + String.valueOf(string10).length()).append("Unable to convert host address (").append(string9).append(") to ipaddress: ").append(string10).toString());
            }
        }
        this.zzd = CastDevice.zza(string3);
        this.zze = CastDevice.zza(string4);
        this.zzf = CastDevice.zza(string5);
        this.zzg = n;
        this.zzh = arrayList != null ? arrayList : new ArrayList();
        this.zzi = n2;
        this.zzj = n3;
        this.zzk = CastDevice.zza(string6);
        this.zzl = string7;
        this.zzm = n4;
        this.zzn = string8;
        this.zzo = byArray;
    }

    public String getDeviceId() {
        if (this.zza.startsWith("__cast_nearby__")) {
            return this.zza.substring(16);
        }
        return this.zza;
    }

    public Inet4Address getIpAddress() {
        return this.zzc;
    }

    public String getFriendlyName() {
        return this.zzd;
    }

    public String getModelName() {
        return this.zze;
    }

    public String getDeviceVersion() {
        return this.zzf;
    }

    public int getServicePort() {
        return this.zzg;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzh);
    }

    public WebImage getIcon(int n, int n2) {
        if (this.zzh.isEmpty()) {
            return null;
        }
        if (n <= 0 || n2 <= 0) {
            return this.zzh.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzh) {
            int n3 = webImage3.getWidth();
            int n4 = webImage3.getHeight();
            if (n3 >= n && n4 >= n2) {
                if (webImage != null && (webImage.getWidth() <= n3 || webImage.getHeight() <= n4)) continue;
                webImage = webImage3;
                continue;
            }
            if (n3 >= n || n4 >= n2 || webImage2 != null && (webImage2.getWidth() >= n3 || webImage2.getHeight() >= n4)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzh.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzh.isEmpty();
    }

    public boolean hasCapability(int n) {
        return (this.zzi & n) == n;
    }

    public boolean hasCapabilities(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.hasCapability(n2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzd, this.zza);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastDevice castDevice = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)castDevice.zza, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)castDevice.zzb, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)castDevice.getFriendlyName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)castDevice.getModelName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)castDevice.getDeviceVersion(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (int)castDevice.getServicePort());
        zzbgo.zzc((Parcel)parcel2, (int)8, castDevice.getIcons(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (int)castDevice.zzi);
        zzbgo.zza((Parcel)parcel2, (int)10, (int)castDevice.zzj);
        zzbgo.zza((Parcel)parcel2, (int)11, (String)castDevice.zzk, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)12, (String)castDevice.zzl, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)13, (int)castDevice.zzm);
        zzbgo.zza((Parcel)parcel2, (int)14, (String)castDevice.zzn, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)15, (byte[])castDevice.zzo, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)((Object)object);
        if (this.zza == null) {
            return castDevice.zza == null;
        }
        return zzbdw.zza(this.zza, castDevice.zza) && zzbdw.zza(this.zzc, castDevice.zzc) && zzbdw.zza(this.zze, castDevice.zze) && zzbdw.zza(this.zzd, castDevice.zzd) && zzbdw.zza(this.zzf, castDevice.zzf) && this.zzg == castDevice.zzg && zzbdw.zza(this.zzh, castDevice.zzh) && this.zzi == castDevice.zzi && this.zzj == castDevice.zzj && zzbdw.zza(this.zzk, castDevice.zzk) && zzbdw.zza(this.zzm, castDevice.zzm) && zzbdw.zza(this.zzn, castDevice.zzn) && zzbdw.zza(this.zzl, castDevice.zzl) && zzbdw.zza(this.zzf, castDevice.getDeviceVersion()) && this.zzg == castDevice.getServicePort() && (this.zzo == null && castDevice.zzo == null || Arrays.equals(this.zzo, castDevice.zzo));
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (!(TextUtils.isEmpty((CharSequence)this.getDeviceId()) || this.getDeviceId().startsWith("__cast_ble__") || TextUtils.isEmpty((CharSequence)castDevice.getDeviceId()) || castDevice.getDeviceId().startsWith("__cast_ble__"))) {
            return zzbdw.zza(this.getDeviceId(), castDevice.getDeviceId());
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzn) && !TextUtils.isEmpty((CharSequence)castDevice.zzn)) {
            return zzbdw.zza(this.zzn, castDevice.zzn);
        }
        return false;
    }

    public int hashCode() {
        if (this.zza == null) {
            return 0;
        }
        return this.zza.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)bundle.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zza.startsWith("__cast_nearby__");
    }

    private static String zza(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

