/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.zzae;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaInfo
extends zzbgl
implements ReflectedParcelable {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    @Hide
    public static final Parcelable.Creator<MediaInfo> CREATOR = new zzae();
    private final String zza;
    private int zzb;
    private String zzc;
    private MediaMetadata zzd;
    private long zze;
    private List<MediaTrack> zzf;
    private TextTrackStyle zzg;
    private String zzh;
    private List<AdBreakInfo> zzi;
    private List<AdBreakClipInfo> zzj;
    private String zzk;
    private JSONObject zzl;

    MediaInfo(@NonNull String string2, int n, String string3, MediaMetadata mediaMetadata, long l, List<MediaTrack> list, TextTrackStyle textTrackStyle, String string4, List<AdBreakInfo> list2, List<AdBreakClipInfo> list3, String string5) {
        this.zza = string2;
        this.zzb = n;
        this.zzc = string3;
        this.zzd = mediaMetadata;
        this.zze = l;
        this.zzf = list;
        this.zzg = textTrackStyle;
        this.zzh = string4;
        if (this.zzh != null) {
            try {
                this.zzl = new JSONObject(this.zzh);
            }
            catch (JSONException jSONException) {
                this.zzl = null;
                this.zzh = null;
            }
        } else {
            this.zzl = null;
        }
        this.zzi = list2;
        this.zzj = list3;
        this.zzk = string5;
    }

    MediaInfo(String string2) throws IllegalArgumentException {
        this(string2, -1, null, null, -1L, null, null, null, null, null, null);
        if (string2 == null) {
            throw new IllegalArgumentException("contentID cannot be null");
        }
    }

    MediaInfo(String string2, String string3) throws IllegalArgumentException {
        this(string2, -1, null, null, -1L, null, null, null, null, null, string3);
        if (string2 == null) {
            throw new IllegalArgumentException("contentID cannot be null");
        }
    }

    MediaInfo(JSONObject jSONObject) throws JSONException {
        this(jSONObject.getString("contentId"), -1, null, null, -1L, null, null, null, null, null, null);
        double d;
        int n;
        JSONObject jSONObject2;
        String string2 = jSONObject.getString("streamType");
        this.zzb = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzc = jSONObject.getString("contentType");
        if (jSONObject.has("metadata")) {
            jSONObject2 = jSONObject.getJSONObject("metadata");
            n = jSONObject2.getInt("metadataType");
            this.zzd = new MediaMetadata(n);
            this.zzd.zza(jSONObject2);
        }
        this.zze = -1L;
        if (jSONObject.has("duration") && !jSONObject.isNull("duration") && !Double.isNaN(d = jSONObject.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zze = (long)(d * 1000.0);
        }
        if (jSONObject.has("tracks")) {
            this.zzf = new ArrayList<MediaTrack>();
            jSONObject2 = jSONObject.getJSONArray("tracks");
            for (n = 0; n < jSONObject2.length(); ++n) {
                JSONObject jSONObject3 = jSONObject2.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject3);
                this.zzf.add(mediaTrack);
            }
        } else {
            this.zzf = null;
        }
        if (jSONObject.has("textTrackStyle")) {
            jSONObject2 = jSONObject.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zza(jSONObject2);
            this.zzg = textTrackStyle;
        } else {
            this.zzg = null;
        }
        this.zzb(jSONObject);
        this.zzl = jSONObject.optJSONObject("customData");
        if (jSONObject.has("entity")) {
            this.zzk = jSONObject.getString("entity");
        }
    }

    public String getContentId() {
        return this.zza;
    }

    final void zza(int n) throws IllegalArgumentException {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzb = n;
    }

    public int getStreamType() {
        return this.zzb;
    }

    final void zza(String string2) {
        this.zzc = string2;
    }

    public String getContentType() {
        return this.zzc;
    }

    final void zza(MediaMetadata mediaMetadata) {
        this.zzd = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzd;
    }

    final void zza(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zze = l;
    }

    public long getStreamDuration() {
        return this.zze;
    }

    final void zza(List<MediaTrack> list) {
        this.zzf = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzf;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzg = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzg;
    }

    final void zza(JSONObject jSONObject) {
        this.zzl = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.zzl;
    }

    public List<AdBreakInfo> getAdBreaks() {
        if (this.zzi == null) {
            return null;
        }
        return Collections.unmodifiableList(this.zzi);
    }

    public List<AdBreakClipInfo> getAdBreakClips() {
        if (this.zzj == null) {
            return null;
        }
        return Collections.unmodifiableList(this.zzj);
    }

    @Hide
    public final void zzb(List<AdBreakInfo> list) {
        this.zzi = list;
    }

    @Hide
    final void zzc(List<AdBreakClipInfo> list) {
        this.zzj = list;
    }

    final void zzb(JSONObject jSONObject) throws JSONException {
        zzbgl zzbgl2;
        int n;
        JSONArray jSONArray;
        if (jSONObject.has("breaks")) {
            jSONArray = jSONObject.getJSONArray("breaks");
            this.zzi = new ArrayList<AdBreakInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zzbgl2 = AdBreakInfo.zza(jSONArray.getJSONObject(n));
                if (zzbgl2 == null) {
                    this.zzi.clear();
                    break;
                }
                this.zzi.add((AdBreakInfo)zzbgl2);
            }
        }
        if (jSONObject.has("breakClips")) {
            jSONArray = jSONObject.getJSONArray("breakClips");
            this.zzj = new ArrayList<AdBreakClipInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zzbgl2 = AdBreakClipInfo.zza(jSONArray.getJSONObject(n));
                if (zzbgl2 == null) {
                    this.zzj.clear();
                    return;
                }
                this.zzj.add((AdBreakClipInfo)zzbgl2);
            }
        }
    }

    public String getEntity() {
        return this.zzk;
    }

    @Hide
    public final void zzb(String string2) {
        this.zzk = string2;
    }

    @Hide
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray;
            String string2;
            jSONObject.put("contentId", (Object)this.zza);
            switch (this.zzb) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzc != null) {
                jSONObject.put("contentType", (Object)this.zzc);
            }
            if (this.zzd != null) {
                jSONObject.put("metadata", (Object)this.zzd.zza());
            }
            if (this.zze <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", (double)this.zze / 1000.0);
            }
            if (this.zzf != null) {
                jSONArray = new JSONArray();
                for (MediaTrack zzbgl2 : this.zzf) {
                    jSONArray.put((Object)zzbgl2.zza());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzg != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzg.zza());
            }
            if (this.zzl != null) {
                jSONObject.put("customData", (Object)this.zzl);
            }
            if (this.zzk != null) {
                jSONObject.put("entity", (Object)this.zzk);
            }
            if (this.zzi != null) {
                jSONArray = new JSONArray();
                for (AdBreakInfo adBreakInfo : this.zzi) {
                    jSONArray.put((Object)adBreakInfo.zza());
                }
                jSONObject.put("breaks", (Object)jSONArray);
            }
            if (this.zzj != null) {
                jSONArray = new JSONArray();
                for (AdBreakClipInfo adBreakClipInfo : this.zzj) {
                    jSONArray.put((Object)adBreakClipInfo.zza());
                }
                jSONObject.put("breakClips", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)((Object)object);
        if (this.zzl == null != (mediaInfo.zzl == null)) {
            return false;
        }
        if (this.zzl != null && mediaInfo.zzl != null && !zzq.zza((Object)this.zzl, (Object)mediaInfo.zzl)) {
            return false;
        }
        return zzbdw.zza(this.zza, mediaInfo.zza) && this.zzb == mediaInfo.zzb && zzbdw.zza(this.zzc, mediaInfo.zzc) && zzbdw.zza(this.zzd, mediaInfo.zzd) && this.zze == mediaInfo.zze && zzbdw.zza(this.zzf, mediaInfo.zzf) && zzbdw.zza(this.zzg, mediaInfo.zzg) && zzbdw.zza(this.zzi, mediaInfo.zzi) && zzbdw.zza(this.zzj, mediaInfo.zzj) && zzbdw.zza(this.zzk, mediaInfo.zzk);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze, String.valueOf(this.zzl), this.zzf, this.zzg, this.zzi, this.zzj, this.zzk});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzh = this.zzl == null ? null : this.zzl.toString();
        Parcel parcel2 = parcel;
        MediaInfo mediaInfo = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)mediaInfo.getContentId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (int)mediaInfo.getStreamType());
        zzbgo.zza((Parcel)parcel2, (int)4, (String)mediaInfo.getContentType(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)mediaInfo.getMetadata(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (long)mediaInfo.getStreamDuration());
        zzbgo.zzc((Parcel)parcel2, (int)7, mediaInfo.getMediaTracks(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (Parcelable)mediaInfo.getTextTrackStyle(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (String)mediaInfo.zzh, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)10, mediaInfo.getAdBreaks(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)11, mediaInfo.getAdBreakClips(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)12, (String)mediaInfo.getEntity(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private final MediaInfo zza;

        public Builder(String string2) throws IllegalArgumentException {
            this.zza = new MediaInfo(string2);
        }

        public Builder(String string2, String string3) throws IllegalArgumentException {
            this.zza = new MediaInfo(string2, string3);
        }

        public Builder setStreamType(int n) throws IllegalArgumentException {
            this.zza.zza(n);
            return this;
        }

        public Builder setContentType(String string2) {
            this.zza.zza(string2);
            return this;
        }

        public Builder setMetadata(MediaMetadata mediaMetadata) {
            this.zza.zza(mediaMetadata);
            return this;
        }

        public Builder setStreamDuration(long l) throws IllegalArgumentException {
            this.zza.zza(l);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zza.zza(jSONObject);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> list) {
            this.zza.zza(list);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zza.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public Builder setEntity(String string2) {
            this.zza.zzb(string2);
            return this;
        }

        public Builder setAdBreaks(List<AdBreakInfo> list) {
            this.zza.zzb(list);
            return this;
        }

        public Builder setAdBreakClips(List<AdBreakClipInfo> list) {
            this.zza.zzc(list);
            return this;
        }

        public MediaInfo build() {
            return this.zza;
        }
    }
}

