/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.zzag;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbep;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaMetadata
extends zzbgl {
    public static final int MEDIA_TYPE_GENERIC = 0;
    public static final int MEDIA_TYPE_MOVIE = 1;
    public static final int MEDIA_TYPE_TV_SHOW = 2;
    public static final int MEDIA_TYPE_MUSIC_TRACK = 3;
    public static final int MEDIA_TYPE_PHOTO = 4;
    public static final int MEDIA_TYPE_USER = 100;
    private static final String[] zza = new String[]{null, "String", "int", "double", "ISO-8601 date String"};
    private static final zza zzb;
    @Hide
    public static final Parcelable.Creator<MediaMetadata> CREATOR;
    private final List<WebImage> zzc;
    private Bundle zzd;
    private int zze;
    public static final String KEY_CREATION_DATE = "com.google.android.gms.cast.metadata.CREATION_DATE";
    public static final String KEY_RELEASE_DATE = "com.google.android.gms.cast.metadata.RELEASE_DATE";
    public static final String KEY_BROADCAST_DATE = "com.google.android.gms.cast.metadata.BROADCAST_DATE";
    public static final String KEY_TITLE = "com.google.android.gms.cast.metadata.TITLE";
    public static final String KEY_SUBTITLE = "com.google.android.gms.cast.metadata.SUBTITLE";
    public static final String KEY_ARTIST = "com.google.android.gms.cast.metadata.ARTIST";
    public static final String KEY_ALBUM_ARTIST = "com.google.android.gms.cast.metadata.ALBUM_ARTIST";
    public static final String KEY_ALBUM_TITLE = "com.google.android.gms.cast.metadata.ALBUM_TITLE";
    public static final String KEY_COMPOSER = "com.google.android.gms.cast.metadata.COMPOSER";
    public static final String KEY_DISC_NUMBER = "com.google.android.gms.cast.metadata.DISC_NUMBER";
    public static final String KEY_TRACK_NUMBER = "com.google.android.gms.cast.metadata.TRACK_NUMBER";
    public static final String KEY_SEASON_NUMBER = "com.google.android.gms.cast.metadata.SEASON_NUMBER";
    public static final String KEY_EPISODE_NUMBER = "com.google.android.gms.cast.metadata.EPISODE_NUMBER";
    public static final String KEY_SERIES_TITLE = "com.google.android.gms.cast.metadata.SERIES_TITLE";
    public static final String KEY_STUDIO = "com.google.android.gms.cast.metadata.STUDIO";
    public static final String KEY_WIDTH = "com.google.android.gms.cast.metadata.WIDTH";
    public static final String KEY_HEIGHT = "com.google.android.gms.cast.metadata.HEIGHT";
    public static final String KEY_LOCATION_NAME = "com.google.android.gms.cast.metadata.LOCATION_NAME";
    public static final String KEY_LOCATION_LATITUDE = "com.google.android.gms.cast.metadata.LOCATION_LATITUDE";
    public static final String KEY_LOCATION_LONGITUDE = "com.google.android.gms.cast.metadata.LOCATION_LONGITUDE";

    MediaMetadata(List<WebImage> list, Bundle bundle, int n) {
        this.zzc = list;
        this.zzd = bundle;
        this.zze = n;
    }

    public MediaMetadata() {
        this(0);
    }

    public MediaMetadata(int n) {
        this(new ArrayList<WebImage>(), new Bundle(), n);
    }

    public int getMediaType() {
        return this.zze;
    }

    public void clear() {
        this.zzd.clear();
        this.zzc.clear();
    }

    public boolean containsKey(String string2) {
        return this.zzd.containsKey(string2);
    }

    public Set<String> keySet() {
        return this.zzd.keySet();
    }

    public void putString(String string2, String string3) {
        MediaMetadata.zza(string2, 1);
        this.zzd.putString(string2, string3);
    }

    public String getString(String string2) {
        MediaMetadata.zza(string2, 1);
        return this.zzd.getString(string2);
    }

    public void putInt(String string2, int n) {
        MediaMetadata.zza(string2, 2);
        this.zzd.putInt(string2, n);
    }

    public int getInt(String string2) {
        MediaMetadata.zza(string2, 2);
        return this.zzd.getInt(string2);
    }

    public void putDouble(String string2, double d) {
        MediaMetadata.zza(string2, 3);
        this.zzd.putDouble(string2, d);
    }

    public double getDouble(String string2) {
        MediaMetadata.zza(string2, 3);
        return this.zzd.getDouble(string2);
    }

    public void putDate(String string2, Calendar calendar) {
        MediaMetadata.zza(string2, 4);
        this.zzd.putString(string2, zzbep.zza(calendar));
    }

    public Calendar getDate(String string2) {
        MediaMetadata.zza(string2, 4);
        String string3 = this.zzd.getString(string2);
        if (string3 != null) {
            return zzbep.zza(string3);
        }
        return null;
    }

    public String getDateAsString(String string2) {
        MediaMetadata.zza(string2, 4);
        return this.zzd.getString(string2);
    }

    private static void zza(String string2, int n) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("null and empty keys are not allowed");
        }
        int n2 = zzb.zzc(string2);
        if (n2 != n && n2 != 0) {
            String string3 = zza[n];
            throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Value for ").append(string2).append(" must be a ").append(string3).toString());
        }
    }

    @Hide
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("metadataType", this.zze);
        }
        catch (JSONException jSONException) {}
        zzbep.zza(jSONObject, this.zzc);
        switch (this.zze) {
            case 0: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.zza(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.zza(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_ALBUM_TITLE, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.zza(jSONObject, new String[0]);
            }
        }
        return jSONObject;
    }

    @Hide
    public final void zza(JSONObject jSONObject) {
        this.clear();
        this.zze = 0;
        try {
            this.zze = jSONObject.getInt("metadataType");
        }
        catch (JSONException jSONException) {}
        zzbep.zza(this.zzc, jSONObject);
        switch (this.zze) {
            case 0: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                return;
            }
            case 1: {
                this.zzb(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                return;
            }
            case 2: {
                this.zzb(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                return;
            }
            case 3: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ALBUM_TITLE, KEY_ARTIST, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                return;
            }
            case 4: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                return;
            }
        }
        this.zzb(jSONObject, new String[0]);
    }

    private final void zza(JSONObject jSONObject, String ... stringArray) {
        try {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            block7: for (int i = 0; i < n; ++i) {
                String string2 = stringArray2[i];
                if (!this.zzd.containsKey(string2)) continue;
                switch (zzb.zzc(string2)) {
                    case 1: 
                    case 4: {
                        jSONObject.put(zzb.zza(string2), (Object)this.zzd.getString(string2));
                        continue block7;
                    }
                    case 2: {
                        jSONObject.put(zzb.zza(string2), this.zzd.getInt(string2));
                        continue block7;
                    }
                    case 3: {
                        jSONObject.put(zzb.zza(string2), this.zzd.getDouble(string2));
                    }
                }
            }
            for (String string3 : this.zzd.keySet()) {
                if (string3.startsWith("com.google.")) continue;
                Object object = this.zzd.get(string3);
                if (object instanceof String) {
                    jSONObject.put(string3, object);
                    continue;
                }
                if (object instanceof Integer) {
                    jSONObject.put(string3, object);
                    continue;
                }
                if (!(object instanceof Double)) continue;
                jSONObject.put(string3, object);
            }
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
    }

    private final void zzb(JSONObject jSONObject, String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        try {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                Object object;
                String string2 = (String)iterator.next();
                if ("metadataType".equals(string2)) continue;
                String string3 = zzb.zzb(string2);
                if (string3 != null) {
                    if (!hashSet.contains(string3)) continue;
                    try {
                        object = jSONObject.get(string2);
                        if (object == null) continue;
                        switch (zzb.zzc(string3)) {
                            case 1: {
                                if (!(object instanceof String)) break;
                                this.zzd.putString(string3, (String)object);
                                break;
                            }
                            case 4: {
                                if (!(object instanceof String) || zzbep.zza((String)object) == null) break;
                                this.zzd.putString(string3, (String)object);
                                break;
                            }
                            case 2: {
                                if (!(object instanceof Integer)) break;
                                this.zzd.putInt(string3, ((Integer)object).intValue());
                                break;
                            }
                            case 3: {
                                if (!(object instanceof Double)) break;
                                this.zzd.putDouble(string3, ((Double)object).doubleValue());
                            }
                        }
                    }
                    catch (JSONException jSONException) {}
                    continue;
                }
                object = jSONObject.get(string2);
                if (object instanceof String) {
                    this.zzd.putString(string2, (String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    this.zzd.putInt(string2, ((Integer)object).intValue());
                    continue;
                }
                if (!(object instanceof Double)) continue;
                this.zzd.putDouble(string2, ((Double)object).doubleValue());
            }
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaMetadata)) {
            return false;
        }
        MediaMetadata mediaMetadata = (MediaMetadata)((Object)object);
        return this.zza(this.zzd, mediaMetadata.zzd) && this.zzc.equals(mediaMetadata.zzc);
    }

    public int hashCode() {
        int n = 17;
        for (String string2 : this.zzd.keySet()) {
            n = n * 31 + this.zzd.get(string2).hashCode();
        }
        return n * 31 + this.zzc.hashCode();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MediaMetadata mediaMetadata = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)2, mediaMetadata.getImages(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Bundle)mediaMetadata.zzd, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (int)mediaMetadata.getMediaType());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public List<WebImage> getImages() {
        return this.zzc;
    }

    public boolean hasImages() {
        return this.zzc != null && !this.zzc.isEmpty();
    }

    public void clearImages() {
        this.zzc.clear();
    }

    public void addImage(WebImage webImage) {
        this.zzc.add(webImage);
    }

    private final boolean zza(Bundle bundle, Bundle bundle2) {
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string2 : bundle.keySet()) {
            Object object = bundle.get(string2);
            Object object2 = bundle2.get(string2);
            if (object instanceof Bundle && object2 instanceof Bundle && !this.zza((Bundle)object, (Bundle)object2)) {
                return false;
            }
            if (!(object == null ? object2 != null || !bundle2.containsKey(string2) : !object.equals(object2))) continue;
            return false;
        }
        return true;
    }

    static {
        CREATOR = new zzag();
        zzb = new zza().zza(KEY_CREATION_DATE, "creationDateTime", 4).zza(KEY_RELEASE_DATE, "releaseDate", 4).zza(KEY_BROADCAST_DATE, "originalAirdate", 4).zza(KEY_TITLE, "title", 1).zza(KEY_SUBTITLE, "subtitle", 1).zza(KEY_ARTIST, "artist", 1).zza(KEY_ALBUM_ARTIST, "albumArtist", 1).zza(KEY_ALBUM_TITLE, "albumName", 1).zza(KEY_COMPOSER, "composer", 1).zza(KEY_DISC_NUMBER, "discNumber", 2).zza(KEY_TRACK_NUMBER, "trackNumber", 2).zza(KEY_SEASON_NUMBER, "season", 2).zza(KEY_EPISODE_NUMBER, "episode", 2).zza(KEY_SERIES_TITLE, "seriesTitle", 1).zza(KEY_STUDIO, "studio", 1).zza(KEY_WIDTH, "width", 2).zza(KEY_HEIGHT, "height", 2).zza(KEY_LOCATION_NAME, "location", 1).zza(KEY_LOCATION_LATITUDE, "latitude", 3).zza(KEY_LOCATION_LONGITUDE, "longitude", 3);
    }

    static final class zza {
        private final Map<String, String> zza = new HashMap<String, String>();
        private final Map<String, String> zzb = new HashMap<String, String>();
        private final Map<String, Integer> zzc = new HashMap<String, Integer>();

        public final zza zza(String string2, String string3, int n) {
            this.zza.put(string2, string3);
            this.zzb.put(string3, string2);
            this.zzc.put(string2, n);
            return this;
        }

        public final String zza(String string2) {
            return this.zza.get(string2);
        }

        public final String zzb(String string2) {
            return this.zzb.get(string2);
        }

        public final int zzc(String string2) {
            Integer n = this.zzc.get(string2);
            if (n != null) {
                return n;
            }
            return 0;
        }
    }
}

