/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbco;
import com.google.android.gms.internal.zzbcp;
import com.google.android.gms.internal.zzbcq;
import com.google.android.gms.internal.zzbcy;
import com.google.android.gms.internal.zzbcz;
import com.google.android.gms.internal.zzbda;
import com.google.android.gms.internal.zzbdb;
import com.google.android.gms.internal.zzbdc;
import com.google.android.gms.internal.zzbdg;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzben;
import com.google.android.gms.internal.zzbeo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbcl
extends zzbdg {
    private static String zzd = zzbdw.zzb("com.google.cast.games");
    private static final zzbei zze = new zzbei("GameManagerChannel");
    private final Map<String, String> zzf = new ConcurrentHashMap<String, String>();
    private final List<zzbeo> zzg;
    private final SharedPreferences zzh;
    private final String zzi;
    private final Cast.CastApi zzj;
    private final GoogleApiClient zzk;
    private zzbcy zzl;
    private boolean zzm = false;
    private GameManagerState zzn;
    private GameManagerState zzo;
    private String zzp;
    private JSONObject zzq;
    private long zzr = 0L;
    private GameManagerClient.Listener zzs;
    private final zze zzt;
    private String zzu;

    public zzbcl(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(zzd, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzt = com.google.android.gms.common.util.zzi.zzd();
        this.zzg = new ArrayList<zzbeo>();
        this.zzi = string2;
        this.zzj = castApi;
        this.zzk = googleApiClient;
        Context context = googleApiClient.zzb().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzh = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.zzo = null;
        this.zzn = new zzbda(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        return this.zzk.zzb((zzm)new zzbcm(this, gameManagerClient));
    }

    public final synchronized void zza() throws IllegalStateException {
        if (this.zzm) {
            return;
        }
        this.zzn = null;
        this.zzo = null;
        this.zzp = null;
        this.zzq = null;
        this.zzm = true;
        try {
            this.zzj.removeMessageReceivedCallbacks(this.zzk, this.zzg());
            return;
        }
        catch (IOException iOException) {
            zze.zzc("Exception while detaching game manager channel.", iOException);
            return;
        }
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerResult> zza(String string2, int n, JSONObject jSONObject) throws IllegalStateException {
        this.zzj();
        return this.zzk.zzb((zzm)new zzbco(this, n, string2, jSONObject));
    }

    public final synchronized void zza(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzj();
        long l = ++this.zzr;
        JSONObject jSONObject2 = this.zza(l, string2, 7, jSONObject);
        if (jSONObject2 == null) {
            return;
        }
        this.zzj.sendMessage(this.zzk, this.zzg(), jSONObject2.toString());
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerResult> zzb(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzj();
        return this.zzk.zzb((zzm)new zzbcp(this, string2, jSONObject));
    }

    public final synchronized GameManagerState zzb() throws IllegalStateException {
        this.zzj();
        return this.zzn;
    }

    public final synchronized String zzc() throws IllegalStateException {
        this.zzj();
        return this.zzu;
    }

    private final synchronized String zzc(String string2) throws IllegalStateException {
        if (string2 == null) {
            return null;
        }
        return this.zzf.get(string2);
    }

    public final synchronized void zza(GameManagerClient.Listener listener) {
        this.zzs = listener;
    }

    @Override
    public final void zza(String string2) {
        int n;
        zzbcz zzbcz2;
        zze.zza("message received: %s", string2);
        try {
            zzbcz2 = zzbcz.zza(new JSONObject(string2));
        }
        catch (JSONException jSONException) {
            zze.zzc("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzbcz2 == null) {
            zze.zzc("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.zzi() && zzbcz2.zzm == null || this.zzd()) {
            return;
        }
        boolean bl = zzbcz2.zza == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzbcz2.zzl)) {
            this.zzf.put(zzbcz2.zzj, zzbcz2.zzl);
            this.zzk();
        }
        if (zzbcz2.zzb == 0) {
            this.zza(zzbcz2);
        } else {
            zze.zzc("Not updating from game message because the message contains error code: %d", zzbcz2.zzb);
        }
        int n2 = zzbcz2.zzb;
        switch (n2) {
            case 4: {
                int n3 = 2151;
                break;
            }
            case 3: {
                int n3 = 2150;
                break;
            }
            case 2: {
                int n3 = 2003;
                break;
            }
            case 1: {
                int n3 = 2001;
                break;
            }
            case 0: {
                int n3 = 0;
                break;
            }
            default: {
                zze.zzc(new StringBuilder(53).append("Unknown GameManager protocol status code: ").append(n2).toString(), new Object[0]);
                int n3 = n = 13;
            }
        }
        if (bl) {
            this.zza(zzbcz2.zzk, n, zzbcz2);
        }
        if (this.zzi() && n == 0) {
            zzbcl zzbcl2 = this;
            if (zzbcl2.zzs != null) {
                if (zzbcl2.zzo != null && !zzbcl2.zzn.equals(zzbcl2.zzo)) {
                    zzbcl2.zzs.onStateChanged(zzbcl2.zzn, zzbcl2.zzo);
                }
                if (zzbcl2.zzq != null && zzbcl2.zzp != null) {
                    zzbcl2.zzs.onGameMessageReceived(zzbcl2.zzp, zzbcl2.zzq);
                }
            }
            zzbcl2.zzo = null;
            zzbcl2.zzp = null;
            zzbcl2.zzq = null;
        }
    }

    public final synchronized boolean zzd() {
        return this.zzm;
    }

    private final synchronized boolean zzi() {
        return this.zzl != null;
    }

    @Override
    public final void zza(long l, int n) {
        this.zza(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zza(long l) {
        Iterator<zzbeo> iterator = this.zzg.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zza(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzbeo.zza;
        synchronized (object) {
            Iterator<zzbeo> iterator2 = this.zzg.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().zzb()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private final synchronized void zzj() throws IllegalStateException {
        if (!this.zzi()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.zzd()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private final void zza(String string2, int n, JSONObject jSONObject, zzben zzben2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzr, string2, n, jSONObject)) == null) {
            zzben2.zza(-1L, 2001, null);
            zze.zzc("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzbeo zzbeo2 = new zzbeo(this.zzt, 30000L);
        zzbeo2.zza(l, zzben2);
        this.zzg.add(zzbeo2);
        this.zza(true);
        this.zzj.sendMessage(this.zzk, this.zzg(), jSONObject2.toString()).setResultCallback((ResultCallback)new zzbcq(this, l));
    }

    private final JSONObject zza(long l, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzc(string2));
        }
        catch (JSONException jSONException) {
            zze.zzc("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private final synchronized void zza(zzbcz zzbcz2) {
        boolean bl = zzbcz2.zza == 1;
        this.zzo = this.zzn;
        if (bl && zzbcz2.zzm != null) {
            this.zzl = zzbcz2.zzm;
        }
        if (!this.zzi()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzbdc zzbdc2 : zzbcz2.zzg) {
            String string2 = zzbdc2.zzc();
            zzbdb zzbdb2 = new zzbdb(string2, zzbdc2.zza(), zzbdc2.zzb(), this.zzf.containsKey(string2));
            arrayList.add(zzbdb2);
        }
        this.zzn = new zzbda(zzbcz2.zzf, zzbcz2.zze, zzbcz2.zzi, zzbcz2.zzh, arrayList, this.zzl.zza(), this.zzl.zzb());
        PlayerInfo playerInfo = this.zzn.getPlayer(zzbcz2.zzj);
        if (playerInfo != null && playerInfo.isControllable() && zzbcz2.zza == 2) {
            this.zzp = zzbcz2.zzj;
            this.zzq = zzbcz2.zzd;
        }
    }

    private final void zza(long l, int n, Object object) {
        Iterator<zzbeo> iterator = this.zzg.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zza(l, n, object)) continue;
            iterator.remove();
        }
    }

    private final synchronized void zzk() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzi);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzf));
            this.zzh.edit().putString("save_data", jSONObject.toString()).commit();
            return;
        }
        catch (JSONException jSONException) {
            zze.zzc("Error while saving data: %s", jSONException.getMessage());
            return;
        }
    }

    private final synchronized void zzl() {
        String string2 = this.zzh.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.zzi.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.zzf.put(string4, jSONObject2.getString(string4));
                }
                this.zzr = 0L;
            }
            return;
        }
        catch (JSONException jSONException) {
            zze.zzc("Error while loading data: %s", jSONException.getMessage());
            return;
        }
    }

    static /* synthetic */ GoogleApiClient zza(zzbcl zzbcl2) {
        return zzbcl2.zzk;
    }

    static /* synthetic */ Cast.CastApi zzb(zzbcl zzbcl2) {
        return zzbcl2.zzj;
    }

    static /* synthetic */ void zzc(zzbcl zzbcl2) {
        zzbcl2.zzl();
    }

    static /* synthetic */ void zzd(zzbcl zzbcl2) {
        zzbcl2.zzk();
    }

    static /* synthetic */ void zza(zzbcl zzbcl2, String string2, int n, JSONObject jSONObject, zzben zzben2) {
        zzbcl2.zza(string2, n, jSONObject, zzben2);
    }

    static /* synthetic */ zzbei zze() {
        return zze;
    }

    static /* synthetic */ zzbcy zza(zzbcl zzbcl2, zzbcy zzbcy2) {
        zzbcl2.zzl = null;
        return null;
    }

    static /* synthetic */ String zza(zzbcl zzbcl2, String string2) {
        zzbcl2.zzu = string2;
        return zzbcl2.zzu;
    }
}

