/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.zzd;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ApplicationMetadata
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<ApplicationMetadata> CREATOR = new zzd();
    private String zzetb;
    private String mName;
    private List<WebImage> zzbxw;
    private List<String> zzetc;
    private String zzetd;
    private Uri zzete;

    ApplicationMetadata(String string, String string2, List<WebImage> list, List<String> list2, String string3, Uri uri) {
        this.zzetb = string;
        this.mName = string2;
        this.zzbxw = list;
        this.zzetc = list2;
        this.zzetd = string3;
        this.zzete = uri;
    }

    private ApplicationMetadata() {
        this.zzbxw = new ArrayList<WebImage>();
        this.zzetc = new ArrayList<String>();
    }

    public String getApplicationId() {
        return this.zzetb;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isNamespaceSupported(String string) {
        return this.zzetc != null && this.zzetc.contains(string);
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzetc);
    }

    public boolean areNamespacesSupported(List<String> list) {
        return this.zzetc != null && this.zzetc.containsAll(list);
    }

    public String getSenderAppIdentifier() {
        return this.zzetd;
    }

    public List<WebImage> getImages() {
        return this.zzbxw;
    }

    public String toString() {
        return "applicationId: " + this.zzetb + ", name: " + this.mName + ", images.count: " + (this.zzbxw == null ? 0 : this.zzbxw.size()) + ", namespaces.count: " + (this.zzetc == null ? 0 : this.zzetc.size()) + ", senderAppIdentifier: " + this.zzetd + ", senderAppLaunchUrl: " + this.zzete;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ApplicationMetadata applicationMetadata = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)applicationMetadata.getApplicationId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)applicationMetadata.getName(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)4, applicationMetadata.getImages(), (boolean)false);
        zzbgo.zzb((Parcel)parcel2, (int)5, applicationMetadata.getSupportedNamespaces(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)applicationMetadata.getSenderAppIdentifier(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)applicationMetadata.zzete, (int)n, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzetb, this.mName, this.zzbxw, this.zzetc, this.zzetd, this.zzete});
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ApplicationMetadata)) {
            return false;
        }
        ApplicationMetadata applicationMetadata = (ApplicationMetadata)((Object)object);
        return zzbdw.zza(this.zzetb, applicationMetadata.zzetb) && zzbdw.zza(this.zzbxw, applicationMetadata.zzbxw) && zzbdw.zza(this.mName, applicationMetadata.mName) && zzbdw.zza(this.zzetc, applicationMetadata.zzetc) && zzbdw.zza(this.zzetd, applicationMetadata.zzetd) && zzbdw.zza(this.zzete, applicationMetadata.zzete);
    }
}

