/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayClient;
import com.google.android.gms.cast.zzaa;
import com.google.android.gms.cast.zzu;
import com.google.android.gms.cast.zzv;
import com.google.android.gms.cast.zzw;
import com.google.android.gms.cast.zzx;
import com.google.android.gms.cast.zzy;
import com.google.android.gms.cast.zzz;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.tasks.OnCompleteListener;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=19)
public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzbei zzeus = new zzbei("CastRemoteDisplayLocalService");
    private static final int zzeut = R.id.cast_notification_id;
    private static final Object zzeuu = new Object();
    private static AtomicBoolean zzeuv = new AtomicBoolean(false);
    private String zzetb;
    private WeakReference<Callbacks> zzeuw;
    private zzb zzeux;
    private NotificationSettings zzeuy;
    private Notification mNotification;
    private boolean zzeuz;
    private PendingIntent zzeva;
    private CastDevice zzevb;
    private Display zzdmh;
    private Context zzevc;
    private ServiceConnection zzevd;
    private Handler mHandler;
    private MediaRouter zzeve;
    private boolean zzevf = false;
    private CastRemoteDisplayClient zzevg;
    private final MediaRouter.Callback zzevh = new zzu(this);
    private static CastRemoteDisplayLocalService zzevi;
    private final IBinder zzevj = new zza();

    public CastRemoteDisplayLocalService() {
    }

    public IBinder onBind(Intent intent) {
        this.zzeb("onBind");
        return this.zzevj;
    }

    public void onCreate() {
        this.zzeb("onCreate");
        super.onCreate();
        this.mHandler = new Handler(this.getMainLooper());
        this.mHandler.postDelayed((Runnable)new zzv(this), 100L);
        if (this.zzevg == null) {
            this.zzevg = CastRemoteDisplay.getClient((Context)this);
        }
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        if (zzs.isAtLeastO()) {
            NotificationManager notificationManager = (NotificationManager)castRemoteDisplayLocalService.getSystemService(NotificationManager.class);
            NotificationChannel notificationChannel = new NotificationChannel("cast_remote_display_local_service", (CharSequence)castRemoteDisplayLocalService.getString(R.string.cast_notification_default_channel_name), 2);
            notificationChannel.setShowBadge(false);
            notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        this.zzeb("onStartCommand");
        this.zzevf = true;
        return 2;
    }

    protected static void setDebugEnabled() {
        zzeus.zzbh(true);
    }

    protected Display getDisplay() {
        return this.zzdmh;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzeuu;
        synchronized (object) {
            return zzevi;
        }
    }

    public static void startService(Context context, Class<? extends CastRemoteDisplayLocalService> clazz, String string2, CastDevice castDevice, NotificationSettings notificationSettings, Callbacks callbacks) {
        CastRemoteDisplayLocalService.startServiceWithOptions(context, clazz, string2, castDevice, new Options(), notificationSettings, callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServiceWithOptions(@NonNull Context context, @NonNull Class<? extends CastRemoteDisplayLocalService> clazz, @NonNull String string2, @NonNull CastDevice castDevice, @NonNull Options options, @NonNull NotificationSettings notificationSettings, @NonNull Callbacks callbacks) {
        zzeus.zzb("Starting Service", new Object[0]);
        Object object = zzeuu;
        synchronized (object) {
            if (zzevi != null) {
                zzeus.zzf("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzax(true);
            }
        }
        Class<? extends CastRemoteDisplayLocalService> clazz2 = clazz;
        Context context2 = context;
        try {
            ComponentName componentName = new ComponentName(context2, clazz2);
            ServiceInfo serviceInfo = context2.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
        zzbq.checkNotNull((Object)context, (Object)"activityContext is required.");
        zzbq.checkNotNull(clazz, (Object)"serviceClass is required.");
        zzbq.checkNotNull((Object)string2, (Object)"applicationId is required.");
        zzbq.checkNotNull((Object)((Object)castDevice), (Object)"device is required.");
        zzbq.checkNotNull((Object)options, (Object)"options is required.");
        zzbq.checkNotNull((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzbq.checkNotNull((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.zzevr == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzeuv.getAndSet(true)) {
            zzeus.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(context, clazz);
        context.startService((Intent)object);
        context.bindService((Intent)object, (ServiceConnection)new zzw(string2, castDevice, options, notificationSettings, context, callbacks), 64);
    }

    private final void zzaw(boolean bl) {
        this.zzeb("Stopping Service");
        zzbq.zzgn((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.zzeve != null) {
            this.zzeb("Setting default route");
            this.zzeve.selectRoute(this.zzeve.getDefaultRoute());
        }
        if (this.zzeux != null) {
            this.zzeb("Unregistering notification receiver");
            this.unregisterReceiver(this.zzeux);
        }
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zzeb("stopRemoteDisplaySession");
        CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = castRemoteDisplayLocalService;
        castRemoteDisplayLocalService2.zzeb("stopRemoteDisplay");
        castRemoteDisplayLocalService2.zzevg.stopRemoteDisplay().addOnCompleteListener((OnCompleteListener)new zzaa(castRemoteDisplayLocalService2));
        if (castRemoteDisplayLocalService.zzeuw.get() != null) {
            ((Callbacks)castRemoteDisplayLocalService.zzeuw.get()).onRemoteDisplaySessionEnded(castRemoteDisplayLocalService);
        }
        castRemoteDisplayLocalService.onDismissPresentation();
        castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zzeb("Stopping the remote display Service");
        castRemoteDisplayLocalService.stopForeground(true);
        castRemoteDisplayLocalService.stopSelf();
        castRemoteDisplayLocalService = this;
        if (castRemoteDisplayLocalService.zzeve != null) {
            zzbq.zzgn((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            castRemoteDisplayLocalService.zzeb("removeMediaRouterCallback");
            castRemoteDisplayLocalService.zzeve.removeCallback(castRemoteDisplayLocalService.zzevh);
        }
        if (this.zzevc != null && this.zzevd != null) {
            try {
                this.zzevc.unbindService(this.zzevd);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzeb("No need to unbind service, already unbound");
            }
            this.zzevd = null;
            this.zzevc = null;
        }
        this.zzetb = null;
        this.mNotification = null;
        this.zzdmh = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzax(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zzeus.zzb("Stopping Service", new Object[0]);
        zzeuv.set(false);
        Object object = zzeuu;
        synchronized (object) {
            if (zzevi == null) {
                zzeus.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzevi;
            zzevi = null;
        }
        boolean bl2 = bl;
        CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = castRemoteDisplayLocalService;
        if (castRemoteDisplayLocalService2.mHandler != null) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                castRemoteDisplayLocalService2.mHandler.post((Runnable)new zzx(castRemoteDisplayLocalService2, bl2));
                return;
            }
            castRemoteDisplayLocalService2.zzaw(bl2);
        }
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzax(false);
    }

    public void updateNotificationSettings(NotificationSettings notificationSettings) {
        zzbq.checkNotNull((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzbq.checkNotNull((Object)this.mHandler, (Object)"Service is not ready yet.");
        this.mHandler.post((Runnable)new zzy(this, notificationSettings));
    }

    private final void zza(NotificationSettings notificationSettings) {
        zzbq.zzgn((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (this.zzeuy == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.zzeuz) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzevr != null) {
                this.zzeuy.zzevr = notificationSettings.zzevr;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzevs)) {
                this.zzeuy.zzevs = notificationSettings.zzevs;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzevt)) {
                this.zzeuy.zzevt = notificationSettings.zzevt;
            }
            this.mNotification = this.zzay(true);
        } else {
            zzbq.checkNotNull((Object)notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.zzeuy.mNotification = this.mNotification;
        }
        this.startForeground(zzeut, this.mNotification);
    }

    private final void zza(Display display) {
        this.zzdmh = display;
        if (this.zzeuz) {
            this.mNotification = this.zzay(true);
            this.startForeground(zzeut, this.mNotification);
        }
        if (this.zzeuw.get() != null) {
            ((Callbacks)this.zzeuw.get()).onRemoteDisplaySessionStarted(this);
        }
        this.onCreatePresentation(this.zzdmh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zzeb("startRemoteDisplaySession");
        zzbq.zzgn((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = zzeuu;
        synchronized (object) {
            if (zzevi != null) {
                zzeus.zzf("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            zzevi = this;
        }
        this.zzeuw = new WeakReference<Callbacks>(callbacks);
        this.zzetb = string2;
        this.zzevb = castDevice;
        this.zzevc = context;
        this.zzevd = serviceConnection;
        if (this.zzeve == null) {
            this.zzeve = MediaRouter.getInstance((Context)this.getApplicationContext());
        }
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zzetb)).build();
        this.zzeb("addMediaRouterCallback");
        this.zzeve.addCallback((MediaRouteSelector)object, this.zzevh, 4);
        this.mNotification = notificationSettings.mNotification;
        this.zzeux = new zzb(null);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
        intentFilter.addAction("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED");
        this.registerReceiver(this.zzeux, intentFilter);
        this.zzeuy = new NotificationSettings(notificationSettings, null);
        if (this.zzeuy.mNotification == null) {
            this.zzeuz = true;
            this.mNotification = this.zzay(false);
        } else {
            this.zzeuz = false;
            this.mNotification = this.zzeuy.mNotification;
        }
        this.startForeground(zzeut, this.mNotification);
        Options options2 = options;
        CastDevice castDevice2 = castDevice;
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zzeb("startRemoteDisplay");
        Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED");
        intent.setPackage(castRemoteDisplayLocalService.zzevc.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)castRemoteDisplayLocalService, (int)0, (Intent)intent, (int)0);
        castRemoteDisplayLocalService.zzevg.startRemoteDisplay(castDevice2, castRemoteDisplayLocalService.zzetb, options2.getConfigPreset(), pendingIntent).addOnCompleteListener((OnCompleteListener)new zzz(castRemoteDisplayLocalService));
        if (this.zzeuw.get() != null) {
            ((Callbacks)this.zzeuw.get()).onServiceCreated(this);
        }
        return true;
    }

    private final void zzadp() {
        if (this.zzeuw.get() != null) {
            ((Callbacks)this.zzeuw.get()).onRemoteDisplaySessionError(new Status(2200));
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private final Notification zzay(boolean bl) {
        int n;
        int n2;
        this.zzeb("createDefaultNotification");
        String string2 = this.zzeuy.zzevs;
        String string3 = this.zzeuy.zzevt;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? (String)this.getPackageManager().getApplicationLabel(this.getApplicationInfo()) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzevb.getFriendlyName()}) : string3;
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, "cast_remote_display_local_service").setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzeuy.zzevr).setSmallIcon(n).setOngoing(true);
        String string6 = this.getString(R.string.cast_notification_disconnect);
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        if (castRemoteDisplayLocalService.zzeva == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            intent.setPackage(castRemoteDisplayLocalService.zzevc.getPackageName());
            castRemoteDisplayLocalService.zzeva = PendingIntent.getBroadcast((Context)castRemoteDisplayLocalService, (int)0, (Intent)intent, (int)0x8000000);
        }
        return builder.addAction(17301560, (CharSequence)string6, castRemoteDisplayLocalService.zzeva).build();
    }

    private final void zzeb(String string2) {
        zzeus.zzb("[Instance: %s] %s", new Object[]{this, string2});
    }

    private final void zzee(String string2) {
        zzeus.zzc("[Instance: %s] %s", new Object[]{this, string2});
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2) {
        castRemoteDisplayLocalService.zzeb(string2);
    }

    static /* synthetic */ CastDevice zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzevb;
    }

    static /* synthetic */ boolean zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzevf;
    }

    static /* synthetic */ void zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2) {
        castRemoteDisplayLocalService.zzee(string2);
    }

    static /* synthetic */ boolean zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        return castRemoteDisplayLocalService.zza(string2, castDevice, options, notificationSettings, context, serviceConnection, callbacks);
    }

    static /* synthetic */ zzbei zzadq() {
        return zzeus;
    }

    static /* synthetic */ AtomicBoolean zzadr() {
        return zzeuv;
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, boolean bl) {
        castRemoteDisplayLocalService.zzaw(bl);
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, NotificationSettings notificationSettings) {
        castRemoteDisplayLocalService.zza(notificationSettings);
    }

    static /* synthetic */ void zzc(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        castRemoteDisplayLocalService.zzadp();
    }

    static /* synthetic */ Object zzads() {
        return zzeuu;
    }

    static /* synthetic */ CastRemoteDisplayLocalService zzadt() {
        return zzevi;
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display display) {
        castRemoteDisplayLocalService.zza(display);
    }

    static /* synthetic */ Context zzd(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzevc;
    }

    static /* synthetic */ ServiceConnection zze(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzevd;
    }

    static /* synthetic */ ServiceConnection zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, ServiceConnection serviceConnection) {
        castRemoteDisplayLocalService.zzevd = null;
        return null;
    }

    static /* synthetic */ Context zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Context context) {
        castRemoteDisplayLocalService.zzevc = null;
        return null;
    }

    static /* synthetic */ WeakReference zzf(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzeuw;
    }

    static /* synthetic */ Display zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display display) {
        castRemoteDisplayLocalService.zzdmh = null;
        return null;
    }

    @VisibleForTesting
    final class zza
    extends Binder {
        zza() {
        }
    }

    static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public final void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                CastRemoteDisplayLocalService.stopService();
                return;
            }
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED")) {
                CastRemoteDisplayLocalService.zzax(false);
            }
        }

        /* synthetic */ zzb(zzu zzu2) {
            this();
        }
    }

    public static class Options {
        @CastRemoteDisplay.Configuration
        private int zzeuf = 2;

        public Options() {
        }

        public void setConfigPreset(@CastRemoteDisplay.Configuration int n) {
            this.zzeuf = n;
        }

        @CastRemoteDisplay.Configuration
        public int getConfigPreset() {
            return this.zzeuf;
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent zzevr;
        private String zzevs;
        private String zzevt;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings notificationSettings) {
            this.mNotification = notificationSettings.mNotification;
            this.zzevr = notificationSettings.zzevr;
            this.zzevs = notificationSettings.zzevs;
            this.zzevt = notificationSettings.zzevt;
        }

        /* synthetic */ NotificationSettings(zzu zzu2) {
            this();
        }

        /* synthetic */ NotificationSettings(NotificationSettings notificationSettings, zzu zzu2) {
            this(notificationSettings);
        }

        public static final class Builder {
            private NotificationSettings zzevu = new NotificationSettings(null);

            public Builder() {
            }

            public final Builder setNotification(Notification notification) {
                this.zzevu.mNotification = notification;
                return this;
            }

            public final Builder setNotificationPendingIntent(PendingIntent pendingIntent) {
                this.zzevu.zzevr = pendingIntent;
                return this;
            }

            public final Builder setNotificationTitle(String string2) {
                this.zzevu.zzevs = string2;
                return this;
            }

            public final Builder setNotificationText(String string2) {
                this.zzevu.zzevt = string2;
                return this;
            }

            public final NotificationSettings build() {
                if (this.zzevu.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zzevu.zzevs)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zzevu.zzevt)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zzevu.zzevr != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zzevu.zzevs) && TextUtils.isEmpty((CharSequence)this.zzevu.zzevt) && this.zzevu.zzevr == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zzevu;
            }
        }
    }

    public static interface Callbacks {
        public void onServiceCreated(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);

        public void onRemoteDisplaySessionEnded(CastRemoteDisplayLocalService var1);
    }
}

