/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.zzah;
import com.google.android.gms.cast.zzai;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem
extends zzbgl {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    @Hide
    public static final Parcelable.Creator<MediaQueueItem> CREATOR = new zzai();
    private MediaInfo zzewv;
    private int zzeww;
    private boolean zzewi;
    private double zzewx;
    private double zzewy;
    private double zzewz;
    private long[] zzewl;
    private String zzesn;
    private JSONObject zzess;

    MediaQueueItem(MediaInfo mediaInfo, int n, boolean bl, double d, double d2, double d3, long[] lArray, String string2) {
        this.zzewv = mediaInfo;
        this.zzeww = n;
        this.zzewi = bl;
        this.zzewx = d;
        this.zzewy = d2;
        this.zzewz = d3;
        this.zzewl = lArray;
        this.zzesn = string2;
        if (this.zzesn != null) {
            try {
                this.zzess = new JSONObject(this.zzesn);
                return;
            }
            catch (JSONException jSONException) {
                this.zzess = null;
                this.zzesn = null;
                return;
            }
        }
        this.zzess = null;
    }

    private MediaQueueItem(MediaInfo mediaInfo) throws IllegalArgumentException {
        this(mediaInfo, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        if (mediaInfo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
    }

    MediaQueueItem(JSONObject jSONObject) throws JSONException {
        this(null, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        this.zzu(jSONObject);
    }

    @Hide
    private MediaQueueItem(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
        this(mediaQueueItem.getMedia(), mediaQueueItem.getItemId(), mediaQueueItem.getAutoplay(), mediaQueueItem.getStartTime(), mediaQueueItem.getPlaybackDuration(), mediaQueueItem.getPreloadTime(), mediaQueueItem.getActiveTrackIds(), null);
        if (this.zzewv == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzess = mediaQueueItem.getCustomData();
    }

    @Hide
    public final boolean zzu(JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzewv = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzeww != (n = jSONObject.getInt("itemId"))) {
            this.zzeww = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzewi != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzewi = n;
            bl = true;
        }
        if (jSONObject.has("startTime")) {
            double d;
            double d2 = jSONObject.getDouble("startTime");
            if (Math.abs(d - this.zzewx) > 1.0E-7) {
                this.zzewx = d2;
                bl = true;
            }
        }
        if (jSONObject.has("playbackDuration")) {
            double d;
            double d3 = jSONObject.getDouble("playbackDuration");
            if (Math.abs(d - this.zzewy) > 1.0E-7) {
                this.zzewy = d3;
                bl = true;
            }
        }
        if (jSONObject.has("preloadTime")) {
            double d;
            double d4 = jSONObject.getDouble("preloadTime");
            if (Math.abs(d - this.zzewz) > 1.0E-7) {
                this.zzewz = d4;
                bl = true;
            }
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzewl == null) {
                bl2 = true;
            } else if (this.zzewl.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzewl[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzewl = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzess = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zzewv;
    }

    public int getItemId() {
        return this.zzeww;
    }

    final void zzba(int n) {
        this.zzeww = 0;
    }

    public boolean getAutoplay() {
        return this.zzewi;
    }

    final void zzba(boolean bl) {
        this.zzewi = bl;
    }

    public double getStartTime() {
        return this.zzewx;
    }

    final void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzewx = d;
    }

    public double getPlaybackDuration() {
        return this.zzewy;
    }

    final void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.zzewy = d;
    }

    public double getPreloadTime() {
        return this.zzewz;
    }

    final void zze(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzewz = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzewl;
    }

    final void zza(long[] lArray) {
        this.zzewl = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzess;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzess = jSONObject;
    }

    final void zzadu() throws IllegalArgumentException {
        if (this.zzewv == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzewx) || this.zzewx < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzewy)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzewz) || this.zzewz < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    @Hide
    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzewv.toJson());
            if (this.zzeww != 0) {
                jSONObject.put("itemId", this.zzeww);
            }
            jSONObject.put("autoplay", this.zzewi);
            jSONObject.put("startTime", this.zzewx);
            if (this.zzewy != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzewy);
            }
            jSONObject.put("preloadTime", this.zzewz);
            if (this.zzewl != null) {
                JSONArray jSONArray = new JSONArray();
                long[] lArray = this.zzewl;
                int n = this.zzewl.length;
                for (int i = 0; i < n; ++i) {
                    long l = lArray[i];
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzess != null) {
                jSONObject.put("customData", (Object)this.zzess);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)((Object)object);
        if (this.zzess == null != (mediaQueueItem.zzess == null)) {
            return false;
        }
        if (this.zzess != null && mediaQueueItem.zzess != null && !zzq.zzc((Object)this.zzess, (Object)mediaQueueItem.zzess)) {
            return false;
        }
        return zzbdw.zza(this.zzewv, mediaQueueItem.zzewv) && this.zzeww == mediaQueueItem.zzeww && this.zzewi == mediaQueueItem.zzewi && this.zzewx == mediaQueueItem.zzewx && this.zzewy == mediaQueueItem.zzewy && this.zzewz == mediaQueueItem.zzewz && Arrays.equals(this.zzewl, mediaQueueItem.zzewl);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzewv, this.zzeww, this.zzewi, this.zzewx, this.zzewy, this.zzewz, Arrays.hashCode(this.zzewl), String.valueOf(this.zzess)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzesn = this.zzess == null ? null : this.zzess.toString();
        Parcel parcel2 = parcel;
        MediaQueueItem mediaQueueItem = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)mediaQueueItem.getMedia(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)3, (int)mediaQueueItem.getItemId());
        zzbgo.zza((Parcel)parcel2, (int)4, (boolean)mediaQueueItem.getAutoplay());
        zzbgo.zza((Parcel)parcel2, (int)5, (double)mediaQueueItem.getStartTime());
        zzbgo.zza((Parcel)parcel2, (int)6, (double)mediaQueueItem.getPlaybackDuration());
        zzbgo.zza((Parcel)parcel2, (int)7, (double)mediaQueueItem.getPreloadTime());
        zzbgo.zza((Parcel)parcel2, (int)8, (long[])mediaQueueItem.getActiveTrackIds(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (String)mediaQueueItem.zzesn, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ MediaQueueItem(MediaInfo mediaInfo, zzah zzah2) throws IllegalArgumentException {
        this(mediaInfo);
    }

    /* synthetic */ MediaQueueItem(MediaQueueItem mediaQueueItem, zzah zzah2) throws IllegalArgumentException {
        this(mediaQueueItem);
    }

    public static class Builder {
        private final MediaQueueItem zzexa;

        public Builder(MediaInfo mediaInfo) throws IllegalArgumentException {
            this.zzexa = new MediaQueueItem(mediaInfo, null);
        }

        public Builder(JSONObject jSONObject) throws JSONException {
            this.zzexa = new MediaQueueItem(jSONObject);
        }

        public Builder(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
            this.zzexa = new MediaQueueItem(mediaQueueItem, null);
        }

        public Builder clearItemId() {
            this.zzexa.zzba(0);
            return this;
        }

        public Builder setAutoplay(boolean bl) {
            this.zzexa.zzba(bl);
            return this;
        }

        public Builder setStartTime(double d) throws IllegalArgumentException {
            this.zzexa.zzc(d);
            return this;
        }

        public Builder setPlaybackDuration(double d) {
            this.zzexa.zzd(d);
            return this;
        }

        public Builder setPreloadTime(double d) throws IllegalArgumentException {
            this.zzexa.zze(d);
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.zzexa.zza(lArray);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzexa.setCustomData(jSONObject);
            return this;
        }

        public MediaQueueItem build() {
            this.zzexa.zzadu();
            return this.zzexa;
        }
    }
}

