/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbco;
import com.google.android.gms.internal.zzbcp;
import com.google.android.gms.internal.zzbcq;
import com.google.android.gms.internal.zzbcy;
import com.google.android.gms.internal.zzbcz;
import com.google.android.gms.internal.zzbda;
import com.google.android.gms.internal.zzbdb;
import com.google.android.gms.internal.zzbdc;
import com.google.android.gms.internal.zzbdg;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzben;
import com.google.android.gms.internal.zzbeo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbcl
extends zzbdg {
    private static String NAMESPACE = zzbdw.zzfw("com.google.cast.games");
    private static final zzbei zzeus = new zzbei("GameManagerChannel");
    private final Map<String, String> zzfkh = new ConcurrentHashMap<String, String>();
    private final List<zzbeo> zzfki;
    private final SharedPreferences zzbkx;
    private final String zzfkj;
    private final Cast.CastApi zzfam;
    private final GoogleApiClient zzffo;
    private zzbcy zzfkk;
    private boolean zzfkl = false;
    private GameManagerState zzfkm;
    private GameManagerState zzfkn;
    private String zzfko;
    private JSONObject zzfkp;
    private long zzfkq = 0L;
    private GameManagerClient.Listener zzfkr;
    private final zze zzata;
    private String zzfks;

    public zzbcl(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzata = zzi.zzanq();
        this.zzfki = new ArrayList<zzbeo>();
        this.zzfkj = string2;
        this.zzfam = castApi;
        this.zzffo = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzbkx = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.zzfkn = null;
        this.zzfkm = new zzbda(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        return this.zzffo.zze((zzm)new zzbcm(this, gameManagerClient));
    }

    public final synchronized void dispose() throws IllegalStateException {
        if (this.zzfkl) {
            return;
        }
        this.zzfkm = null;
        this.zzfkn = null;
        this.zzfko = null;
        this.zzfkp = null;
        this.zzfkl = true;
        try {
            this.zzfam.removeMessageReceivedCallbacks(this.zzffo, this.getNamespace());
            return;
        }
        catch (IOException iOException) {
            zzeus.zzf("Exception while detaching game manager channel.", iOException);
            return;
        }
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerResult> zza(String string2, int n, JSONObject jSONObject) throws IllegalStateException {
        this.zzagg();
        return this.zzffo.zze((zzm)new zzbco(this, n, string2, jSONObject));
    }

    public final synchronized void sendGameMessage(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzagg();
        long l = ++this.zzfkq;
        JSONObject jSONObject2 = this.zza(l, string2, 7, jSONObject);
        if (jSONObject2 == null) {
            return;
        }
        this.zzfam.sendMessage(this.zzffo, this.getNamespace(), jSONObject2.toString());
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzagg();
        return this.zzffo.zze((zzm)new zzbcp(this, string2, jSONObject));
    }

    public final synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zzagg();
        return this.zzfkm;
    }

    public final synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zzagg();
        return this.zzfks;
    }

    private final synchronized String zzft(String string2) throws IllegalStateException {
        if (string2 == null) {
            return null;
        }
        return this.zzfkh.get(string2);
    }

    public final synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzfkr = listener;
    }

    @Override
    public final void zzfu(String string2) {
        int n;
        zzbcz zzbcz2;
        zzeus.zzb("message received: %s", string2);
        try {
            zzbcz2 = zzbcz.zzw(new JSONObject(string2));
        }
        catch (JSONException jSONException) {
            zzeus.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzbcz2 == null) {
            zzeus.zzf("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.isInitialized() && zzbcz2.zzfkk == null || this.isDisposed()) {
            return;
        }
        boolean bl = zzbcz2.zzflj == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzbcz2.zzflq)) {
            this.zzfkh.put(zzbcz2.zzfld, zzbcz2.zzflq);
            this.zzagh();
        }
        if (zzbcz2.zzcc == 0) {
            this.zza(zzbcz2);
        } else {
            zzeus.zzf("Not updating from game message because the message contains error code: %d", zzbcz2.zzcc);
        }
        int n2 = zzbcz2.zzcc;
        switch (n2) {
            case 4: {
                int n3 = 2151;
                break;
            }
            case 3: {
                int n3 = 2150;
                break;
            }
            case 2: {
                int n3 = 2003;
                break;
            }
            case 1: {
                int n3 = 2001;
                break;
            }
            case 0: {
                int n3 = 0;
                break;
            }
            default: {
                zzeus.zzf(new StringBuilder(53).append("Unknown GameManager protocol status code: ").append(n2).toString(), new Object[0]);
                int n3 = n = 13;
            }
        }
        if (bl) {
            this.zzb(zzbcz2.zzfle, n, zzbcz2);
        }
        if (this.isInitialized() && n == 0) {
            zzbcl zzbcl2 = this;
            if (zzbcl2.zzfkr != null) {
                if (zzbcl2.zzfkn != null && !zzbcl2.zzfkm.equals(zzbcl2.zzfkn)) {
                    zzbcl2.zzfkr.onStateChanged(zzbcl2.zzfkm, zzbcl2.zzfkn);
                }
                if (zzbcl2.zzfkp != null && zzbcl2.zzfko != null) {
                    zzbcl2.zzfkr.onGameMessageReceived(zzbcl2.zzfko, zzbcl2.zzfkp);
                }
            }
            zzbcl2.zzfkn = null;
            zzbcl2.zzfko = null;
            zzbcl2.zzfkp = null;
        }
    }

    public final synchronized boolean isDisposed() {
        return this.zzfkl;
    }

    private final synchronized boolean isInitialized() {
        return this.zzfkk != null;
    }

    @Override
    public final void zzc(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zzz(long l) {
        Iterator<zzbeo> iterator = this.zzfki.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzbeo.zzakj;
        synchronized (object) {
            Iterator<zzbeo> iterator2 = this.zzfki.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().zzaha()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private final synchronized void zzagg() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private final void zza(String string2, int n, JSONObject jSONObject, zzben zzben2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzfkq, string2, n, jSONObject)) == null) {
            zzben2.zza(-1L, 2001, null);
            zzeus.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzbeo zzbeo2 = new zzbeo(this.zzata, 30000L);
        zzbeo2.zza(l, zzben2);
        this.zzfki.add(zzbeo2);
        this.zzbg(true);
        this.zzfam.sendMessage(this.zzffo, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new zzbcq(this, l));
    }

    private final JSONObject zza(long l, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzft(string2));
        }
        catch (JSONException jSONException) {
            zzeus.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private final synchronized void zza(zzbcz zzbcz2) {
        boolean bl = zzbcz2.zzflj == 1;
        this.zzfkn = this.zzfkm;
        if (bl && zzbcz2.zzfkk != null) {
            this.zzfkk = zzbcz2.zzfkk;
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzbdc zzbdc2 : zzbcz2.zzfln) {
            String string2 = zzbdc2.getPlayerId();
            zzbdb zzbdb2 = new zzbdb(string2, zzbdc2.getPlayerState(), zzbdc2.getPlayerData(), this.zzfkh.containsKey(string2));
            arrayList.add(zzbdb2);
        }
        this.zzfkm = new zzbda(zzbcz2.zzflm, zzbcz2.zzfll, zzbcz2.zzflp, zzbcz2.zzflo, arrayList, this.zzfkk.zzagk(), this.zzfkk.getMaxPlayers());
        PlayerInfo playerInfo = this.zzfkm.getPlayer(zzbcz2.zzfld);
        if (playerInfo != null && playerInfo.isControllable() && zzbcz2.zzflj == 2) {
            this.zzfko = zzbcz2.zzfld;
            this.zzfkp = zzbcz2.zzflf;
        }
    }

    private final void zzb(long l, int n, Object object) {
        Iterator<zzbeo> iterator = this.zzfki.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private final synchronized void zzagh() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzfkj);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzfkh));
            this.zzbkx.edit().putString("save_data", jSONObject.toString()).commit();
            return;
        }
        catch (JSONException jSONException) {
            zzeus.zzf("Error while saving data: %s", jSONException.getMessage());
            return;
        }
    }

    private final synchronized void zzagi() {
        String string2 = this.zzbkx.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.zzfkj.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.zzfkh.put(string4, jSONObject2.getString(string4));
                }
                this.zzfkq = 0L;
            }
            return;
        }
        catch (JSONException jSONException) {
            zzeus.zzf("Error while loading data: %s", jSONException.getMessage());
            return;
        }
    }

    static /* synthetic */ GoogleApiClient zza(zzbcl zzbcl2) {
        return zzbcl2.zzffo;
    }

    static /* synthetic */ Cast.CastApi zzb(zzbcl zzbcl2) {
        return zzbcl2.zzfam;
    }

    static /* synthetic */ void zzc(zzbcl zzbcl2) {
        zzbcl2.zzagi();
    }

    static /* synthetic */ void zzd(zzbcl zzbcl2) {
        zzbcl2.zzagh();
    }

    static /* synthetic */ void zza(zzbcl zzbcl2, String string2, int n, JSONObject jSONObject, zzben zzben2) {
        zzbcl2.zza(string2, n, jSONObject, zzben2);
    }

    static /* synthetic */ zzbei zzagj() {
        return zzeus;
    }

    static /* synthetic */ zzbcy zza(zzbcl zzbcl2, zzbcy zzbcy2) {
        zzbcl2.zzfkk = null;
        return null;
    }

    static /* synthetic */ String zza(zzbcl zzbcl2, String string2) {
        zzbcl2.zzfks = string2;
        return zzbcl2.zzfks;
    }
}

