/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzbdw;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public final class zzbda
implements GameManagerState {
    private final int zzflm;
    private final int zzfll;
    private final String zzflp;
    private final JSONObject zzflo;
    private final String zzflg;
    private final int zzflh;
    private final Map<String, PlayerInfo> zzflr;

    public zzbda(int n, int n2, String string2, JSONObject jSONObject, Collection<PlayerInfo> collection, String string3, int n3) {
        this.zzflm = n;
        this.zzfll = n2;
        this.zzflp = string2;
        this.zzflo = jSONObject;
        this.zzflg = string3;
        this.zzflh = n3;
        this.zzflr = new HashMap<String, PlayerInfo>(collection.size());
        for (PlayerInfo playerInfo : collection) {
            this.zzflr.put(playerInfo.getPlayerId(), playerInfo);
        }
    }

    @Override
    public final int getLobbyState() {
        return this.zzflm;
    }

    @Override
    public final int getGameplayState() {
        return this.zzfll;
    }

    @Override
    public final JSONObject getGameData() {
        return this.zzflo;
    }

    @Override
    public final CharSequence getGameStatusText() {
        return this.zzflp;
    }

    @Override
    public final CharSequence getApplicationName() {
        return this.zzflg;
    }

    @Override
    public final int getMaxPlayers() {
        return this.zzflh;
    }

    @Override
    public final List<PlayerInfo> getPlayersInState(int n) {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (playerInfo.getPlayerState() != n) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public final PlayerInfo getPlayer(String string2) {
        if (string2 == null) {
            return null;
        }
        return this.zzflr.get(string2);
    }

    @Override
    public final Collection<PlayerInfo> getPlayers() {
        return Collections.unmodifiableCollection(this.zzflr.values());
    }

    @Override
    public final List<PlayerInfo> getControllablePlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isControllable()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public final List<PlayerInfo> getConnectedPlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isConnected()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public final List<PlayerInfo> getConnectedControllablePlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isConnected() || !playerInfo.isControllable()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public final boolean hasLobbyStateChanged(GameManagerState gameManagerState) {
        return this.zzflm != gameManagerState.getLobbyState();
    }

    @Override
    public final boolean hasGameplayStateChanged(GameManagerState gameManagerState) {
        return this.zzfll != gameManagerState.getGameplayState();
    }

    @Override
    public final boolean hasGameDataChanged(GameManagerState gameManagerState) {
        return !zzq.zzc((Object)this.zzflo, (Object)gameManagerState.getGameData());
    }

    @Override
    public final boolean hasGameStatusTextChanged(GameManagerState gameManagerState) {
        return !zzbdw.zza(this.zzflp, gameManagerState.getGameStatusText());
    }

    @Override
    public final boolean hasPlayerChanged(String string2, GameManagerState gameManagerState) {
        return !zzbdw.zza(this.getPlayer(string2), gameManagerState.getPlayer(string2));
    }

    @Override
    public final boolean hasPlayerStateChanged(String string2, GameManagerState gameManagerState) {
        PlayerInfo playerInfo = this.getPlayer(string2);
        PlayerInfo playerInfo2 = gameManagerState.getPlayer(string2);
        if (playerInfo == null && playerInfo2 == null) {
            return false;
        }
        if (playerInfo != null && playerInfo2 != null) {
            return playerInfo.getPlayerState() != playerInfo2.getPlayerState();
        }
        return true;
    }

    @Override
    public final boolean hasPlayerDataChanged(String string2, GameManagerState gameManagerState) {
        PlayerInfo playerInfo = this.getPlayer(string2);
        PlayerInfo playerInfo2 = gameManagerState.getPlayer(string2);
        if (playerInfo == null && playerInfo2 == null) {
            return false;
        }
        if (playerInfo != null && playerInfo2 != null) {
            return !zzq.zzc((Object)playerInfo.getPlayerData(), (Object)playerInfo2.getPlayerData());
        }
        return true;
    }

    @Override
    public final Collection<String> getListOfChangedPlayers(GameManagerState gameManagerState) {
        HashSet<String> hashSet = new HashSet<String>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            PlayerInfo playerInfo2 = gameManagerState.getPlayer(playerInfo.getPlayerId());
            if (playerInfo2 != null && playerInfo.equals(playerInfo2)) continue;
            hashSet.add(playerInfo.getPlayerId());
        }
        for (PlayerInfo playerInfo : gameManagerState.getPlayers()) {
            if (this.getPlayer(playerInfo.getPlayerId()) != null) continue;
            hashSet.add(playerInfo.getPlayerId());
        }
        return hashSet;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof GameManagerState)) {
            return false;
        }
        GameManagerState gameManagerState = (GameManagerState)object;
        if (this.getPlayers().size() != gameManagerState.getPlayers().size()) {
            return false;
        }
        for (PlayerInfo playerInfo : this.getPlayers()) {
            boolean bl = false;
            for (PlayerInfo playerInfo2 : gameManagerState.getPlayers()) {
                if (!zzbdw.zza(playerInfo.getPlayerId(), playerInfo2.getPlayerId())) continue;
                if (!zzbdw.zza(playerInfo, playerInfo2)) {
                    return false;
                }
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return this.zzflm == gameManagerState.getLobbyState() && this.zzfll == gameManagerState.getGameplayState() && this.zzflh == gameManagerState.getMaxPlayers() && zzbdw.zza(this.zzflg, gameManagerState.getApplicationName()) && zzbdw.zza(this.zzflp, gameManagerState.getGameStatusText()) && zzq.zzc((Object)this.zzflo, (Object)gameManagerState.getGameData());
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzflm, this.zzfll, this.zzflr, this.zzflp, this.zzflo, this.zzflg, this.zzflh});
    }
}

