/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzjr;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzjy;
import com.google.android.gms.internal.zzkb;
import java.io.IOException;

public final class Cast {
    public static final int MAX_MESSAGE_LENGTH = 65536;
    public static final int MAX_NAMESPACE_LENGTH = 128;
    public static final String EXTRA_APP_NO_LONGER_RUNNING = "com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING";
    private static final Api.zzb<zzju, CastOptions> zzGS = new Api.zzb<zzju, CastOptions>(){

        public zzju zza(Context context, Looper looper, zzf zzf2, CastOptions castOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            zzx.zzb((Object)castOptions, (Object)"Setting the API options is required.");
            return new zzju(context, looper, castOptions.zzIx, castOptions.zzIz, castOptions.zzIy, connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    };
    public static final Api<CastOptions> API = new Api(zzGS, zzkb.zzGR, new Scope[0]);
    public static final CastApi CastApi = new CastApi.zza();

    private Cast() {
    }

    public static interface CastApi {
        public void requestStatus(GoogleApiClient var1) throws IOException, IllegalStateException;

        public PendingResult<Status> sendMessage(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2);

        @Deprecated
        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, boolean var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, LaunchOptions var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1);

        public PendingResult<Status> leaveApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1, String var2);

        public void setVolume(GoogleApiClient var1, double var2) throws IOException, IllegalArgumentException, IllegalStateException;

        public double getVolume(GoogleApiClient var1) throws IllegalStateException;

        public void setMute(GoogleApiClient var1, boolean var2) throws IOException, IllegalStateException;

        public boolean isMute(GoogleApiClient var1) throws IllegalStateException;

        public ApplicationMetadata getApplicationMetadata(GoogleApiClient var1) throws IllegalStateException;

        public String getApplicationStatus(GoogleApiClient var1) throws IllegalStateException;

        public void setMessageReceivedCallbacks(GoogleApiClient var1, String var2, MessageReceivedCallback var3) throws IOException, IllegalStateException;

        public void removeMessageReceivedCallbacks(GoogleApiClient var1, String var2) throws IOException, IllegalArgumentException;

        public static final class zza
        implements CastApi {
            @Override
            public void requestStatus(GoogleApiClient client) throws IOException, IllegalStateException {
                try {
                    ((zzju)client.zza(zzkb.zzGR)).zzhr();
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public PendingResult<Status> sendMessage(GoogleApiClient client, final String namespace, final String message) {
                return client.zzb((zza.zza)new zzjy(client){

                    protected void zza(zzju zzju2) throws RemoteException {
                        try {
                            zzju2.zza(namespace, message, (zza.zzb<Status>)this);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.zzah(2001);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzah(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, final String applicationId) {
                return client.zzb((zza.zza)new com.google.android.gms.cast.Cast$zza(client){

                    protected void zza(zzju zzju2) throws RemoteException {
                        try {
                            zzju2.zza(applicationId, false, (zza.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzah(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, final String applicationId, final LaunchOptions options) {
                return client.zzb((zza.zza)new com.google.android.gms.cast.Cast$zza(client){

                    protected void zza(zzju zzju2) throws RemoteException {
                        try {
                            zzju2.zza(applicationId, options, (zza.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzah(2001);
                        }
                    }
                });
            }

            @Override
            @Deprecated
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, String applicationId, boolean relaunchIfRunning) {
                LaunchOptions launchOptions = new LaunchOptions.Builder().setRelaunchIfRunning(relaunchIfRunning).build();
                return this.launchApplication(client, applicationId, launchOptions);
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client, final String applicationId, final String sessionId) {
                return client.zzb((zza.zza)new com.google.android.gms.cast.Cast$zza(client){

                    protected void zza(zzju zzju2) throws RemoteException {
                        try {
                            zzju2.zzb(applicationId, sessionId, (zza.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzah(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client, final String applicationId) {
                return client.zzb((zza.zza)new com.google.android.gms.cast.Cast$zza(client){

                    protected void zza(zzju zzju2) throws RemoteException {
                        try {
                            zzju2.zzb(applicationId, null, (zza.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzah(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client) {
                return client.zzb((zza.zza)new com.google.android.gms.cast.Cast$zza(client){

                    protected void zza(zzju zzju2) throws RemoteException {
                        try {
                            zzju2.zzb(null, null, (zza.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzah(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> leaveApplication(GoogleApiClient client) {
                return client.zzb((zza.zza)new zzjy(client){

                    protected void zza(zzju zzju2) throws RemoteException {
                        try {
                            zzju2.zzd((zza.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzah(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient client) {
                return client.zzb((zza.zza)new zzjy(client){

                    protected void zza(zzju zzju2) throws RemoteException {
                        try {
                            zzju2.zza("", (zza.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzah(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient client, final String sessionId) {
                return client.zzb((zza.zza)new zzjy(client){

                    protected void zza(zzju zzju2) throws RemoteException {
                        if (TextUtils.isEmpty((CharSequence)sessionId)) {
                            this.zzd(2001, "IllegalArgument: sessionId cannot be null or empty");
                            return;
                        }
                        try {
                            zzju2.zza(sessionId, (zza.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzah(2001);
                        }
                    }
                });
            }

            @Override
            public void setVolume(GoogleApiClient client, double volume) throws IOException, IllegalArgumentException, IllegalStateException {
                try {
                    ((zzju)client.zza(zzkb.zzGR)).zza(volume);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public double getVolume(GoogleApiClient client) throws IllegalStateException {
                return ((zzju)client.zza(zzkb.zzGR)).zzhs();
            }

            @Override
            public void setMute(GoogleApiClient client, boolean mute) throws IOException, IllegalStateException {
                try {
                    ((zzju)client.zza(zzkb.zzGR)).zzL(mute);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public boolean isMute(GoogleApiClient client) throws IllegalStateException {
                return ((zzju)client.zza(zzkb.zzGR)).isMute();
            }

            @Override
            public ApplicationMetadata getApplicationMetadata(GoogleApiClient client) throws IllegalStateException {
                return ((zzju)client.zza(zzkb.zzGR)).getApplicationMetadata();
            }

            @Override
            public String getApplicationStatus(GoogleApiClient client) throws IllegalStateException {
                return ((zzju)client.zza(zzkb.zzGR)).getApplicationStatus();
            }

            @Override
            public void setMessageReceivedCallbacks(GoogleApiClient client, String namespace, MessageReceivedCallback callbacks) throws IOException, IllegalStateException {
                try {
                    ((zzju)client.zza(zzkb.zzGR)).zza(namespace, callbacks);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public void removeMessageReceivedCallbacks(GoogleApiClient client, String namespace) throws IOException, IllegalArgumentException {
                try {
                    ((zzju)client.zza(zzkb.zzGR)).zzaJ(namespace);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }
        }
    }

    private static abstract class zza
    extends zzjr<ApplicationConnectionResult> {
        public zza(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public ApplicationConnectionResult zzh(final Status status) {
            return new ApplicationConnectionResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public boolean getWasLaunched() {
                    return false;
                }

                @Override
                public String getSessionId() {
                    return null;
                }

                @Override
                public String getApplicationStatus() {
                    return null;
                }

                @Override
                public ApplicationMetadata getApplicationMetadata() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzh(x0);
        }
    }

    public static interface ApplicationConnectionResult
    extends Result {
        public ApplicationMetadata getApplicationMetadata();

        public String getApplicationStatus();

        public String getSessionId();

        public boolean getWasLaunched();
    }

    public static final class CastOptions
    implements Api.ApiOptions.HasOptions {
        final CastDevice zzIx;
        final Listener zzIy;
        private final int zzIz;

        private CastOptions(Builder builder) {
            this.zzIx = builder.zzIA;
            this.zzIy = builder.zzIB;
            this.zzIz = builder.zzIC;
        }

        public static Builder builder(CastDevice castDevice, Listener castListener) {
            return new Builder(castDevice, castListener);
        }

        public static final class Builder {
            CastDevice zzIA;
            Listener zzIB;
            private int zzIC;

            private Builder(CastDevice castDevice, Listener castListener) {
                zzx.zzb((Object)castDevice, (Object)"CastDevice parameter cannot be null");
                zzx.zzb((Object)castListener, (Object)"CastListener parameter cannot be null");
                this.zzIA = castDevice;
                this.zzIB = castListener;
                this.zzIC = 0;
            }

            public Builder setVerboseLoggingEnabled(boolean enabled) {
                this.zzIC = enabled ? (this.zzIC |= 1) : (this.zzIC &= 0xFFFFFFFE);
                return this;
            }

            public CastOptions build() {
                return new CastOptions(this);
            }
        }
    }

    public static interface MessageReceivedCallback {
        public void onMessageReceived(CastDevice var1, String var2, String var3);
    }

    public static class Listener {
        public void onApplicationStatusChanged() {
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
        }

        public void onApplicationDisconnected(int statusCode) {
        }

        public void zzab(int n) {
        }

        public void zzac(int n) {
        }

        public void onVolumeChanged() {
        }
    }
}

