/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzjv;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
implements SafeParcelable {
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzb();
    private final int zzFG;
    private String zzIE;
    String zzIF;
    private Inet4Address zzIG;
    private String zzIH;
    private String zzII;
    private String zzIJ;
    private int zzIK;
    private List<WebImage> zzIL;
    private int zzIM;
    private int zzrX;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons, int capabilities, int status) {
        this.zzFG = versionCode;
        this.zzIE = deviceId;
        this.zzIF = hostAddress;
        if (this.zzIF != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzIF);
                if (inetAddress instanceof Inet4Address) {
                    this.zzIG = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.zzIG = null;
            }
        }
        this.zzIH = friendlyName;
        this.zzII = modelName;
        this.zzIJ = deviceVersion;
        this.zzIK = servicePort;
        this.zzIL = icons;
        this.zzIM = capabilities;
        this.zzrX = status;
    }

    private CastDevice() {
        this(3, null, null, null, null, null, -1, new ArrayList<WebImage>(), 0, -1);
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public String getDeviceId() {
        return this.zzIE;
    }

    public Inet4Address getIpAddress() {
        return this.zzIG;
    }

    public String getFriendlyName() {
        return this.zzIH;
    }

    public String getModelName() {
        return this.zzII;
    }

    public String getDeviceVersion() {
        return this.zzIJ;
    }

    public int getServicePort() {
        return this.zzIK;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzIL);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.zzIL.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.zzIL.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzIL) {
            int n = webImage3.getWidth();
            int n2 = webImage3.getHeight();
            if (n >= preferredWidth && n2 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n || webImage.getHeight() <= n2)) continue;
                webImage = webImage3;
                continue;
            }
            if (n >= preferredWidth || n2 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n || webImage2.getHeight() >= n2)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = null;
        webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzIL.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzIL.isEmpty();
    }

    public int getCapabilities() {
        return this.zzIM;
    }

    public int getStatus() {
        return this.zzrX;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzIH, this.zzIE);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzb.zza(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return zzjv.zza(this.zzIE, castDevice.zzIE) && zzjv.zza(this.zzIG, castDevice.zzIG) && zzjv.zza(this.zzII, castDevice.zzII) && zzjv.zza(this.zzIH, castDevice.zzIH) && zzjv.zza(this.zzIJ, castDevice.zzIJ) && this.zzIK == castDevice.zzIK && zzjv.zza(this.zzIL, castDevice.zzIL) && this.zzIM == castDevice.zzIM && this.zzrX == castDevice.zzrX;
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return zzjv.zza(this.getDeviceId(), castDevice.getDeviceId());
    }

    public int hashCode() {
        return this.zzIE == null ? 0 : this.zzIE.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzIE.startsWith("__cast_nearby__");
    }
}

