/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzma;
import com.google.android.gms.internal.zzme;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    private float zzJP;
    private int zzJQ;
    private int zzAz;
    private int zzJR;
    private int zzJS;
    private int zzJT;
    private int zzJU;
    private int zzJV;
    private String zzJW;
    private int zzJX;
    private int zzJY;
    private JSONObject zzIX;

    public TextTrackStyle() {
        this.clear();
    }

    public void setFontScale(float fontScale) {
        this.zzJP = fontScale;
    }

    public float getFontScale() {
        return this.zzJP;
    }

    public void setForegroundColor(int foregroundColor) {
        this.zzJQ = foregroundColor;
    }

    public int getForegroundColor() {
        return this.zzJQ;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.zzAz = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.zzAz;
    }

    public void setEdgeType(int edgeType) {
        if (edgeType < 0 || edgeType > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzJR = edgeType;
    }

    public int getEdgeType() {
        return this.zzJR;
    }

    public void setEdgeColor(int edgeColor) {
        this.zzJS = edgeColor;
    }

    public int getEdgeColor() {
        return this.zzJS;
    }

    public void setWindowType(int windowType) {
        if (windowType < 0 || windowType > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzJT = windowType;
    }

    public int getWindowType() {
        return this.zzJT;
    }

    public void setWindowColor(int windowColor) {
        this.zzJU = windowColor;
    }

    public int getWindowColor() {
        return this.zzJU;
    }

    public void setWindowCornerRadius(int windowCornerRadius) {
        if (windowCornerRadius < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzJV = windowCornerRadius;
    }

    public int getWindowCornerRadius() {
        return this.zzJV;
    }

    public void setFontFamily(String fontFamily) {
        this.zzJW = fontFamily;
    }

    public String getFontFamily() {
        return this.zzJW;
    }

    public void setFontGenericFamily(int fontGenericFamily) {
        if (fontGenericFamily < 0 || fontGenericFamily > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzJX = fontGenericFamily;
    }

    public int getFontGenericFamily() {
        return this.zzJX;
    }

    public void setFontStyle(int fontStyle) {
        if (fontStyle < 0 || fontStyle > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzJY = fontStyle;
    }

    public int getFontStyle() {
        return this.zzJY;
    }

    public void setCustomData(JSONObject customData) {
        this.zzIX = customData;
    }

    public JSONObject getCustomData() {
        return this.zzIX;
    }

    private void clear() {
        this.zzJP = 1.0f;
        this.zzJQ = 0;
        this.zzAz = 0;
        this.zzJR = -1;
        this.zzJS = 0;
        this.zzJT = -1;
        this.zzJU = 0;
        this.zzJV = 0;
        this.zzJW = null;
        this.zzJX = -1;
        this.zzJY = -1;
        this.zzIX = null;
    }

    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzme.zzkj()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void zzd(JSONObject jSONObject) throws JSONException {
        String string;
        this.clear();
        this.zzJP = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzJQ = this.zzaH(jSONObject.optString("foregroundColor"));
        this.zzAz = this.zzaH(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string = jSONObject.getString("edgeType");
            if ("NONE".equals(string)) {
                this.zzJR = 0;
            } else if ("OUTLINE".equals(string)) {
                this.zzJR = 1;
            } else if ("DROP_SHADOW".equals(string)) {
                this.zzJR = 2;
            } else if ("RAISED".equals(string)) {
                this.zzJR = 3;
            } else if ("DEPRESSED".equals(string)) {
                this.zzJR = 4;
            }
        }
        this.zzJS = this.zzaH(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string = jSONObject.getString("windowType");
            if ("NONE".equals(string)) {
                this.zzJT = 0;
            } else if ("NORMAL".equals(string)) {
                this.zzJT = 1;
            } else if ("ROUNDED_CORNERS".equals(string)) {
                this.zzJT = 2;
            }
        }
        this.zzJU = this.zzaH(jSONObject.optString("windowColor"));
        if (this.zzJT == 2) {
            this.zzJV = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzJW = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string)) {
                this.zzJX = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string)) {
                this.zzJX = 1;
            } else if ("SERIF".equals(string)) {
                this.zzJX = 2;
            } else if ("MONOSPACED_SERIF".equals(string)) {
                this.zzJX = 3;
            } else if ("CASUAL".equals(string)) {
                this.zzJX = 4;
            } else if ("CURSIVE".equals(string)) {
                this.zzJX = 5;
            } else if ("SMALL_CAPITALS".equals(string)) {
                this.zzJX = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string)) {
                this.zzJY = 0;
            } else if ("BOLD".equals(string)) {
                this.zzJY = 1;
            } else if ("ITALIC".equals(string)) {
                this.zzJY = 2;
            } else if ("BOLD_ITALIC".equals(string)) {
                this.zzJY = 3;
            }
        }
        this.zzIX = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzJP);
            if (this.zzJQ != 0) {
                jSONObject.put("foregroundColor", (Object)this.zzy(this.zzJQ));
            }
            if (this.zzAz != 0) {
                jSONObject.put("backgroundColor", (Object)this.zzy(this.zzAz));
            }
            switch (this.zzJR) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
            }
            if (this.zzJS != 0) {
                jSONObject.put("edgeColor", (Object)this.zzy(this.zzJS));
            }
            switch (this.zzJT) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
            }
            if (this.zzJU != 0) {
                jSONObject.put("windowColor", (Object)this.zzy(this.zzJU));
            }
            if (this.zzJT == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzJV);
            }
            if (this.zzJW != null) {
                jSONObject.put("fontFamily", (Object)this.zzJW);
            }
            switch (this.zzJX) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
            }
            switch (this.zzJY) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
            }
            if (this.zzIX != null) {
                jSONObject.put("customData", (Object)this.zzIX);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String zzy(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private int zzaH(String string) {
        if (string != null && string.length() == 9 && string.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string.substring(1, 3), 16);
                int n2 = Integer.parseInt(string.substring(3, 5), 16);
                int n3 = Integer.parseInt(string.substring(5, 7), 16);
                int n4 = Integer.parseInt(string.substring(7, 9), 16);
                return Color.argb((int)n4, (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)other;
        if (this.zzIX == null != (textTrackStyle.zzIX == null)) {
            return false;
        }
        if (this.zzIX != null && textTrackStyle.zzIX != null && !zzma.zzd((Object)this.zzIX, (Object)textTrackStyle.zzIX)) {
            return false;
        }
        return this.zzJP == textTrackStyle.zzJP && this.zzJQ == textTrackStyle.zzJQ && this.zzAz == textTrackStyle.zzAz && this.zzJR == textTrackStyle.zzJR && this.zzJS == textTrackStyle.zzJS && this.zzJT == textTrackStyle.zzJT && this.zzJV == textTrackStyle.zzJV && zzjv.zza(this.zzJW, textTrackStyle.zzJW) && this.zzJX == textTrackStyle.zzJX && this.zzJY == textTrackStyle.zzJY;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{Float.valueOf(this.zzJP), this.zzJQ, this.zzAz, this.zzJR, this.zzJS, this.zzJT, this.zzJU, this.zzJV, this.zzJW, this.zzJX, this.zzJY, this.zzIX});
    }
}

