/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.SystemClock;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.internal.zzjs;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzkg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzkd
extends zzjs {
    private static final String NAMESPACE = zzjv.zzaL("com.google.cast.media");
    private long zzKV;
    private MediaStatus zzKW;
    private final List<zzkg> zzKX;
    private final zzkg zzKY = new zzkg(86400000L);
    private final zzkg zzKZ = new zzkg(86400000L);
    private final zzkg zzLa = new zzkg(86400000L);
    private final zzkg zzLb = new zzkg(86400000L);
    private final zzkg zzLc = new zzkg(86400000L);
    private final zzkg zzLd = new zzkg(86400000L);
    private final zzkg zzLe = new zzkg(86400000L);
    private final zzkg zzLf = new zzkg(86400000L);
    private final zzkg zzLg = new zzkg(86400000L);
    private final zzkg zzLh = new zzkg(86400000L);

    public zzkd(String string) {
        super(NAMESPACE, "MediaControlChannel", string, 1000L);
        this.zzKX = new ArrayList<zzkg>();
        this.zzKX.add(this.zzKY);
        this.zzKX.add(this.zzKZ);
        this.zzKX.add(this.zzLa);
        this.zzKX.add(this.zzLb);
        this.zzKX.add(this.zzLc);
        this.zzKX.add(this.zzLd);
        this.zzKX.add(this.zzLe);
        this.zzKX.add(this.zzLf);
        this.zzKX.add(this.zzLg);
        this.zzKX.add(this.zzLh);
    }

    public long zza(zzkf zzkf2, MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzhn();
        this.zzKY.zza(l2, zzkf2);
        this.zzK(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.toJson());
            jSONObject2.put("autoplay", bl);
            jSONObject2.put("currentTime", zzjv.zzp(l));
            if (lArray != null) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzkf zzkf2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzhn();
        this.zzKZ.zza(l, zzkf2);
        this.zzK(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzhj());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzb(zzkf zzkf2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzhn();
        this.zzLb.zza(l, zzkf2);
        this.zzK(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzhj());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzc(zzkf zzkf2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzhn();
        this.zzLa.zza(l, zzkf2);
        this.zzK(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzhj());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzkf zzkf2, long l, int n, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzhn();
        this.zzLc.zza(l2, zzkf2);
        this.zzK(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zzhj());
            jSONObject2.put("currentTime", zzjv.zzp(l));
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzkf zzkf2, double d, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzhn();
        this.zzLd.zza(l, zzkf2);
        this.zzK(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzhj());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzkf zzkf2, boolean bl, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzhn();
        this.zzLe.zza(l, zzkf2);
        this.zzK(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzhj());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzkf zzkf2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzhn();
        this.zzLf.zza(l, zzkf2);
        this.zzK(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzKW != null) {
                jSONObject.put("mediaSessionId", this.zzKW.zzhj());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzkf zzkf2, long[] lArray) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzhn();
        this.zzLg.zza(l, zzkf2);
        this.zzK(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzhj());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzkf zzkf2, TextTrackStyle textTrackStyle) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzhn();
        this.zzLh.zza(l, zzkf2);
        this.zzK(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zzhj());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zzKV == 0L) {
            return 0L;
        }
        double d = this.zzKW.getPlaybackRate();
        long l = this.zzKW.getStreamPosition();
        int n = this.zzKW.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        long l2 = SystemClock.elapsedRealtime() - this.zzKV;
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l2 == 0L) {
            return l;
        }
        long l3 = mediaInfo.getStreamDuration();
        long l4 = l + (long)((double)l2 * d);
        if (l3 > 0L && l4 > l3) {
            l4 = l3;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.zzKW;
    }

    public MediaInfo getMediaInfo() {
        return this.zzKW == null ? null : this.zzKW.getMediaInfo();
    }

    @Override
    public final void zzaI(String string) {
        this.zzKe.zzb("message received: %s", string);
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            if (string2.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.zza(l, jSONArray.getJSONObject(0));
                } else {
                    this.zzKW = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.zzLf.zzc(l, 0);
                }
            } else if (string2.equals("INVALID_PLAYER_STATE")) {
                this.zzKe.zzd("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                for (zzkg zzkg2 : this.zzKX) {
                    zzkg2.zzb(l, 2100, jSONObject2);
                }
            } else if (string2.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.zzKY.zzb(l, 2100, jSONObject3);
            } else if (string2.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.zzKY.zzb(l, 2101, jSONObject4);
            } else if (string2.equals("INVALID_REQUEST")) {
                this.zzKe.zzd("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                for (zzkg zzkg3 : this.zzKX) {
                    zzkg3.zzb(l, 2100, jSONObject5);
                }
            }
        }
        catch (JSONException jSONException) {
            this.zzKe.zzd("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string);
        }
    }

    private void zza(long l, JSONObject jSONObject) throws JSONException {
        boolean bl = this.zzKY.zzq(l);
        boolean bl2 = this.zzLc.zzhI() && !this.zzLc.zzq(l);
        boolean bl3 = this.zzLd.zzhI() && !this.zzLd.zzq(l) || this.zzLe.zzhI() && !this.zzLe.zzq(l);
        int n = 0;
        if (bl2) {
            n |= 2;
        }
        if (bl3) {
            n |= 1;
        }
        int n2 = 0;
        if (bl || this.zzKW == null) {
            this.zzKW = new MediaStatus(jSONObject);
            this.zzKV = SystemClock.elapsedRealtime();
            n2 = 7;
        } else {
            n2 = this.zzKW.zza(jSONObject, n);
        }
        if ((n2 & 1) != 0) {
            this.zzKV = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n2 & 2) != 0) {
            this.zzKV = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n2 & 4) != 0) {
            this.onMetadataUpdated();
        }
        for (zzkg zzkg2 : this.zzKX) {
            zzkg2.zzc(l, 0);
        }
    }

    public long zzhj() throws IllegalStateException {
        if (this.zzKW == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.zzKW.zzhj();
    }

    protected void onStatusUpdated() {
    }

    protected void onMetadataUpdated() {
    }

    @Override
    public void zzb(long l, int n) {
        for (zzkg zzkg2 : this.zzKX) {
            zzkg2.zzc(l, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzo(long l) {
        for (zzkg object2 : this.zzKX) {
            object2.zzd(l, 2102);
        }
        boolean bl = false;
        Object object = zzkg.zzLm;
        synchronized (object) {
            for (zzkg zzkg2 : this.zzKX) {
                if (!zzkg2.zzhI()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

