/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzhz;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    private final String zzMh;
    private int zzMi;
    private String zzMj;
    private MediaMetadata zzMk;
    private long zzMl;
    private List<MediaTrack> zzMm;
    private TextTrackStyle zzMn;
    private JSONObject zzMo;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.zzMh = contentId;
        this.zzMi = -1;
        this.zzMl = -1L;
    }

    MediaInfo(JSONObject json) throws JSONException {
        double d;
        int n;
        JSONObject jSONObject;
        this.zzMh = json.getString("contentId");
        String string = json.getString("streamType");
        this.zzMi = "NONE".equals(string) ? 0 : ("BUFFERED".equals(string) ? 1 : ("LIVE".equals(string) ? 2 : -1));
        this.zzMj = json.getString("contentType");
        if (json.has("metadata")) {
            jSONObject = json.getJSONObject("metadata");
            n = jSONObject.getInt("metadataType");
            this.zzMk = new MediaMetadata(n);
            this.zzMk.zzf(jSONObject);
        }
        this.zzMl = -1L;
        if (json.has("duration") && !json.isNull("duration") && !Double.isNaN(d = json.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzMl = zzf.zzc(d);
        }
        if (json.has("tracks")) {
            this.zzMm = new ArrayList<MediaTrack>();
            jSONObject = json.getJSONArray("tracks");
            for (n = 0; n < jSONObject.length(); ++n) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject2);
                this.zzMm.add(mediaTrack);
            }
        } else {
            this.zzMm = null;
        }
        if (json.has("textTrackStyle")) {
            jSONObject = json.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzf(jSONObject);
            this.zzMn = textTrackStyle;
        } else {
            this.zzMn = null;
        }
        this.zzMo = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.zzMh;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzMi = streamType;
    }

    public int getStreamType() {
        return this.zzMi;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzMj = contentType;
    }

    public String getContentType() {
        return this.zzMj;
    }

    void zza(MediaMetadata mediaMetadata) {
        this.zzMk = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzMk;
    }

    void zzv(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzMl = l;
    }

    public long getStreamDuration() {
        return this.zzMl;
    }

    void zzk(List<MediaTrack> list) {
        this.zzMm = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzMm;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzMn = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzMn;
    }

    void setCustomData(JSONObject customData) {
        this.zzMo = customData;
    }

    public JSONObject getCustomData() {
        return this.zzMo;
    }

    void zzjS() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzMh)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzMj)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzMi == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string;
            jSONObject.put("contentId", (Object)this.zzMh);
            switch (this.zzMi) {
                case 1: {
                    string = "BUFFERED";
                    break;
                }
                case 2: {
                    string = "LIVE";
                    break;
                }
                default: {
                    string = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string);
            if (this.zzMj != null) {
                jSONObject.put("contentType", (Object)this.zzMj);
            }
            if (this.zzMk != null) {
                jSONObject.put("metadata", (Object)this.zzMk.toJson());
            }
            if (this.zzMl <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", zzf.zzy(this.zzMl));
            }
            if (this.zzMm != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzMm) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzMn != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzMn.toJson());
            }
            if (this.zzMo != null) {
                jSONObject.put("customData", (Object)this.zzMo);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.zzMo == null != (mediaInfo.zzMo == null)) {
            return false;
        }
        if (this.zzMo != null && mediaInfo.zzMo != null && !zzhz.zzd((Object)this.zzMo, (Object)mediaInfo.zzMo)) {
            return false;
        }
        return zzf.zza(this.zzMh, mediaInfo.zzMh) && this.zzMi == mediaInfo.zzMi && zzf.zza(this.zzMj, mediaInfo.zzMj) && zzf.zza(this.zzMk, mediaInfo.zzMk) && this.zzMl == mediaInfo.zzMl;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzMh, this.zzMi, this.zzMj, this.zzMk, this.zzMl, String.valueOf(this.zzMo)});
    }

    public static class Builder {
        private final MediaInfo zzMp;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzMp = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.zzMp.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.zzMp.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.zzMp.zza(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.zzMp.zzv(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzMp.setCustomData(customData);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> mediaTracks) {
            this.zzMp.zzk(mediaTracks);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzMp.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzMp.zzjS();
            return this.zzMp;
        }
    }
}

