/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.ApplicationStatus;
import com.google.android.gms.cast.internal.DeviceStatus;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzi;
import com.google.android.gms.cast.internal.zzj;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.BinderWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zze
extends com.google.android.gms.common.internal.zzi<zzi> {
    private static final zzl zzNy = new zzl("CastClientImpl");
    private ApplicationMetadata zzNz;
    private final CastDevice zzNA;
    private final Cast.Listener zzLS;
    private final Map<String, Cast.MessageReceivedCallback> zzNB;
    private final long zzNC;
    private zzc zzND;
    private String zzNE;
    private boolean zzME;
    private boolean zzNF;
    private boolean zzNG;
    private boolean zzNH;
    private double zzMD;
    private int zzNI;
    private int zzNJ;
    private final AtomicLong zzNK;
    private String zzNL;
    private String zzNM;
    private Bundle zzNN;
    private final Map<Long, zza.zzb<Status>> zzNO;
    private final zzb zzNP;
    private zza.zzb<Cast.ApplicationConnectionResult> zzNQ;
    private zza.zzb<Status> zzNR;
    private static final Object zzNS = new Object();
    private static final Object zzNT = new Object();

    public zze(Context context, Looper looper, CastDevice castDevice, long l, Cast.Listener listener, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, connectionCallbacks, onConnectionFailedListener);
        this.zzNA = castDevice;
        this.zzLS = listener;
        this.zzNC = l;
        this.zzNB = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzNK = new AtomicLong(0L);
        this.zzNO = new HashMap<Long, zza.zzb<Status>>();
        this.zzjY();
        this.zzNP = new zzb();
        this.registerConnectionFailedListener(this.zzNP);
    }

    private void zzjY() {
        this.zzNH = false;
        this.zzNI = -1;
        this.zzNJ = -1;
        this.zzNz = null;
        this.zzNE = null;
        this.zzMD = 0.0;
        this.zzME = false;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle) {
        zzNy.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzNH = true;
            this.zzNF = true;
            this.zzNG = true;
        } else {
            this.zzNH = false;
        }
        int n2 = n;
        if (n == 1001) {
            this.zzNN = new Bundle();
            this.zzNN.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n2 = 0;
        }
        super.zza(n2, iBinder, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzNy.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzND, this.isConnected());
        zzc zzc2 = this.zzND;
        this.zzND = null;
        if (zzc2 == null || zzc2.zzkk() == null) {
            zzNy.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzkf();
        try {
            if (this.isConnected() || this.isConnecting()) {
                ((zzi)this.zzlX()).disconnect();
            }
        }
        catch (RemoteException remoteException) {
            zzNy.zza(remoteException, "Error while disconnecting the controller interface: %s", remoteException.getMessage());
        }
        finally {
            super.disconnect();
        }
    }

    public Bundle zzjZ() {
        if (this.zzNN != null) {
            Bundle bundle = this.zzNN;
            this.zzNN = null;
            return bundle;
        }
        return super.zzjZ();
    }

    protected String zzeq() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    protected String zzer() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected zzi zzN(IBinder iBinder) {
        return zzi.zza.zzO(iBinder);
    }

    protected Bundle zzka() {
        Bundle bundle = new Bundle();
        zzNy.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzNL, this.zzNM);
        this.zzNA.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzNC);
        this.zzND = new zzc(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzND.asBinder()));
        if (this.zzNL != null) {
            bundle.putString("last_application_id", this.zzNL);
            if (this.zzNM != null) {
                bundle.putString("last_session_id", this.zzNM);
            }
        }
        return bundle;
    }

    public void zza(String string, String string2, zza.zzb<Status> zzb2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string2.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzf.zzbo(string);
        this.zzkg();
        long l = this.zzNK.incrementAndGet();
        try {
            this.zzNO.put(l, zzb2);
            ((zzi)this.zzlX()).zza(string, string2, l);
        }
        catch (Throwable throwable) {
            this.zzNO.remove(l);
            throw throwable;
        }
    }

    public void zza(String string, boolean bl, zza.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zzlX()).zzf(string, bl);
    }

    public void zza(String string, LaunchOptions launchOptions, zza.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zzlX()).zza(string, launchOptions);
    }

    public void zzb(String string, String string2, zza.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zzlX()).zzq(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(zza.zzb<Cast.ApplicationConnectionResult> zzb2) {
        Object object = zzNS;
        synchronized (object) {
            if (this.zzNQ != null) {
                this.zzNQ.zzj((Object)new zza(new Status(2002)));
            }
            this.zzNQ = zzb2;
        }
    }

    public void zzd(zza.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zze(zzb2);
        ((zzi)this.zzlX()).zzkn();
    }

    public void zza(String string, zza.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zze(zzb2);
        ((zzi)this.zzlX()).zzbq(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zze(zza.zzb<Status> zzb2) {
        Object object = zzNT;
        synchronized (object) {
            if (this.zzNR != null) {
                zzb2.zzj((Object)new Status(2001));
                return;
            }
            this.zzNR = zzb2;
        }
    }

    public void zzkb() throws IllegalStateException, RemoteException {
        ((zzi)this.zzlX()).zzkb();
    }

    public void zzb(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        ((zzi)this.zzlX()).zza(d, this.zzMD, this.zzME);
    }

    public void zzN(boolean bl) throws IllegalStateException, RemoteException {
        ((zzi)this.zzlX()).zza(bl, this.zzMD, this.zzME);
    }

    public double zzkc() throws IllegalStateException {
        this.zzkg();
        return this.zzMD;
    }

    public boolean isMute() throws IllegalStateException {
        this.zzkg();
        return this.zzME;
    }

    public int zzkd() throws IllegalStateException {
        this.zzkg();
        return this.zzNI;
    }

    public int zzke() throws IllegalStateException {
        this.zzkg();
        return this.zzNJ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzf.zzbo(string);
        this.zzbn(string);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzNB;
            synchronized (map) {
                this.zzNB.put(string, messageReceivedCallback);
            }
            ((zzi)this.zzlX()).zzbr(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbn(String string) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzNB;
        synchronized (map) {
            messageReceivedCallback = this.zzNB.remove(string);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzi)this.zzlX()).zzbs(string);
            }
            catch (IllegalStateException illegalStateException) {
                zzNy.zza(illegalStateException, "Error unregistering namespace (%s): %s", string, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzkg();
        return this.zzNz;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.zzkg();
        return this.zzNE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzkf() {
        zzNy.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzNB;
        synchronized (map) {
            this.zzNB.clear();
        }
    }

    private void zza(DeviceStatus deviceStatus) {
        boolean bl;
        ApplicationMetadata applicationMetadata = deviceStatus.getApplicationMetadata();
        if (!zzf.zza(applicationMetadata, this.zzNz)) {
            this.zzNz = applicationMetadata;
            this.zzLS.onApplicationMetadataChanged(this.zzNz);
        }
        boolean bl2 = false;
        double d = deviceStatus.zzkc();
        if (d != Double.NaN && Math.abs(d - this.zzMD) > 1.0E-7) {
            this.zzMD = d;
            bl2 = true;
        }
        if ((bl = deviceStatus.zzkm()) != this.zzME) {
            this.zzME = bl;
            bl2 = true;
        }
        zzNy.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzNG);
        if (this.zzLS != null && (bl2 || this.zzNG)) {
            this.zzLS.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = deviceStatus.zzkd();
        if (n != this.zzNI) {
            this.zzNI = n;
            bl3 = true;
        }
        zzNy.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzNG);
        if (this.zzLS != null && (bl3 || this.zzNG)) {
            this.zzLS.onActiveInputStateChanged(this.zzNI);
        }
        boolean bl4 = false;
        int n2 = deviceStatus.zzke();
        if (n2 != this.zzNJ) {
            this.zzNJ = n2;
            bl4 = true;
        }
        zzNy.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzNG);
        if (this.zzLS != null && (bl4 || this.zzNG)) {
            this.zzLS.onStandbyStateChanged(this.zzNJ);
        }
        this.zzNG = false;
    }

    private void zza(ApplicationStatus applicationStatus) {
        boolean bl = false;
        String string = applicationStatus.zzjV();
        if (!zzf.zza(string, this.zzNE)) {
            this.zzNE = string;
            bl = true;
        }
        zzNy.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzNF);
        if (this.zzLS != null && (bl || this.zzNF)) {
            this.zzLS.onApplicationStatusChanged();
        }
        this.zzNF = false;
    }

    private void zzkg() throws IllegalStateException {
        if (!this.zzNH || this.zzND == null || this.zzND.zzkl()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected /* synthetic */ IInterface zzD(IBinder iBinder) {
        return this.zzN(iBinder);
    }

    private static class zzc
    extends zzj.zza {
        private final AtomicReference<zze> zzNY;
        private final Handler mHandler;

        public zzc(zze zze2) {
            this.zzNY = new AtomicReference<zze>(zze2);
            this.mHandler = new Handler(zze2.getLooper());
        }

        public zze zzkk() {
            zze zze2 = this.zzNY.getAndSet(null);
            if (zze2 == null) {
                return null;
            }
            zze2.zzjY();
            return zze2;
        }

        public boolean zzkl() {
            return this.zzNY.get() == null;
        }

        @Override
        public void zzam(int n) {
            zze zze2 = this.zzkk();
            if (zze2 == null) {
                return;
            }
            zzNy.zzb("ICastDeviceControllerListener.onDisconnected: %d", n);
            if (n != 0) {
                zze2.zzaO(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ApplicationMetadata applicationMetadata, String string, String string2, boolean bl) {
            zze zze2 = this.zzNY.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzNz = applicationMetadata;
            zze2.zzNL = applicationMetadata.getApplicationId();
            zze2.zzNM = string2;
            Object object = zzNS;
            synchronized (object) {
                if (zze2.zzNQ != null) {
                    zze2.zzNQ.zzj((Object)new zza(new Status(0), applicationMetadata, string, string2, bl));
                    zze2.zzNQ = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzan(int n) {
            zze zze2 = this.zzNY.get();
            if (zze2 == null) {
                return;
            }
            Object object = zzNS;
            synchronized (object) {
                if (zze2.zzNQ != null) {
                    zze2.zzNQ.zzj((Object)new zza(new Status(n)));
                    zze2.zzNQ = null;
                }
            }
        }

        @Override
        public void zzao(int n) {
            zze zze2 = this.zzNY.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void zzap(int n) {
            zze zze2 = this.zzNY.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void onApplicationDisconnected(final int statusCode) {
            final zze zze2 = this.zzNY.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzNL = null;
            zze2.zzNM = null;
            this.zza(zze2, statusCode);
            if (zze2.zzLS != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (zze2.zzLS != null) {
                            zze2.zzLS.onApplicationDisconnected(statusCode);
                        }
                    }
                });
            }
        }

        @Override
        public void zza(String string, double d, boolean bl) {
            zzNy.zzb("Deprecated callback: \"onStatusreceived\"", new Object[0]);
        }

        @Override
        public void zzb(final DeviceStatus deviceStatus) {
            final zze zze2 = this.zzNY.get();
            if (zze2 == null) {
                return;
            }
            zzNy.zzb("onDeviceStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(deviceStatus);
                }
            });
        }

        @Override
        public void zzb(final ApplicationStatus applicationStatus) {
            final zze zze2 = this.zzNY.get();
            if (zze2 == null) {
                return;
            }
            zzNy.zzb("onApplicationStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(applicationStatus);
                }
            });
        }

        @Override
        public void zzp(final String string, final String string2) {
            final zze zze2 = this.zzNY.get();
            if (zze2 == null) {
                return;
            }
            zzNy.zzb("Receive (type=text, ns=%s) %s", string, string2);
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cast.MessageReceivedCallback messageReceivedCallback;
                    Map map = zze2.zzNB;
                    synchronized (map) {
                        messageReceivedCallback = (Cast.MessageReceivedCallback)zze2.zzNB.get(string);
                    }
                    if (messageReceivedCallback != null) {
                        messageReceivedCallback.onMessageReceived(zze2.zzNA, string, string2);
                    } else {
                        zzNy.zzb("Discarded message for unknown namespace '%s'", string);
                    }
                }
            });
        }

        @Override
        public void zzb(String string, byte[] byArray) {
            zze zze2 = this.zzNY.get();
            if (zze2 == null) {
                return;
            }
            zzNy.zzb("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string, byArray.length);
        }

        @Override
        public void zza(String string, long l, int n) {
            zze zze2 = this.zzNY.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, n);
        }

        @Override
        public void zzc(String string, long l) {
            zze zze2 = this.zzNY.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(zze zze2, long l, int n) {
            zza.zzb zzb2;
            Map map = zze2.zzNO;
            synchronized (map) {
                zzb2 = (zza.zzb)zze2.zzNO.remove(l);
            }
            if (zzb2 != null) {
                zzb2.zzj((Object)new Status(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(zze zze2, int n) {
            Object object = zzNT;
            synchronized (object) {
                if (zze2.zzNR != null) {
                    zze2.zzNR.zzj((Object)new Status(n));
                    zze2.zzNR = null;
                    return true;
                }
            }
            return false;
        }
    }

    private class zzb
    implements GoogleApiClient.OnConnectionFailedListener {
        private zzb() {
        }

        public void onConnectionFailed(ConnectionResult result) {
            zze.this.zzkf();
        }
    }

    private static final class zza
    implements Cast.ApplicationConnectionResult {
        private final Status zzKr;
        private final ApplicationMetadata zzNU;
        private final String zzNV;
        private final String zzBL;
        private final boolean zzNW;

        public zza(Status status, ApplicationMetadata applicationMetadata, String string, String string2, boolean bl) {
            this.zzKr = status;
            this.zzNU = applicationMetadata;
            this.zzNV = string;
            this.zzBL = string2;
            this.zzNW = bl;
        }

        public zza(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.zzKr;
        }

        @Override
        public ApplicationMetadata getApplicationMetadata() {
            return this.zzNU;
        }

        @Override
        public String getApplicationStatus() {
            return this.zzNV;
        }

        @Override
        public String getSessionId() {
            return this.zzBL;
        }

        @Override
        public boolean getWasLaunched() {
            return this.zzNW;
        }
    }
}

