/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.os.SystemClock;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zzc;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzm
extends zzc {
    private static final String NAMESPACE = zzf.zzbp("com.google.cast.media");
    private long zzOm;
    private MediaStatus zzOn;
    private final List<zzp> zzOo;
    private final zzp zzOp = new zzp(86400000L);
    private final zzp zzOq = new zzp(86400000L);
    private final zzp zzOr = new zzp(86400000L);
    private final zzp zzOs = new zzp(86400000L);
    private final zzp zzOt = new zzp(86400000L);
    private final zzp zzOu = new zzp(86400000L);
    private final zzp zzOv = new zzp(86400000L);
    private final zzp zzOw = new zzp(86400000L);
    private final zzp zzOx = new zzp(86400000L);
    private final zzp zzOy = new zzp(86400000L);

    public zzm(String string) {
        super(NAMESPACE, "MediaControlChannel", string, 1000L);
        this.zzOo = new ArrayList<zzp>();
        this.zzOo.add(this.zzOp);
        this.zzOo.add(this.zzOq);
        this.zzOo.add(this.zzOr);
        this.zzOo.add(this.zzOs);
        this.zzOo.add(this.zzOt);
        this.zzOo.add(this.zzOu);
        this.zzOo.add(this.zzOv);
        this.zzOo.add(this.zzOw);
        this.zzOo.add(this.zzOx);
        this.zzOo.add(this.zzOy);
        this.zzkr();
    }

    public long zza(zzo zzo2, MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzjX();
        this.zzOp.zza(l2, zzo2);
        this.zzM(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.toJson());
            jSONObject2.put("autoplay", bl);
            jSONObject2.put("currentTime", zzf.zzy(l));
            if (lArray != null) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzo zzo2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzjX();
        this.zzOq.zza(l, zzo2);
        this.zzM(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzjT());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzb(zzo zzo2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzjX();
        this.zzOs.zza(l, zzo2);
        this.zzM(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzjT());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzc(zzo zzo2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzjX();
        this.zzOr.zza(l, zzo2);
        this.zzM(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzjT());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, long l, int n, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzjX();
        this.zzOt.zza(l2, zzo2);
        this.zzM(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zzjT());
            jSONObject2.put("currentTime", zzf.zzy(l));
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzo zzo2, double d, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzjX();
        this.zzOu.zza(l, zzo2);
        this.zzM(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzjT());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, boolean bl, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzjX();
        this.zzOv.zza(l, zzo2);
        this.zzM(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzjT());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzjX();
        this.zzOw.zza(l, zzo2);
        this.zzM(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzOn != null) {
                jSONObject.put("mediaSessionId", this.zzOn.zzjT());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, long[] lArray) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzjX();
        this.zzOx.zza(l, zzo2);
        this.zzM(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzjT());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, TextTrackStyle textTrackStyle) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzjX();
        this.zzOy.zza(l, zzo2);
        this.zzM(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zzjT());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zzOm == 0L) {
            return 0L;
        }
        double d = this.zzOn.getPlaybackRate();
        long l = this.zzOn.getStreamPosition();
        int n = this.zzOn.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        long l2 = SystemClock.elapsedRealtime() - this.zzOm;
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l2 == 0L) {
            return l;
        }
        long l3 = mediaInfo.getStreamDuration();
        long l4 = l + (long)((double)l2 * d);
        if (l3 > 0L && l4 > l3) {
            l4 = l3;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.zzOn;
    }

    public MediaInfo getMediaInfo() {
        return this.zzOn == null ? null : this.zzOn.getMediaInfo();
    }

    @Override
    public final void zzbm(String string) {
        this.zzNv.zzb("message received: %s", string);
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            if (string2.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.zza(l, jSONArray.getJSONObject(0));
                } else {
                    this.zzOn = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.zzOw.zzc(l, 0);
                }
            } else if (string2.equals("INVALID_PLAYER_STATE")) {
                this.zzNv.zzd("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                for (zzp zzp2 : this.zzOo) {
                    zzp2.zzb(l, 2100, jSONObject2);
                }
            } else if (string2.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.zzOp.zzb(l, 2100, jSONObject3);
            } else if (string2.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.zzOp.zzb(l, 2101, jSONObject4);
            } else if (string2.equals("INVALID_REQUEST")) {
                this.zzNv.zzd("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                for (zzp zzp3 : this.zzOo) {
                    zzp3.zzb(l, 2100, jSONObject5);
                }
            }
        }
        catch (JSONException jSONException) {
            this.zzNv.zzd("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string);
        }
    }

    private void zza(long l, JSONObject jSONObject) throws JSONException {
        boolean bl = this.zzOp.zzz(l);
        boolean bl2 = this.zzOt.zzkt() && !this.zzOt.zzz(l);
        boolean bl3 = this.zzOu.zzkt() && !this.zzOu.zzz(l) || this.zzOv.zzkt() && !this.zzOv.zzz(l);
        int n = 0;
        if (bl2) {
            n |= 2;
        }
        if (bl3) {
            n |= 1;
        }
        int n2 = 0;
        if (bl || this.zzOn == null) {
            this.zzOn = new MediaStatus(jSONObject);
            this.zzOm = SystemClock.elapsedRealtime();
            n2 = 7;
        } else {
            n2 = this.zzOn.zza(jSONObject, n);
        }
        if ((n2 & 1) != 0) {
            this.zzOm = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n2 & 2) != 0) {
            this.zzOm = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n2 & 4) != 0) {
            this.onMetadataUpdated();
        }
        for (zzp zzp2 : this.zzOo) {
            zzp2.zzc(l, 0);
        }
    }

    public long zzjT() throws IllegalStateException {
        if (this.zzOn == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.zzOn.zzjT();
    }

    protected void onStatusUpdated() {
    }

    protected void onMetadataUpdated() {
    }

    private void zzkr() {
        this.zzOm = 0L;
        this.zzOn = null;
        for (zzp zzp2 : this.zzOo) {
            zzp2.clear();
        }
    }

    @Override
    public void zzjW() {
        super.zzjW();
        this.zzkr();
    }

    @Override
    public void zzb(long l, int n) {
        for (zzp zzp2 : this.zzOo) {
            zzp2.zzc(l, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzx(long l) {
        for (zzp object2 : this.zzOo) {
            object2.zzd(l, 2102);
        }
        boolean bl = false;
        Object object = zzp.zzOD;
        synchronized (object) {
            for (zzp zzp2 : this.zzOo) {
                if (!zzp2.zzkt()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

