/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.internal.zzlh;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    private final String zzRC;
    private int zzRD;
    private String zzRE;
    private MediaMetadata zzRF;
    private long zzRG;
    private List<MediaTrack> zzRH;
    private TextTrackStyle zzRI;
    private JSONObject zzRJ;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.zzRC = contentId;
        this.zzRD = -1;
        this.zzRG = -1L;
    }

    MediaInfo(JSONObject json) throws JSONException {
        double d;
        int n;
        JSONObject jSONObject;
        this.zzRC = json.getString("contentId");
        String string2 = json.getString("streamType");
        this.zzRD = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzRE = json.getString("contentType");
        if (json.has("metadata")) {
            jSONObject = json.getJSONObject("metadata");
            n = jSONObject.getInt("metadataType");
            this.zzRF = new MediaMetadata(n);
            this.zzRF.zzf(jSONObject);
        }
        this.zzRG = -1L;
        if (json.has("duration") && !json.isNull("duration") && !Double.isNaN(d = json.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzRG = zzf.zze(d);
        }
        if (json.has("tracks")) {
            this.zzRH = new ArrayList<MediaTrack>();
            jSONObject = json.getJSONArray("tracks");
            for (n = 0; n < jSONObject.length(); ++n) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject2);
                this.zzRH.add(mediaTrack);
            }
        } else {
            this.zzRH = null;
        }
        if (json.has("textTrackStyle")) {
            jSONObject = json.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzf(jSONObject);
            this.zzRI = textTrackStyle;
        } else {
            this.zzRI = null;
        }
        this.zzRJ = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.zzRC;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzRD = streamType;
    }

    public int getStreamType() {
        return this.zzRD;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzRE = contentType;
    }

    public String getContentType() {
        return this.zzRE;
    }

    void zza(MediaMetadata mediaMetadata) {
        this.zzRF = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzRF;
    }

    void zzx(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzRG = l;
    }

    public long getStreamDuration() {
        return this.zzRG;
    }

    void zzj(List<MediaTrack> list) {
        this.zzRH = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzRH;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzRI = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzRI;
    }

    void setCustomData(JSONObject customData) {
        this.zzRJ = customData;
    }

    public JSONObject getCustomData() {
        return this.zzRJ;
    }

    void zzlq() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzRC)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzRE)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzRD == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.zzRC);
            switch (this.zzRD) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzRE != null) {
                jSONObject.put("contentType", (Object)this.zzRE);
            }
            if (this.zzRF != null) {
                jSONObject.put("metadata", (Object)this.zzRF.toJson());
            }
            if (this.zzRG <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", zzf.zzA(this.zzRG));
            }
            if (this.zzRH != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzRH) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzRI != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzRI.toJson());
            }
            if (this.zzRJ != null) {
                jSONObject.put("customData", (Object)this.zzRJ);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.zzRJ == null != (mediaInfo.zzRJ == null)) {
            return false;
        }
        if (this.zzRJ != null && mediaInfo.zzRJ != null && !zzlh.zzd((Object)this.zzRJ, (Object)mediaInfo.zzRJ)) {
            return false;
        }
        return zzf.zza(this.zzRC, mediaInfo.zzRC) && this.zzRD == mediaInfo.zzRD && zzf.zza(this.zzRE, mediaInfo.zzRE) && zzf.zza(this.zzRF, mediaInfo.zzRF) && this.zzRG == mediaInfo.zzRG;
    }

    public int hashCode() {
        return zzt.hashCode((Object[])new Object[]{this.zzRC, this.zzRD, this.zzRE, this.zzRF, this.zzRG, String.valueOf(this.zzRJ)});
    }

    public static class Builder {
        private final MediaInfo zzRK;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzRK = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.zzRK.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.zzRK.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.zzRK.zza(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.zzRK.zzx(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzRK.setCustomData(customData);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> mediaTracks) {
            this.zzRK.zzj(mediaTracks);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzRK.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzRK.zzlq();
            return this.zzRK;
        }
    }
}

