/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.internal.zzlh;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    private long zzOw;
    private int zzSq;
    private String zzRC;
    private String zzRE;
    private String mName;
    private String zzRA;
    private int zzSr;
    private JSONObject zzRJ;

    MediaTrack(JSONObject json) throws JSONException {
        this.zzf(json);
    }

    MediaTrack(long id, int type) throws IllegalArgumentException {
        this.clear();
        this.zzOw = id;
        if (type <= 0 || type > 3) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.zzSq = type;
    }

    public long getId() {
        return this.zzOw;
    }

    public int getType() {
        return this.zzSq;
    }

    public String getContentId() {
        return this.zzRC;
    }

    public void setContentId(String contentId) {
        this.zzRC = contentId;
    }

    public String getContentType() {
        return this.zzRE;
    }

    public void setContentType(String contentType) {
        this.zzRE = contentType;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getLanguage() {
        return this.zzRA;
    }

    void setLanguage(String language) {
        this.zzRA = language;
    }

    public int getSubtype() {
        return this.zzSr;
    }

    void zzaG(int n) throws IllegalArgumentException {
        if (n <= -1 || n > 5) {
            throw new IllegalArgumentException("invalid subtype " + n);
        }
        if (n != 0 && this.zzSq != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzSr = n;
    }

    public JSONObject getCustomData() {
        return this.zzRJ;
    }

    void setCustomData(JSONObject customData) {
        this.zzRJ = customData;
    }

    private void clear() {
        this.zzOw = 0L;
        this.zzSq = 0;
        this.zzRC = null;
        this.mName = null;
        this.zzRA = null;
        this.zzSr = -1;
        this.zzRJ = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zzf(JSONObject jSONObject) throws JSONException {
        this.clear();
        this.zzOw = jSONObject.getLong("trackId");
        String string = jSONObject.getString("type");
        if ("TEXT".equals(string)) {
            this.zzSq = 1;
        } else if ("AUDIO".equals(string)) {
            this.zzSq = 2;
        } else {
            if (!"VIDEO".equals(string)) throw new JSONException("invalid type: " + string);
            this.zzSq = 3;
        }
        this.zzRC = jSONObject.optString("trackContentId", null);
        this.zzRE = jSONObject.optString("trackContentType", null);
        this.mName = jSONObject.optString("name", null);
        this.zzRA = jSONObject.optString("language", null);
        if (jSONObject.has("subtype")) {
            string = jSONObject.getString("subtype");
            if ("SUBTITLES".equals(string)) {
                this.zzSr = 1;
            } else if ("CAPTIONS".equals(string)) {
                this.zzSr = 2;
            } else if ("DESCRIPTIONS".equals(string)) {
                this.zzSr = 3;
            } else if ("CHAPTERS".equals(string)) {
                this.zzSr = 4;
            } else {
                if (!"METADATA".equals(string)) throw new JSONException("invalid subtype: " + string);
                this.zzSr = 5;
            }
        } else {
            this.zzSr = 0;
        }
        this.zzRJ = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzOw);
            switch (this.zzSq) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.zzRC != null) {
                jSONObject.put("trackContentId", (Object)this.zzRC);
            }
            if (this.zzRE != null) {
                jSONObject.put("trackContentType", (Object)this.zzRE);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzRA)) {
                jSONObject.put("language", (Object)this.zzRA);
            }
            switch (this.zzSr) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.zzRJ != null) {
                jSONObject.put("customData", (Object)this.zzRJ);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)other;
        if (this.zzRJ == null != (mediaTrack.zzRJ == null)) {
            return false;
        }
        if (this.zzRJ != null && mediaTrack.zzRJ != null && !zzlh.zzd((Object)this.zzRJ, (Object)mediaTrack.zzRJ)) {
            return false;
        }
        return this.zzOw == mediaTrack.zzOw && this.zzSq == mediaTrack.zzSq && zzf.zza(this.zzRC, mediaTrack.zzRC) && zzf.zza(this.zzRE, mediaTrack.zzRE) && zzf.zza(this.mName, mediaTrack.mName) && zzf.zza(this.zzRA, mediaTrack.zzRA) && this.zzSr == mediaTrack.zzSr;
    }

    public int hashCode() {
        return zzt.hashCode((Object[])new Object[]{this.zzOw, this.zzSq, this.zzRC, this.zzRE, this.mName, this.zzRA, this.zzSr, this.zzRJ});
    }

    public static class Builder {
        private final MediaTrack zzSs;

        public Builder(long trackId, int trackType) throws IllegalArgumentException {
            this.zzSs = new MediaTrack(trackId, trackType);
        }

        public Builder setContentId(String contentId) {
            this.zzSs.setContentId(contentId);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.zzSs.setContentType(contentType);
            return this;
        }

        public Builder setName(String trackName) {
            this.zzSs.setName(trackName);
            return this;
        }

        public Builder setLanguage(String language) {
            this.zzSs.setLanguage(language);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzSs.setLanguage(zzf.zzb(locale));
            return this;
        }

        public Builder setSubtype(int subtype) throws IllegalArgumentException {
            this.zzSs.zzaG(subtype);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzSs.setCustomData(customData);
            return this;
        }

        public MediaTrack build() {
            return this.zzSs;
        }
    }
}

