/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzls;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public final class zzkh
implements GameManagerState {
    private final int zzWx;
    private final int zzWw;
    private final String zzWA;
    private final JSONObject zzWz;
    private final String zzWq;
    private final int zzWr;
    private final Map<String, PlayerInfo> zzWC;

    public zzkh(int n, int n2, String string2, JSONObject jSONObject, Collection<PlayerInfo> collection, String string3, int n3) {
        this.zzWx = n;
        this.zzWw = n2;
        this.zzWA = string2;
        this.zzWz = jSONObject;
        this.zzWq = string3;
        this.zzWr = n3;
        this.zzWC = new HashMap<String, PlayerInfo>(collection.size());
        for (PlayerInfo playerInfo : collection) {
            this.zzWC.put(playerInfo.getPlayerId(), playerInfo);
        }
    }

    @Override
    public int getLobbyState() {
        return this.zzWx;
    }

    @Override
    public int getGameplayState() {
        return this.zzWw;
    }

    @Override
    public JSONObject getGameData() {
        return this.zzWz;
    }

    @Override
    public CharSequence getGameStatusText() {
        return this.zzWA;
    }

    @Override
    public CharSequence getApplicationName() {
        return this.zzWq;
    }

    @Override
    public int getMaxPlayers() {
        return this.zzWr;
    }

    @Override
    public List<PlayerInfo> getPlayersInState(int playerState) {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (playerInfo.getPlayerState() != playerState) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public PlayerInfo getPlayer(String playerId) {
        return playerId == null ? null : this.zzWC.get(playerId);
    }

    @Override
    public Collection<PlayerInfo> getPlayers() {
        return Collections.unmodifiableCollection(this.zzWC.values());
    }

    @Override
    public List<PlayerInfo> getControllablePlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isControllable()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public List<PlayerInfo> getConnectedPlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isConnected()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public List<PlayerInfo> getConnectedControllablePlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isConnected() || !playerInfo.isControllable()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public boolean hasLobbyStateChanged(GameManagerState other) {
        return this.zzWx != other.getLobbyState();
    }

    @Override
    public boolean hasGameplayStateChanged(GameManagerState other) {
        return this.zzWw != other.getGameplayState();
    }

    @Override
    public boolean hasGameDataChanged(GameManagerState other) {
        return !zzls.zzd((Object)this.zzWz, (Object)other.getGameData());
    }

    @Override
    public boolean hasGameStatusTextChanged(GameManagerState other) {
        return !zzf.zza(this.zzWA, other.getGameStatusText());
    }

    @Override
    public boolean hasPlayerChanged(String playerId, GameManagerState other) {
        return !zzf.zza(this.getPlayer(playerId), other.getPlayer(playerId));
    }

    @Override
    public boolean hasPlayerStateChanged(String playerId, GameManagerState other) {
        PlayerInfo playerInfo = this.getPlayer(playerId);
        PlayerInfo playerInfo2 = other.getPlayer(playerId);
        if (playerInfo == null && playerInfo2 == null) {
            return false;
        }
        if (playerInfo != null && playerInfo2 != null) {
            return playerInfo.getPlayerState() != playerInfo2.getPlayerState();
        }
        return true;
    }

    @Override
    public boolean hasPlayerDataChanged(String playerId, GameManagerState other) {
        PlayerInfo playerInfo = this.getPlayer(playerId);
        PlayerInfo playerInfo2 = other.getPlayer(playerId);
        if (playerInfo == null && playerInfo2 == null) {
            return false;
        }
        if (playerInfo != null && playerInfo2 != null) {
            return !zzls.zzd((Object)playerInfo.getPlayerData(), (Object)playerInfo2.getPlayerData());
        }
        return true;
    }

    @Override
    public Collection<String> getListOfChangedPlayers(GameManagerState other) {
        PlayerInfo playerInfo;
        HashSet<String> hashSet = new HashSet<String>();
        for (PlayerInfo playerInfo2 : this.getPlayers()) {
            playerInfo = other.getPlayer(playerInfo2.getPlayerId());
            if (playerInfo != null && playerInfo2.equals(playerInfo)) continue;
            hashSet.add(playerInfo2.getPlayerId());
        }
        for (PlayerInfo playerInfo2 : other.getPlayers()) {
            playerInfo = this.getPlayer(playerInfo2.getPlayerId());
            if (playerInfo != null) continue;
            hashSet.add(playerInfo2.getPlayerId());
        }
        return hashSet;
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null || !(otherObj instanceof GameManagerState)) {
            return false;
        }
        GameManagerState gameManagerState = (GameManagerState)otherObj;
        if (this.getPlayers().size() != gameManagerState.getPlayers().size()) {
            return false;
        }
        for (PlayerInfo playerInfo : this.getPlayers()) {
            boolean bl = false;
            for (PlayerInfo playerInfo2 : gameManagerState.getPlayers()) {
                if (!zzf.zza(playerInfo.getPlayerId(), playerInfo2.getPlayerId())) continue;
                if (!zzf.zza(playerInfo, playerInfo2)) {
                    return false;
                }
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return this.zzWx == gameManagerState.getLobbyState() && this.zzWw == gameManagerState.getGameplayState() && this.zzWr == gameManagerState.getMaxPlayers() && zzf.zza(this.zzWq, gameManagerState.getApplicationName()) && zzf.zza(this.zzWA, gameManagerState.getGameStatusText()) && zzls.zzd((Object)this.zzWz, (Object)gameManagerState.getGameData());
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzWx, this.zzWw, this.zzWC, this.zzWA, this.zzWz, this.zzWq, this.zzWr});
    }
}

