/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.os.SystemClock;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zzc;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzm
extends zzc {
    private static final String NAMESPACE = zzf.zzbM("com.google.cast.media");
    private long zzXA;
    private MediaStatus zzXB;
    private final List<zzp> zzVQ;
    private final zzp zzXC = new zzp(86400000L);
    private final zzp zzXD = new zzp(86400000L);
    private final zzp zzXE = new zzp(86400000L);
    private final zzp zzXF = new zzp(86400000L);
    private final zzp zzXG = new zzp(86400000L);
    private final zzp zzXH = new zzp(86400000L);
    private final zzp zzXI = new zzp(86400000L);
    private final zzp zzXJ = new zzp(86400000L);
    private final zzp zzXK = new zzp(86400000L);
    private final zzp zzXL = new zzp(86400000L);
    private final zzp zzXM = new zzp(86400000L);
    private final zzp zzXN = new zzp(86400000L);
    private final zzp zzXO = new zzp(86400000L);
    private final zzp zzXP = new zzp(86400000L);

    public zzm(String string2) {
        super(NAMESPACE, "MediaControlChannel", string2, 1000L);
        this.zzVQ = new ArrayList<zzp>();
        this.zzVQ.add(this.zzXC);
        this.zzVQ.add(this.zzXD);
        this.zzVQ.add(this.zzXE);
        this.zzVQ.add(this.zzXF);
        this.zzVQ.add(this.zzXG);
        this.zzVQ.add(this.zzXH);
        this.zzVQ.add(this.zzXI);
        this.zzVQ.add(this.zzXJ);
        this.zzVQ.add(this.zzXK);
        this.zzVQ.add(this.zzXL);
        this.zzVQ.add(this.zzXM);
        this.zzVQ.add(this.zzXN);
        this.zzVQ.add(this.zzXO);
        this.zzVQ.add(this.zzXP);
        this.zzmM();
    }

    public long zza(zzo zzo2, MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzmu();
        this.zzXC.zza(l2, zzo2);
        this.zzU(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.toJson());
            jSONObject2.put("autoplay", bl);
            jSONObject2.put("currentTime", zzf.zzA(l));
            if (lArray != null) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzo zzo2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzmu();
        this.zzXD.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzmc());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzb(zzo zzo2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzmu();
        this.zzXF.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzmc());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzc(zzo zzo2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzmu();
        this.zzXE.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzmc());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, long l, int n, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzmu();
        this.zzXG.zza(l2, zzo2);
        this.zzU(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zzmc());
            jSONObject2.put("currentTime", zzf.zzA(l));
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzo zzo2, double d, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzmu();
        this.zzXH.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzmc());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, boolean bl, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzmu();
        this.zzXI.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzmc());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzmu();
        this.zzXJ.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzXB != null) {
                jSONObject.put("mediaSessionId", this.zzXB.zzmc());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, long[] lArray) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzmu();
        this.zzXK.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzmc());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, TextTrackStyle textTrackStyle) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzmu();
        this.zzXL.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zzmc());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zzXA == 0L) {
            return 0L;
        }
        double d = this.zzXB.getPlaybackRate();
        long l = this.zzXB.getStreamPosition();
        int n = this.zzXB.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        long l2 = SystemClock.elapsedRealtime() - this.zzXA;
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l2 == 0L) {
            return l;
        }
        long l3 = mediaInfo.getStreamDuration();
        long l4 = l + (long)((double)l2 * d);
        if (l3 > 0L && l4 > l3) {
            l4 = l3;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.zzXB;
    }

    public MediaInfo getMediaInfo() {
        return this.zzXB == null ? null : this.zzXB.getMediaInfo();
    }

    public long zza(zzo zzo2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IOException, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= mediaQueueItemArray.length) {
            throw new IllegalArgumentException("Invalid startIndex: " + n);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzmu();
        this.zzXC.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            switch (n2) {
                case 0: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                    break;
                }
                case 1: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                    break;
                }
                case 2: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                    break;
                }
                case 3: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid repeat mode: " + n2);
                }
            }
            jSONObject2.put("startIndex", n);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, MediaQueueItem[] mediaQueueItemArray, int n, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalStateException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzmu();
        this.zzXM.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zzmc());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, int n, MediaQueueItem[] mediaQueueItemArray, int n2, Integer n3, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzmu();
        this.zzXN.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zzmc());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && mediaQueueItemArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                    jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                        break;
                    }
                    case 1: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                        break;
                    }
                    case 2: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                        break;
                    }
                    case 3: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                        break;
                    }
                }
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, int[] nArray, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzmu();
        this.zzXO.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zzmc());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzo zzo2, int[] nArray, int n, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzmu();
        this.zzXP.zza(l, zzo2);
        this.zzU(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zzmc());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    @Override
    public final void zzbJ(String string2) {
        this.zzWK.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            if (string3.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.zza(l, jSONArray.getJSONObject(0));
                } else {
                    this.zzXB = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.onQueueStatusUpdated();
                    this.onPreloadStatusUpdated();
                    this.zzXJ.zzc(l, 0);
                }
            } else if (string3.equals("INVALID_PLAYER_STATE")) {
                this.zzWK.zzf("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                for (zzp zzp2 : this.zzVQ) {
                    zzp2.zzc(l, 2100, jSONObject2);
                }
            } else if (string3.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.zzXC.zzc(l, 2100, jSONObject3);
            } else if (string3.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.zzXC.zzc(l, 2101, jSONObject4);
            } else if (string3.equals("INVALID_REQUEST")) {
                this.zzWK.zzf("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                for (zzp zzp3 : this.zzVQ) {
                    zzp3.zzc(l, 2100, jSONObject5);
                }
            }
        }
        catch (JSONException jSONException) {
            this.zzWK.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
        }
    }

    private void zza(long l, JSONObject jSONObject) throws JSONException {
        boolean bl = this.zzXC.zzB(l);
        boolean bl2 = this.zzXG.zzmO() && !this.zzXG.zzB(l);
        boolean bl3 = this.zzXH.zzmO() && !this.zzXH.zzB(l) || this.zzXI.zzmO() && !this.zzXI.zzB(l);
        int n = 0;
        if (bl2) {
            n |= 2;
        }
        if (bl3) {
            n |= 1;
        }
        int n2 = 0;
        if (bl || this.zzXB == null) {
            this.zzXB = new MediaStatus(jSONObject);
            this.zzXA = SystemClock.elapsedRealtime();
            n2 = 31;
        } else {
            n2 = this.zzXB.zza(jSONObject, n);
        }
        if ((n2 & 1) != 0) {
            this.zzXA = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n2 & 2) != 0) {
            this.zzXA = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n2 & 4) != 0) {
            this.onMetadataUpdated();
        }
        if ((n2 & 8) != 0) {
            this.onQueueStatusUpdated();
        }
        if ((n2 & 0x10) != 0) {
            this.onPreloadStatusUpdated();
        }
        for (zzp zzp2 : this.zzVQ) {
            zzp2.zzc(l, 0);
        }
    }

    public long zzmc() throws IllegalStateException {
        if (this.zzXB == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.zzXB.zzmc();
    }

    protected void onStatusUpdated() {
    }

    protected void onMetadataUpdated() {
    }

    protected void onQueueStatusUpdated() {
    }

    protected void onPreloadStatusUpdated() {
    }

    private void zzmM() {
        this.zzXA = 0L;
        this.zzXB = null;
        for (zzp zzp2 : this.zzVQ) {
            zzp2.clear();
        }
    }

    @Override
    public void zzmt() {
        super.zzmt();
        this.zzmM();
    }

    @Override
    public void zzb(long l, int n) {
        for (zzp zzp2 : this.zzVQ) {
            zzp2.zzc(l, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzz(long l) {
        for (zzp object2 : this.zzVQ) {
            object2.zzd(l, 2102);
        }
        boolean bl = false;
        Object object = zzp.zzXT;
        synchronized (object) {
            for (zzp zzp2 : this.zzVQ) {
                if (!zzp2.zzmO()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

