/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
implements SafeParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzb();
    private final int mVersionCode;
    private String zzVd;
    String zzVe;
    private Inet4Address zzVf;
    private String zzVg;
    private String zzVh;
    private String zzVi;
    private int zzVj;
    private List<WebImage> zzVk;
    private int zzVl;
    private int zzys;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons, int capabilities, int status) {
        this.mVersionCode = versionCode;
        this.zzVd = deviceId;
        this.zzVe = hostAddress;
        if (this.zzVe != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzVe);
                if (inetAddress instanceof Inet4Address) {
                    this.zzVf = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.zzVf = null;
            }
        }
        this.zzVg = friendlyName;
        this.zzVh = modelName;
        this.zzVi = deviceVersion;
        this.zzVj = servicePort;
        this.zzVk = icons;
        this.zzVl = capabilities;
        this.zzys = status;
    }

    private CastDevice() {
        this(3, null, null, null, null, null, -1, new ArrayList<WebImage>(), 0, -1);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getDeviceId() {
        return this.zzVd;
    }

    public Inet4Address getIpAddress() {
        return this.zzVf;
    }

    public String getFriendlyName() {
        return this.zzVg;
    }

    public String getModelName() {
        return this.zzVh;
    }

    public String getDeviceVersion() {
        return this.zzVi;
    }

    public int getServicePort() {
        return this.zzVj;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzVk);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.zzVk.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.zzVk.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzVk) {
            int n = webImage3.getWidth();
            int n2 = webImage3.getHeight();
            if (n >= preferredWidth && n2 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n || webImage.getHeight() <= n2)) continue;
                webImage = webImage3;
                continue;
            }
            if (n >= preferredWidth || n2 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n || webImage2.getHeight() >= n2)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzVk.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzVk.isEmpty();
    }

    public int getCapabilities() {
        return this.zzVl;
    }

    public boolean hasCapability(int capability) {
        return (this.zzVl & capability) == capability;
    }

    public boolean hasCapabilities(int[] capabilities) {
        if (capabilities == null) {
            return false;
        }
        for (int n : capabilities) {
            if (this.hasCapability(n)) continue;
            return false;
        }
        return true;
    }

    public int getStatus() {
        return this.zzys;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzVg, this.zzVd);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzb.zza(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return zzf.zza(this.zzVd, castDevice.zzVd) && zzf.zza(this.zzVf, castDevice.zzVf) && zzf.zza(this.zzVh, castDevice.zzVh) && zzf.zza(this.zzVg, castDevice.zzVg) && zzf.zza(this.zzVi, castDevice.zzVi) && this.zzVj == castDevice.zzVj && zzf.zza(this.zzVk, castDevice.zzVk) && this.zzVl == castDevice.zzVl && this.zzys == castDevice.zzys;
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return zzf.zza(this.getDeviceId(), castDevice.getDeviceId());
    }

    public int hashCode() {
        return this.zzVd == null ? 0 : this.zzVd.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzVd.startsWith("__cast_nearby__");
    }
}

