/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.util.SparseArray;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.internal.zzf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaStatus {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    private int zzWt = 0;
    private long zzWu;
    private MediaInfo zzWd;
    private double zzWv;
    private int zzWw;
    private int zzWx;
    private long zzWy;
    private long zzWz;
    private double zzWA;
    private boolean zzWB;
    private long[] zzWr;
    private JSONObject zzWc;
    private int zzWC = 0;
    private int zzWD = 0;
    private final zza zzWE = new zza();

    public MediaStatus(JSONObject json) throws JSONException {
        this.zza(json, 0);
    }

    public long zzmy() {
        return this.zzWu;
    }

    public int getPlayerState() {
        return this.zzWw;
    }

    public int getIdleReason() {
        return this.zzWx;
    }

    public double getPlaybackRate() {
        return this.zzWv;
    }

    public MediaInfo getMediaInfo() {
        return this.zzWd;
    }

    public long getStreamPosition() {
        return this.zzWy;
    }

    public boolean isMediaCommandSupported(long mediaCommand) {
        return (this.zzWz & mediaCommand) != 0L;
    }

    public double getStreamVolume() {
        return this.zzWA;
    }

    public boolean isMute() {
        return this.zzWB;
    }

    public long[] getActiveTrackIds() {
        return this.zzWr;
    }

    public JSONObject getCustomData() {
        return this.zzWc;
    }

    public int getCurrentItemId() {
        return this.zzWt;
    }

    public int getLoadingItemId() {
        return this.zzWC;
    }

    public int getPreloadedItemId() {
        return this.zzWD;
    }

    public int getQueueRepeatMode() {
        return this.zzWE.getRepeatMode();
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzWE.zzmz();
    }

    public int getQueueItemCount() {
        return this.zzWE.getItemCount();
    }

    public MediaQueueItem getQueueItemById(int itemId) {
        return this.zzWE.zzaS(itemId);
    }

    public MediaQueueItem getQueueItem(int index) {
        return this.zzWE.zzaT(index);
    }

    public int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        int n3;
        int n4;
        long l;
        long l2;
        double d;
        int n5 = 0;
        long l3 = jSONObject.getLong("mediaSessionId");
        if (l3 != this.zzWu) {
            this.zzWu = l3;
            n5 |= 1;
        }
        if (jSONObject.has("playerState")) {
            int n6 = 0;
            String string = jSONObject.getString("playerState");
            if (string.equals("IDLE")) {
                n6 = 1;
            } else if (string.equals("PLAYING")) {
                n6 = 2;
            } else if (string.equals("PAUSED")) {
                n6 = 3;
            } else if (string.equals("BUFFERING")) {
                n6 = 4;
            }
            if (n6 != this.zzWw) {
                this.zzWw = n6;
                n5 |= 2;
            }
            if (n6 == 1 && jSONObject.has("idleReason")) {
                int n7 = 0;
                string = jSONObject.getString("idleReason");
                if (string.equals("CANCELLED")) {
                    n7 = 2;
                } else if (string.equals("INTERRUPTED")) {
                    n7 = 3;
                } else if (string.equals("FINISHED")) {
                    n7 = 1;
                } else if (string.equals("ERROR")) {
                    n7 = 4;
                }
                if (n7 != this.zzWx) {
                    this.zzWx = n7;
                    n5 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.zzWv != (d = jSONObject.getDouble("playbackRate"))) {
            this.zzWv = d;
            n5 |= 2;
        }
        if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = zzf.zzg(jSONObject.getDouble("currentTime"))) != this.zzWy) {
            this.zzWy = l2;
            n5 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzWz) {
            this.zzWz = l;
            n5 |= 2;
        }
        if (jSONObject.has("volume") && (n & 1) == 0) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d2 = jSONObject2.getDouble("level");
            if (d2 != this.zzWA) {
                this.zzWA = d2;
                n5 |= 2;
            }
            if ((n4 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.zzWB) {
                this.zzWB = n4;
                n5 |= 2;
            }
        }
        boolean bl = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n8;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            n4 = jSONArray.length();
            lArray = new long[n4];
            for (n8 = 0; n8 < n4; ++n8) {
                lArray[n8] = jSONArray.getLong(n8);
            }
            if (this.zzWr == null) {
                bl = true;
            } else if (this.zzWr.length != n4) {
                bl = true;
            } else {
                for (n8 = 0; n8 < n4; ++n8) {
                    if (this.zzWr[n8] == lArray[n8]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.zzWr = lArray;
            }
        } else if (this.zzWr != null) {
            bl = true;
        }
        if (bl) {
            this.zzWr = lArray;
            n5 |= 2;
        }
        if (jSONObject.has("customData")) {
            this.zzWc = jSONObject.getJSONObject("customData");
            n5 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            this.zzWd = new MediaInfo(jSONObject3);
            n5 |= 2;
            if (jSONObject3.has("metadata")) {
                n5 |= 4;
            }
        }
        if (jSONObject.has("currentItemId") && this.zzWt != (n3 = jSONObject.getInt("currentItemId"))) {
            this.zzWt = n3;
            n5 |= 2;
        }
        if (this.zzWD != (n2 = jSONObject.optInt("preloadedItemId", 0))) {
            this.zzWD = n2;
            n5 |= 0x10;
        }
        if (this.zzWC != (n4 = jSONObject.optInt("loadingItemId", 0))) {
            this.zzWC = n4;
            n5 |= 2;
        }
        if (!this.zzh(this.zzWw, this.zzWC)) {
            if (this.zzWE.zzg(jSONObject)) {
                n5 |= 8;
            }
        } else {
            this.zzWt = 0;
            this.zzWC = 0;
            this.zzWD = 0;
            if (this.zzWE.getItemCount() > 0) {
                this.zzWE.clear();
                n5 |= 8;
            }
        }
        return n5;
    }

    private boolean zzh(int n, int n2) {
        return n == 1 && n2 == 0;
    }

    private class zza {
        private int zzWF = 0;
        private List<MediaQueueItem> zzWG = new ArrayList<MediaQueueItem>();
        private SparseArray<Integer> zzWH = new SparseArray();

        zza() {
        }

        private boolean zzg(JSONObject jSONObject) throws JSONException {
            int n;
            String string;
            boolean bl = false;
            if (jSONObject.has("repeatMode")) {
                String string2;
                int n2 = this.zzWF;
                string = string2 = jSONObject.getString("repeatMode");
                n = -1;
                switch (string.hashCode()) {
                    case 1645952171: {
                        if (!string.equals("REPEAT_OFF")) break;
                        n = 0;
                        break;
                    }
                    case 1645938909: {
                        if (!string.equals("REPEAT_ALL")) break;
                        n = 1;
                        break;
                    }
                    case -962896020: {
                        if (!string.equals("REPEAT_SINGLE")) break;
                        n = 2;
                        break;
                    }
                    case -1118317585: {
                        if (!string.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                        n = 3;
                    }
                }
                switch (n) {
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    case 1: {
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                    }
                }
                if (this.zzWF != n2) {
                    this.zzWF = n2;
                    bl = true;
                }
            }
            if (jSONObject.has("items")) {
                JSONArray jSONArray = jSONObject.getJSONArray("items");
                int n3 = jSONArray.length();
                string = new SparseArray();
                for (n = 0; n < n3; ++n) {
                    string.put(n, (Object)jSONArray.getJSONObject(n).getInt("itemId"));
                }
                MediaQueueItem[] mediaQueueItemArray = new MediaQueueItem[n3];
                for (int i = 0; i < n3; ++i) {
                    Integer n4 = (Integer)string.get(i);
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    MediaQueueItem mediaQueueItem = this.zzaS(n4);
                    if (mediaQueueItem != null) {
                        bl |= mediaQueueItem.zzg(jSONObject2);
                        mediaQueueItemArray[i] = mediaQueueItem;
                        if (i == this.zzaU(n4)) continue;
                        bl = true;
                        continue;
                    }
                    bl = true;
                    if (n4 == MediaStatus.this.zzWt) {
                        mediaQueueItemArray[i] = new MediaQueueItem.Builder(MediaStatus.this.zzWd).build();
                        mediaQueueItemArray[i].zzg(jSONObject2);
                        continue;
                    }
                    mediaQueueItemArray[i] = new MediaQueueItem(jSONObject2);
                }
                if (this.zzWG.size() != n3) {
                    bl = true;
                }
                this.zza(mediaQueueItemArray);
            }
            return bl;
        }

        public int getRepeatMode() {
            return this.zzWF;
        }

        public List<MediaQueueItem> zzmz() {
            return Collections.unmodifiableList(this.zzWG);
        }

        public int getItemCount() {
            return this.zzWG.size();
        }

        public MediaQueueItem zzaS(int n) {
            Integer n2 = (Integer)this.zzWH.get(n);
            return n2 == null ? null : this.zzWG.get(n2);
        }

        public MediaQueueItem zzaT(int n) {
            if (n < 0 || n >= this.zzWG.size()) {
                return null;
            }
            return this.zzWG.get(n);
        }

        private Integer zzaU(int n) {
            return (Integer)this.zzWH.get(n);
        }

        private void zza(MediaQueueItem[] mediaQueueItemArray) {
            this.zzWG.clear();
            this.zzWH.clear();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
                this.zzWG.add(mediaQueueItem);
                this.zzWH.put(mediaQueueItem.getItemId(), (Object)i);
            }
        }

        private void clear() {
            this.zzWF = 0;
            this.zzWG.clear();
            this.zzWH.clear();
        }
    }
}

