/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
implements SafeParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzb();
    private final int mVersionCode;
    private String zzYn;
    String zzYo;
    private Inet4Address zzYp;
    private String zzYq;
    private String zzYr;
    private String zzYs;
    private int zzYt;
    private List<WebImage> zzYu;
    private int zzYv;
    private int zzAk;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons, int capabilities, int status) {
        this.mVersionCode = versionCode;
        this.zzYn = deviceId;
        this.zzYo = hostAddress;
        if (this.zzYo != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzYo);
                if (inetAddress instanceof Inet4Address) {
                    this.zzYp = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.zzYp = null;
            }
        }
        this.zzYq = friendlyName;
        this.zzYr = modelName;
        this.zzYs = deviceVersion;
        this.zzYt = servicePort;
        this.zzYu = icons;
        this.zzYv = capabilities;
        this.zzAk = status;
    }

    private CastDevice() {
        this(3, null, null, null, null, null, -1, new ArrayList<WebImage>(), 0, -1);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getDeviceId() {
        return this.zzYn;
    }

    public Inet4Address getIpAddress() {
        return this.zzYp;
    }

    public String getFriendlyName() {
        return this.zzYq;
    }

    public String getModelName() {
        return this.zzYr;
    }

    public String getDeviceVersion() {
        return this.zzYs;
    }

    public int getServicePort() {
        return this.zzYt;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzYu);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.zzYu.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.zzYu.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzYu) {
            int n = webImage3.getWidth();
            int n2 = webImage3.getHeight();
            if (n >= preferredWidth && n2 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n || webImage.getHeight() <= n2)) continue;
                webImage = webImage3;
                continue;
            }
            if (n >= preferredWidth || n2 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n || webImage2.getHeight() >= n2)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzYu.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzYu.isEmpty();
    }

    public int getCapabilities() {
        return this.zzYv;
    }

    public boolean hasCapability(int capability) {
        return (this.zzYv & capability) == capability;
    }

    public boolean hasCapabilities(int[] capabilities) {
        if (capabilities == null) {
            return false;
        }
        for (int n : capabilities) {
            if (this.hasCapability(n)) continue;
            return false;
        }
        return true;
    }

    public int getStatus() {
        return this.zzAk;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzYq, this.zzYn);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzb.zza(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return zzf.zza(this.zzYn, castDevice.zzYn) && zzf.zza(this.zzYp, castDevice.zzYp) && zzf.zza(this.zzYr, castDevice.zzYr) && zzf.zza(this.zzYq, castDevice.zzYq) && zzf.zza(this.zzYs, castDevice.zzYs) && this.zzYt == castDevice.zzYt && zzf.zza(this.zzYu, castDevice.zzYu) && this.zzYv == castDevice.zzYv && this.zzAk == castDevice.zzAk;
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return zzf.zza(this.getDeviceId(), castDevice.getDeviceId());
    }

    public int hashCode() {
        return this.zzYn == null ? 0 : this.zzYn.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzYn.startsWith("__cast_nearby__");
    }
}

