/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzl zzYy = new zzl("CastRemoteDisplayLocalService");
    private static final int zzYz = R.id.cast_notification_id;
    private static final Object zzYA = new Object();
    private static AtomicBoolean zzYB = new AtomicBoolean(false);
    private GoogleApiClient zzYC;
    private CastRemoteDisplay.CastRemoteDisplaySessionCallbacks zzYD;
    private String zzXW;
    private Callbacks zzYE;
    private zzb zzYF;
    private NotificationSettings zzYG;
    private Notification mNotification;
    private boolean zzYH;
    private PendingIntent zzYI;
    private CastDevice zzYJ;
    private Display zzYK;
    private Context zzYL;
    private ServiceConnection zzYM;
    private Handler mHandler;
    private MediaRouter zzYN;
    private boolean zzYO = false;
    private final MediaRouter.Callback zzYP = new MediaRouter.Callback(){

        public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo info) {
            CastRemoteDisplayLocalService.this.zzbb("onRouteUnselected");
            if (CastRemoteDisplayLocalService.this.zzYJ == null) {
                CastRemoteDisplayLocalService.this.zzbb("onRouteUnselected, no device was selected");
                return;
            }
            CastDevice castDevice = CastDevice.getFromBundle(info.getExtras());
            if (!castDevice.getDeviceId().equals(CastRemoteDisplayLocalService.this.zzYJ.getDeviceId())) {
                CastRemoteDisplayLocalService.this.zzbb("onRouteUnselected, device does not match");
                return;
            }
            CastRemoteDisplayLocalService.stopService();
        }
    };
    private static CastRemoteDisplayLocalService zzYQ;
    private final IBinder zzYR = new zza();

    public IBinder onBind(Intent intent) {
        this.zzbb("onBind");
        return this.zzYR;
    }

    public void onCreate() {
        this.zzbb("onCreate");
        super.onCreate();
        this.mHandler = new Handler(this.getMainLooper());
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CastRemoteDisplayLocalService.this.zzbb("onCreate after delay. The local service been started: " + CastRemoteDisplayLocalService.this.zzYO);
                if (!CastRemoteDisplayLocalService.this.zzYO) {
                    CastRemoteDisplayLocalService.this.zzbe("The local service has not been been started, stopping it");
                    CastRemoteDisplayLocalService.this.stopSelf();
                }
            }
        }, 100L);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.zzbb("onStartCommand");
        this.zzYO = true;
        return 2;
    }

    protected static void setDebugEnabled() {
        zzYy.zzY(true);
    }

    protected Display getDisplay() {
        return this.zzYK;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzYA;
        synchronized (object) {
            return zzYQ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startService(final Context activityContext, Class<? extends CastRemoteDisplayLocalService> serviceClass, final String applicationId, final CastDevice device, final NotificationSettings notificationSettings, final Callbacks callbacks) {
        zzYy.zzb("Starting Service", new Object[0]);
        Object object = zzYA;
        synchronized (object) {
            if (zzYQ != null) {
                zzYy.zzf("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzS(true);
            }
        }
        CastRemoteDisplayLocalService.zzb(activityContext, serviceClass);
        zzx.zzb((Object)activityContext, (Object)"activityContext is required.");
        zzx.zzb(serviceClass, (Object)"serviceClass is required.");
        zzx.zzb((Object)applicationId, (Object)"applicationId is required.");
        zzx.zzb((Object)device, (Object)"device is required.");
        zzx.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzx.zzb((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.zzYY == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzYB.getAndSet(true)) {
            zzYy.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(activityContext, serviceClass);
        activityContext.startService((Intent)object);
        activityContext.bindService((Intent)object, new ServiceConnection(){

            public void onServiceConnected(ComponentName className, IBinder binder) {
                CastRemoteDisplayLocalService castRemoteDisplayLocalService = ((zza)binder).zznu();
                if (castRemoteDisplayLocalService == null || !castRemoteDisplayLocalService.zza(applicationId, device, notificationSettings, activityContext, this, callbacks)) {
                    zzYy.zzc("Connected but unable to get the service instance", new Object[0]);
                    callbacks.onRemoteDisplaySessionError(new Status(2200));
                    zzYB.set(false);
                    try {
                        activityContext.unbindService((ServiceConnection)this);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzYy.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                }
            }

            public void onServiceDisconnected(ComponentName arg0) {
                zzYy.zzb("onServiceDisconnected", new Object[0]);
                callbacks.onRemoteDisplaySessionError(new Status(2201, "Service Disconnected"));
                zzYB.set(false);
                try {
                    activityContext.unbindService((ServiceConnection)this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    zzYy.zzb("No need to unbind service, already unbound", new Object[0]);
                }
            }
        }, 64);
    }

    private void zzQ(final boolean bl) {
        if (this.mHandler != null) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CastRemoteDisplayLocalService.this.zzR(bl);
                    }
                });
            } else {
                this.zzR(bl);
            }
        }
    }

    private void zzR(boolean bl) {
        this.zzbb("Stopping Service");
        zzx.zzcx((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.zzYN != null) {
            this.zzbb("Setting default route");
            this.zzYN.selectRoute(this.zzYN.getDefaultRoute());
        }
        if (this.zzYF != null) {
            this.zzbb("Unregistering notification receiver");
            this.unregisterReceiver(this.zzYF);
        }
        this.zznn();
        this.zzno();
        this.zznj();
        if (this.zzYC != null) {
            this.zzYC.disconnect();
            this.zzYC = null;
        }
        if (this.zzYL != null && this.zzYM != null) {
            try {
                this.zzYL.unbindService(this.zzYM);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzbb("No need to unbind service, already unbound");
            }
            this.zzYM = null;
            this.zzYL = null;
        }
        this.zzXW = null;
        this.zzYC = null;
        this.mNotification = null;
        this.zzYK = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzS(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zzYy.zzb("Stopping Service", new Object[0]);
        zzYB.set(false);
        Object object = zzYA;
        synchronized (object) {
            if (zzYQ == null) {
                zzYy.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzYQ;
            zzYQ = null;
        }
        castRemoteDisplayLocalService.zzQ(bl);
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzS(false);
    }

    public void updateNotificationSettings(final NotificationSettings notificationSettings) {
        zzx.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzx.zzb((Object)this.mHandler, (Object)"Service is not ready yet.");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CastRemoteDisplayLocalService.this.zza(notificationSettings);
            }
        });
    }

    private void zza(NotificationSettings notificationSettings) {
        zzx.zzcx((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (this.zzYG == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.zzYH) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzYY != null) {
                this.zzYG.zzYY = notificationSettings.zzYY;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzYZ)) {
                this.zzYG.zzYZ = notificationSettings.zzYZ;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzZa)) {
                this.zzYG.zzZa = notificationSettings.zzZa;
            }
            this.mNotification = this.zzT(true);
        } else {
            zzx.zzb((Object)notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.zzYG.mNotification = this.mNotification;
        }
        this.startForeground(zzYz, this.mNotification);
    }

    private static void zzb(Context context, Class clazz) {
        try {
            ComponentName componentName = new ComponentName(context, clazz);
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
    }

    private void zza(Display display) {
        this.zzYK = display;
        if (this.zzYH) {
            this.mNotification = this.zzT(true);
            this.startForeground(zzYz, this.mNotification);
        }
        if (this.zzYE != null) {
            this.zzYE.onRemoteDisplaySessionStarted(this);
            this.zzYE = null;
        }
        this.onCreatePresentation(this.zzYK);
    }

    private void zznj() {
        if (this.zzYN != null) {
            zzx.zzcx((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            this.zzbb("removeMediaRouterCallback");
            this.zzYN.removeCallback(this.zzYP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(String string2, CastDevice castDevice, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zzbb("startRemoteDisplaySession");
        zzx.zzcx((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = zzYA;
        synchronized (object) {
            if (zzYQ != null) {
                zzYy.zzf("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            zzYQ = this;
        }
        this.zzYE = callbacks;
        this.zzXW = string2;
        this.zzYJ = castDevice;
        this.zzYL = context;
        this.zzYM = serviceConnection;
        this.zzYN = MediaRouter.getInstance((Context)this.getApplicationContext());
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zzXW)).build();
        this.zzbb("addMediaRouterCallback");
        this.zzYN.addCallback((MediaRouteSelector)object, this.zzYP, 4);
        this.zzYD = new CastRemoteDisplay.CastRemoteDisplaySessionCallbacks(){

            @Override
            public void onRemoteDisplayEnded(Status status) {
                zzYy.zzb(String.format("Cast screen has ended: %d", status.getStatusCode()), new Object[0]);
                CastRemoteDisplayLocalService.zzS(false);
            }
        };
        this.mNotification = notificationSettings.mNotification;
        this.zzYF = new zzb();
        this.registerReceiver(this.zzYF, new IntentFilter("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT"));
        this.zzYG = new NotificationSettings(notificationSettings);
        if (this.zzYG.mNotification == null) {
            this.zzYH = true;
            this.mNotification = this.zzT(false);
        } else {
            this.zzYH = false;
            this.mNotification = this.zzYG.mNotification;
        }
        this.startForeground(zzYz, this.mNotification);
        this.zzYC = this.zza(castDevice);
        this.zzYC.connect();
        if (this.zzYE != null) {
            this.zzYE.onServiceCreated(this);
        }
        return true;
    }

    private void zznk() {
        this.zzbb("startRemoteDisplay");
        if (this.zzYC == null || !this.zzYC.isConnected()) {
            zzYy.zzc("Unable to start the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.startRemoteDisplay(this.zzYC, this.zzXW).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    zzYy.zzc("Connection was not successful", new Object[0]);
                    CastRemoteDisplayLocalService.this.zznm();
                    return;
                }
                zzYy.zzb("startRemoteDisplay successful", new Object[0]);
                Object object = zzYA;
                synchronized (object) {
                    if (zzYQ == null) {
                        zzYy.zzb("Remote Display started but session already cancelled", new Object[0]);
                        CastRemoteDisplayLocalService.this.zznm();
                        return;
                    }
                }
                object = castRemoteDisplaySessionResult.getPresentationDisplay();
                if (object != null) {
                    CastRemoteDisplayLocalService.this.zza((Display)object);
                } else {
                    zzYy.zzc("Cast Remote Display session created without display", new Object[0]);
                }
                zzYB.set(false);
                if (CastRemoteDisplayLocalService.this.zzYL != null && CastRemoteDisplayLocalService.this.zzYM != null) {
                    try {
                        CastRemoteDisplayLocalService.this.zzYL.unbindService(CastRemoteDisplayLocalService.this.zzYM);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzYy.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                    CastRemoteDisplayLocalService.this.zzYM = null;
                    CastRemoteDisplayLocalService.this.zzYL = null;
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)x0);
            }
        });
    }

    private void zznl() {
        this.zzbb("stopRemoteDisplay");
        if (this.zzYC == null || !this.zzYC.isConnected()) {
            zzYy.zzc("Unable to stop the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.stopRemoteDisplay(this.zzYC).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    CastRemoteDisplayLocalService.this.zzbb("Unable to stop the remote display, result unsuccessful");
                } else {
                    CastRemoteDisplayLocalService.this.zzbb("remote display stopped");
                }
                CastRemoteDisplayLocalService.this.zzYK = null;
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)x0);
            }
        });
    }

    private void zznm() {
        if (this.zzYE != null) {
            this.zzYE.onRemoteDisplaySessionError(new Status(2200));
            this.zzYE = null;
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private void zznn() {
        this.zzbb("stopRemoteDisplaySession");
        this.zznl();
        this.onDismissPresentation();
    }

    private void zzno() {
        this.zzbb("Stopping the remote display Service");
        this.stopForeground(true);
        this.stopSelf();
    }

    private GoogleApiClient zza(CastDevice castDevice) {
        CastRemoteDisplay.CastRemoteDisplayOptions.Builder builder = new CastRemoteDisplay.CastRemoteDisplayOptions.Builder(castDevice, this.zzYD);
        GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(Bundle bundle) {
                CastRemoteDisplayLocalService.this.zzbb("onConnected");
                CastRemoteDisplayLocalService.this.zznk();
            }

            public void onConnectionSuspended(int cause) {
                zzYy.zzf(String.format("[Instance: %s] ConnectionSuspended %d", this, cause), new Object[0]);
            }
        };
        GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

            public void onConnectionFailed(ConnectionResult connectionResult) {
                CastRemoteDisplayLocalService.this.zzbe("Connection failed: " + connectionResult);
                CastRemoteDisplayLocalService.this.zznm();
            }
        };
        return new GoogleApiClient.Builder((Context)this, connectionCallbacks, onConnectionFailedListener).addApi(CastRemoteDisplay.API, (Api.ApiOptions.HasOptions)builder.build()).build();
    }

    private PendingIntent zznp() {
        if (this.zzYI == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            this.zzYI = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0x10000000);
        }
        return this.zzYI;
    }

    private Notification zzT(boolean bl) {
        int n;
        int n2;
        this.zzbb("createDefaultNotification");
        int n3 = this.getApplicationInfo().labelRes;
        String string2 = this.zzYG.zzYZ;
        String string3 = this.zzYG.zzZa;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? this.getString(n3) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzYJ.getFriendlyName()}) : string3;
        Notification notification = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzYG.zzYY).setSmallIcon(n).setOngoing(true).addAction(17301560, (CharSequence)this.getString(R.string.cast_notification_disconnect), this.zznp()).build();
        return notification;
    }

    private void zzbb(String string2) {
        zzYy.zzb("[Instance: %s] %s", new Object[]{this, string2});
    }

    private void zzbe(String string2) {
        zzYy.zzc("[Instance: %s] %s", new Object[]{this, string2});
    }

    private class zza
    extends Binder {
        private zza() {
        }

        CastRemoteDisplayLocalService zznu() {
            return CastRemoteDisplayLocalService.this;
        }
    }

    private static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                zzYy.zzb("disconnecting", new Object[0]);
                CastRemoteDisplayLocalService.stopService();
            }
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent zzYY;
        private String zzYZ;
        private String zzZa;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings newSettings) {
            this.mNotification = newSettings.mNotification;
            this.zzYY = newSettings.zzYY;
            this.zzYZ = newSettings.zzYZ;
            this.zzZa = newSettings.zzZa;
        }

        public static final class Builder {
            private NotificationSettings zzZb = new NotificationSettings();

            public Builder setNotification(Notification notification) {
                this.zzZb.mNotification = notification;
                return this;
            }

            public Builder setNotificationPendingIntent(PendingIntent notificationPendingIntent) {
                this.zzZb.zzYY = notificationPendingIntent;
                return this;
            }

            public Builder setNotificationTitle(String notificationTitle) {
                this.zzZb.zzYZ = notificationTitle;
                return this;
            }

            public Builder setNotificationText(String notificationText) {
                this.zzZb.zzZa = notificationText;
                return this;
            }

            public NotificationSettings build() {
                if (this.zzZb.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zzZb.zzYZ)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zzZb.zzZa)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zzZb.zzYY != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zzZb.zzYZ) && TextUtils.isEmpty((CharSequence)this.zzZb.zzZa) && this.zzZb.zzYY == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zzZb;
            }
        }
    }

    public static interface Callbacks {
        public void onServiceCreated(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);
    }
}

