/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zznu;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    private MediaInfo zzZw;
    private int zzZx = 0;
    private boolean zzZy = true;
    private double zzZz;
    private double zzZA = Double.POSITIVE_INFINITY;
    private double zzZB;
    private long[] zzZC;
    private JSONObject zzZn;

    private MediaQueueItem(MediaInfo media) throws IllegalArgumentException {
        if (media == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzZw = media;
    }

    MediaQueueItem(JSONObject json) throws JSONException {
        this.zzg(json);
    }

    private MediaQueueItem(MediaQueueItem item) throws IllegalArgumentException {
        this.zzZw = item.getMedia();
        if (this.zzZw == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzZx = item.getItemId();
        this.zzZy = item.getAutoplay();
        this.zzZz = item.getStartTime();
        this.zzZA = item.getPlaybackDuration();
        this.zzZB = item.getPreloadTime();
        this.zzZC = item.getActiveTrackIds();
        this.zzZn = item.getCustomData();
    }

    public boolean zzg(JSONObject jSONObject) throws JSONException {
        double d;
        double d2;
        double d3;
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzZw = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzZx != (n = jSONObject.getInt("itemId"))) {
            this.zzZx = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzZy != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzZy = n;
            bl = true;
        }
        if (jSONObject.has("startTime") && Math.abs((d3 = jSONObject.getDouble("startTime")) - this.zzZz) > 1.0E-7) {
            this.zzZz = d3;
            bl = true;
        }
        if (jSONObject.has("playbackDuration") && Math.abs((d2 = jSONObject.getDouble("playbackDuration")) - this.zzZA) > 1.0E-7) {
            this.zzZA = d2;
            bl = true;
        }
        if (jSONObject.has("preloadTime") && Math.abs((d = jSONObject.getDouble("preloadTime")) - this.zzZB) > 1.0E-7) {
            this.zzZB = d;
            bl = true;
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzZC == null) {
                bl2 = true;
            } else if (this.zzZC.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzZC[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzZC = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzZn = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zzZw;
    }

    public int getItemId() {
        return this.zzZx;
    }

    void zzba(int n) {
        this.zzZx = n;
    }

    public boolean getAutoplay() {
        return this.zzZy;
    }

    void zzV(boolean bl) {
        this.zzZy = bl;
    }

    public double getStartTime() {
        return this.zzZz;
    }

    void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzZz = d;
    }

    public double getPlaybackDuration() {
        return this.zzZA;
    }

    void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.zzZA = d;
    }

    public double getPreloadTime() {
        return this.zzZB;
    }

    void zze(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzZB = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzZC;
    }

    void zza(long[] lArray) {
        this.zzZC = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzZn;
    }

    void setCustomData(JSONObject customData) {
        this.zzZn = customData;
    }

    void zznv() throws IllegalArgumentException {
        if (this.zzZw == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzZz) || this.zzZz < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzZA)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzZB) || this.zzZB < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzZw.toJson());
            if (this.zzZx != 0) {
                jSONObject.put("itemId", this.zzZx);
            }
            jSONObject.put("autoplay", this.zzZy);
            jSONObject.put("startTime", this.zzZz);
            if (this.zzZA != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzZA);
            }
            jSONObject.put("preloadTime", this.zzZB);
            if (this.zzZC != null) {
                JSONArray jSONArray = new JSONArray();
                for (long l : this.zzZC) {
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzZn != null) {
                jSONObject.put("customData", (Object)this.zzZn);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)other;
        if (this.zzZn == null != (mediaQueueItem.zzZn == null)) {
            return false;
        }
        if (this.zzZn != null && mediaQueueItem.zzZn != null && !zznu.zze((Object)this.zzZn, (Object)mediaQueueItem.zzZn)) {
            return false;
        }
        return zzf.zza(this.zzZw, mediaQueueItem.zzZw) && this.zzZx == mediaQueueItem.zzZx && this.zzZy == mediaQueueItem.zzZy && this.zzZz == mediaQueueItem.zzZz && this.zzZA == mediaQueueItem.zzZA && this.zzZB == mediaQueueItem.zzZB && zzf.zza(this.zzZC, mediaQueueItem.zzZC);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzZw, this.zzZx, this.zzZy, this.zzZz, this.zzZA, this.zzZB, this.zzZC, String.valueOf(this.zzZn)});
    }

    public static class Builder {
        private final MediaQueueItem zzZD;

        public Builder(MediaInfo media) throws IllegalArgumentException {
            this.zzZD = new MediaQueueItem(media);
        }

        public Builder(JSONObject json) throws JSONException {
            this.zzZD = new MediaQueueItem(json);
        }

        public Builder(MediaQueueItem item) throws IllegalArgumentException {
            this.zzZD = new MediaQueueItem(item);
        }

        public Builder clearItemId() {
            this.zzZD.zzba(0);
            return this;
        }

        public Builder setAutoplay(boolean autoplay) {
            this.zzZD.zzV(autoplay);
            return this;
        }

        public Builder setStartTime(double startTime) throws IllegalArgumentException {
            this.zzZD.zzc(startTime);
            return this;
        }

        public Builder setPlaybackDuration(double playbackDuration) {
            this.zzZD.zzd(playbackDuration);
            return this;
        }

        public Builder setPreloadTime(double preloadTime) throws IllegalArgumentException {
            this.zzZD.zze(preloadTime);
            return this;
        }

        public Builder setActiveTrackIds(long[] activeTrackIds) {
            this.zzZD.zza(activeTrackIds);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzZD.setCustomData(customData);
            return this;
        }

        public MediaQueueItem build() {
            this.zzZD.zznv();
            return this.zzZD;
        }
    }
}

