/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zznu;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    private long zzTC;
    private int zzZU;
    private String zzZg;
    private String zzZi;
    private String mName;
    private String zzZe;
    private int zzZV;
    private JSONObject zzZn;

    MediaTrack(JSONObject json) throws JSONException {
        this.zzf(json);
    }

    MediaTrack(long id2, int type) throws IllegalArgumentException {
        this.clear();
        this.zzTC = id2;
        if (type <= 0 || type > 3) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.zzZU = type;
    }

    public long getId() {
        return this.zzTC;
    }

    public int getType() {
        return this.zzZU;
    }

    public String getContentId() {
        return this.zzZg;
    }

    public void setContentId(String contentId) {
        this.zzZg = contentId;
    }

    public String getContentType() {
        return this.zzZi;
    }

    public void setContentType(String contentType) {
        this.zzZi = contentType;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getLanguage() {
        return this.zzZe;
    }

    void setLanguage(String language) {
        this.zzZe = language;
    }

    public int getSubtype() {
        return this.zzZV;
    }

    void zzbe(int n) throws IllegalArgumentException {
        if (n <= -1 || n > 5) {
            throw new IllegalArgumentException("invalid subtype " + n);
        }
        if (n != 0 && this.zzZU != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzZV = n;
    }

    public JSONObject getCustomData() {
        return this.zzZn;
    }

    void setCustomData(JSONObject customData) {
        this.zzZn = customData;
    }

    private void clear() {
        this.zzTC = 0L;
        this.zzZU = 0;
        this.zzZg = null;
        this.mName = null;
        this.zzZe = null;
        this.zzZV = -1;
        this.zzZn = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zzf(JSONObject jSONObject) throws JSONException {
        this.clear();
        this.zzTC = jSONObject.getLong("trackId");
        String string2 = jSONObject.getString("type");
        if ("TEXT".equals(string2)) {
            this.zzZU = 1;
        } else if ("AUDIO".equals(string2)) {
            this.zzZU = 2;
        } else {
            if (!"VIDEO".equals(string2)) throw new JSONException("invalid type: " + string2);
            this.zzZU = 3;
        }
        this.zzZg = jSONObject.optString("trackContentId", null);
        this.zzZi = jSONObject.optString("trackContentType", null);
        this.mName = jSONObject.optString("name", null);
        this.zzZe = jSONObject.optString("language", null);
        if (jSONObject.has("subtype")) {
            string2 = jSONObject.getString("subtype");
            if ("SUBTITLES".equals(string2)) {
                this.zzZV = 1;
            } else if ("CAPTIONS".equals(string2)) {
                this.zzZV = 2;
            } else if ("DESCRIPTIONS".equals(string2)) {
                this.zzZV = 3;
            } else if ("CHAPTERS".equals(string2)) {
                this.zzZV = 4;
            } else {
                if (!"METADATA".equals(string2)) throw new JSONException("invalid subtype: " + string2);
                this.zzZV = 5;
            }
        } else {
            this.zzZV = 0;
        }
        this.zzZn = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzTC);
            switch (this.zzZU) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.zzZg != null) {
                jSONObject.put("trackContentId", (Object)this.zzZg);
            }
            if (this.zzZi != null) {
                jSONObject.put("trackContentType", (Object)this.zzZi);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzZe)) {
                jSONObject.put("language", (Object)this.zzZe);
            }
            switch (this.zzZV) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.zzZn != null) {
                jSONObject.put("customData", (Object)this.zzZn);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)other;
        if (this.zzZn == null != (mediaTrack.zzZn == null)) {
            return false;
        }
        if (this.zzZn != null && mediaTrack.zzZn != null && !zznu.zze((Object)this.zzZn, (Object)mediaTrack.zzZn)) {
            return false;
        }
        return this.zzTC == mediaTrack.zzTC && this.zzZU == mediaTrack.zzZU && zzf.zza(this.zzZg, mediaTrack.zzZg) && zzf.zza(this.zzZi, mediaTrack.zzZi) && zzf.zza(this.mName, mediaTrack.mName) && zzf.zza(this.zzZe, mediaTrack.zzZe) && this.zzZV == mediaTrack.zzZV;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzTC, this.zzZU, this.zzZg, this.zzZi, this.mName, this.zzZe, this.zzZV, this.zzZn});
    }

    public static class Builder {
        private final MediaTrack zzZW;

        public Builder(long trackId, int trackType) throws IllegalArgumentException {
            this.zzZW = new MediaTrack(trackId, trackType);
        }

        public Builder setContentId(String contentId) {
            this.zzZW.setContentId(contentId);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.zzZW.setContentType(contentType);
            return this;
        }

        public Builder setName(String trackName) {
            this.zzZW.setName(trackName);
            return this;
        }

        public Builder setLanguage(String language) {
            this.zzZW.setLanguage(language);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzZW.setLanguage(zzf.zzb(locale));
            return this;
        }

        public Builder setSubtype(int subtype) throws IllegalArgumentException {
            this.zzZW.zzbe(subtype);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzZW.setCustomData(customData);
            return this;
        }

        public MediaTrack build() {
            return this.zzZW;
        }
    }
}

