/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.JoinOptions;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.ApplicationStatus;
import com.google.android.gms.cast.internal.DeviceStatus;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzi;
import com.google.android.gms.cast.internal.zzj;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.internal.zzlx;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zze
extends zzj<zzi> {
    private static final zzl zzYy = new zzl("CastClientImpl");
    private ApplicationMetadata zzabQ;
    private final CastDevice zzabR;
    private final Cast.Listener zzYj;
    private final Map<String, Cast.MessageReceivedCallback> zzabS;
    private final long zzabT;
    private zzb zzabU;
    private String zzabV;
    private boolean zzZM;
    private boolean zzabW;
    private boolean zzabX;
    private boolean zzabY;
    private double zzZL;
    private int zzabZ;
    private int zzaca;
    private final AtomicLong zzacb;
    private String zzacc;
    private String zzacd;
    private Bundle zzace;
    private final Map<Long, zzlx.zzb<Status>> zzacf;
    private zzlx.zzb<Cast.ApplicationConnectionResult> zzacg;
    private zzlx.zzb<Status> zzach;
    private static final Object zzaci = new Object();
    private static final Object zzacj = new Object();

    public zze(Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, CastDevice castDevice, long l, Cast.Listener listener, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.zzabR = castDevice;
        this.zzYj = listener;
        this.zzabT = l;
        this.zzabS = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzacb = new AtomicLong(0L);
        this.zzacf = new HashMap<Long, zzlx.zzb<Status>>();
        this.zznP();
    }

    private void zznP() {
        this.zzabY = false;
        this.zzabZ = -1;
        this.zzaca = -1;
        this.zzabQ = null;
        this.zzabV = null;
        this.zzZL = 0.0;
        this.zzZM = false;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzYy.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzabY = true;
            this.zzabW = true;
            this.zzabX = true;
        } else {
            this.zzabY = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzace = new Bundle();
            this.zzace.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzYy.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzabU, this.isConnected());
        zzb zzb2 = this.zzabU;
        this.zzabU = null;
        if (zzb2 == null || zzb2.zzoa() == null) {
            zzYy.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zznV();
        try {
            ((zzi)this.zzqs()).disconnect();
        }
        catch (RemoteException | IllegalStateException throwable) {
            zzYy.zzb(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
        }
        finally {
            super.disconnect();
        }
    }

    public Bundle zznQ() {
        if (this.zzace != null) {
            Bundle bundle = this.zzace;
            this.zzace = null;
            return bundle;
        }
        return super.zznQ();
    }

    protected String zzgh() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    protected String zzgi() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected zzi zzaE(IBinder iBinder) {
        return zzi.zza.zzaF(iBinder);
    }

    protected Bundle zzlU() {
        Bundle bundle = new Bundle();
        zzYy.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzacc, this.zzacd);
        this.zzabR.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzabT);
        this.zzabU = new zzb(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzabU.asBinder()));
        if (this.zzacc != null) {
            bundle.putString("last_application_id", this.zzacc);
            if (this.zzacd != null) {
                bundle.putString("last_session_id", this.zzacd);
            }
        }
        return bundle;
    }

    public void zza(String string2, String string3, zzlx.zzb<Status> zzb2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzf.zzcb(string2);
        this.zznW();
        long l = this.zzacb.incrementAndGet();
        try {
            this.zzacf.put(l, zzb2);
            ((zzi)this.zzqs()).zzb(string2, string3, l);
        }
        catch (Throwable throwable) {
            this.zzacf.remove(l);
            throw throwable;
        }
    }

    public void zza(String string2, boolean bl, zzlx.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        ((zzi)this.zzqs()).zzf(string2, bl);
    }

    public void zza(String string2, LaunchOptions launchOptions, zzlx.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        ((zzi)this.zzqs()).zza(string2, launchOptions);
    }

    public void zza(String string2, String string3, JoinOptions joinOptions, zzlx.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        if (joinOptions == null) {
            joinOptions = new JoinOptions();
        }
        ((zzi)this.zzqs()).zza(string2, string3, joinOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzlx.zzb<Cast.ApplicationConnectionResult> zzb2) {
        Object object = zzaci;
        synchronized (object) {
            if (this.zzacg != null) {
                this.zzacg.zzr((Object)new zza(new Status(2002)));
            }
            this.zzacg = zzb2;
        }
    }

    public void zzb(zzlx.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zzqs()).zzoc();
    }

    public void zza(String string2, zzlx.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zzqs()).zzce(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(zzlx.zzb<Status> zzb2) {
        Object object = zzacj;
        synchronized (object) {
            if (this.zzach != null) {
                zzb2.zzr((Object)new Status(2001));
                return;
            }
            this.zzach = zzb2;
        }
    }

    public void zznR() throws IllegalStateException, RemoteException {
        ((zzi)this.zzqs()).zznR();
    }

    public void zzf(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        ((zzi)this.zzqs()).zza(d, this.zzZL, this.zzZM);
    }

    public void zzX(boolean bl) throws IllegalStateException, RemoteException {
        ((zzi)this.zzqs()).zza(bl, this.zzZL, this.zzZM);
    }

    public double zznS() throws IllegalStateException {
        this.zznW();
        return this.zzZL;
    }

    public boolean isMute() throws IllegalStateException {
        this.zznW();
        return this.zzZM;
    }

    public int zznT() throws IllegalStateException {
        this.zznW();
        return this.zzabZ;
    }

    public int zznU() throws IllegalStateException {
        this.zznW();
        return this.zzaca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzf.zzcb(string2);
        this.zzca(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzabS;
            synchronized (map) {
                this.zzabS.put(string2, messageReceivedCallback);
            }
            ((zzi)this.zzqs()).zzcf(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzca(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzabS;
        synchronized (map) {
            messageReceivedCallback = this.zzabS.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzi)this.zzqs()).zzcg(string2);
            }
            catch (IllegalStateException illegalStateException) {
                zzYy.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zznW();
        return this.zzabQ;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.zznW();
        return this.zzabV;
    }

    public void onConnectionFailed(ConnectionResult result) {
        super.onConnectionFailed(result);
        this.zznV();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zznV() {
        zzYy.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzabS;
        synchronized (map) {
            this.zzabS.clear();
        }
    }

    private void zza(DeviceStatus deviceStatus) {
        boolean bl;
        ApplicationMetadata applicationMetadata = deviceStatus.getApplicationMetadata();
        if (!zzf.zza(applicationMetadata, this.zzabQ)) {
            this.zzabQ = applicationMetadata;
            this.zzYj.onApplicationMetadataChanged(this.zzabQ);
        }
        boolean bl2 = false;
        double d = deviceStatus.zznS();
        if (d != Double.NaN && Math.abs(d - this.zzZL) > 1.0E-7) {
            this.zzZL = d;
            bl2 = true;
        }
        if ((bl = deviceStatus.zzob()) != this.zzZM) {
            this.zzZM = bl;
            bl2 = true;
        }
        zzYy.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzabX);
        if (this.zzYj != null && (bl2 || this.zzabX)) {
            this.zzYj.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = deviceStatus.zznT();
        if (n != this.zzabZ) {
            this.zzabZ = n;
            bl3 = true;
        }
        zzYy.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzabX);
        if (this.zzYj != null && (bl3 || this.zzabX)) {
            this.zzYj.onActiveInputStateChanged(this.zzabZ);
        }
        boolean bl4 = false;
        int n2 = deviceStatus.zznU();
        if (n2 != this.zzaca) {
            this.zzaca = n2;
            bl4 = true;
        }
        zzYy.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzabX);
        if (this.zzYj != null && (bl4 || this.zzabX)) {
            this.zzYj.onStandbyStateChanged(this.zzaca);
        }
        this.zzabX = false;
    }

    private void zza(ApplicationStatus applicationStatus) {
        boolean bl = false;
        String string2 = applicationStatus.zznM();
        if (!zzf.zza(string2, this.zzabV)) {
            this.zzabV = string2;
            bl = true;
        }
        zzYy.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzabW);
        if (this.zzYj != null && (bl || this.zzabW)) {
            this.zzYj.onApplicationStatusChanged();
        }
        this.zzabW = false;
    }

    private void zznW() throws IllegalStateException {
        if (!this.zzabY || this.zzabU == null || this.zzabU.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzaE(iBinder);
    }

    private static class zzb
    extends zzj.zza {
        private final AtomicReference<zze> zzacn;
        private final Handler mHandler;

        public zzb(zze zze2) {
            this.zzacn = new AtomicReference<zze>(zze2);
            this.mHandler = new Handler(zze2.getLooper());
        }

        public zze zzoa() {
            zze zze2 = this.zzacn.getAndSet(null);
            if (zze2 == null) {
                return null;
            }
            zze2.zznP();
            return zze2;
        }

        public boolean isDisposed() {
            return this.zzacn.get() == null;
        }

        @Override
        public void zzbk(int n) {
            zze zze2 = this.zzoa();
            if (zze2 == null) {
                return;
            }
            zzYy.zzb("ICastDeviceControllerListener.onDisconnected: %d", n);
            if (n != 0) {
                zze2.zzbT(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            zze zze2 = this.zzacn.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzabQ = applicationMetadata;
            zze2.zzacc = applicationMetadata.getApplicationId();
            zze2.zzacd = string3;
            Object object = zzaci;
            synchronized (object) {
                if (zze2.zzacg != null) {
                    zze2.zzacg.zzr((Object)new zza(new Status(0), applicationMetadata, string2, string3, bl));
                    zze2.zzacg = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbl(int n) {
            zze zze2 = this.zzacn.get();
            if (zze2 == null) {
                return;
            }
            Object object = zzaci;
            synchronized (object) {
                if (zze2.zzacg != null) {
                    zze2.zzacg.zzr((Object)new zza(new Status(n)));
                    zze2.zzacg = null;
                }
            }
        }

        @Override
        public void zzbm(int n) {
            zze zze2 = this.zzacn.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void zzbn(int n) {
            zze zze2 = this.zzacn.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void onApplicationDisconnected(final int statusCode) {
            final zze zze2 = this.zzacn.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzacc = null;
            zze2.zzacd = null;
            this.zza(zze2, statusCode);
            if (zze2.zzYj != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (zze2.zzYj != null) {
                            zze2.zzYj.onApplicationDisconnected(statusCode);
                        }
                    }
                });
            }
        }

        @Override
        public void zza(String string2, double d, boolean bl) {
            zzYy.zzb("Deprecated callback: \"onStatusreceived\"", new Object[0]);
        }

        @Override
        public void zzb(final DeviceStatus deviceStatus) {
            final zze zze2 = this.zzacn.get();
            if (zze2 == null) {
                return;
            }
            zzYy.zzb("onDeviceStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(deviceStatus);
                }
            });
        }

        @Override
        public void zzb(final ApplicationStatus applicationStatus) {
            final zze zze2 = this.zzacn.get();
            if (zze2 == null) {
                return;
            }
            zzYy.zzb("onApplicationStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(applicationStatus);
                }
            });
        }

        @Override
        public void zzu(final String string2, final String string3) {
            final zze zze2 = this.zzacn.get();
            if (zze2 == null) {
                return;
            }
            zzYy.zzb("Receive (type=text, ns=%s) %s", string2, string3);
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cast.MessageReceivedCallback messageReceivedCallback;
                    Map map = zze2.zzabS;
                    synchronized (map) {
                        messageReceivedCallback = (Cast.MessageReceivedCallback)zze2.zzabS.get(string2);
                    }
                    if (messageReceivedCallback != null) {
                        messageReceivedCallback.onMessageReceived(zze2.zzabR, string2, string3);
                    } else {
                        zzYy.zzb("Discarded message for unknown namespace '%s'", string2);
                    }
                }
            });
        }

        @Override
        public void zzb(String string2, byte[] byArray) {
            zze zze2 = this.zzacn.get();
            if (zze2 == null) {
                return;
            }
            zzYy.zzb("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string2, byArray.length);
        }

        @Override
        public void zza(String string2, long l, int n) {
            zze zze2 = this.zzacn.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, n);
        }

        @Override
        public void zzc(String string2, long l) {
            zze zze2 = this.zzacn.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(zze zze2, long l, int n) {
            zzlx.zzb zzb2;
            Map map = zze2.zzacf;
            synchronized (map) {
                zzb2 = (zzlx.zzb)zze2.zzacf.remove(l);
            }
            if (zzb2 != null) {
                zzb2.zzr((Object)new Status(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(zze zze2, int n) {
            Object object = zzacj;
            synchronized (object) {
                if (zze2.zzach != null) {
                    zze2.zzach.zzr((Object)new Status(n));
                    zze2.zzach = null;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class zza
    implements Cast.ApplicationConnectionResult {
        private final Status zzTA;
        private final ApplicationMetadata zzack;
        private final String zzacl;
        private final String zzJX;
        private final boolean zzacm;

        public zza(Status status, ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            this.zzTA = status;
            this.zzack = applicationMetadata;
            this.zzacl = string2;
            this.zzJX = string3;
            this.zzacm = bl;
        }

        public zza(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public ApplicationMetadata getApplicationMetadata() {
            return this.zzack;
        }

        @Override
        public String getApplicationStatus() {
            return this.zzacl;
        }

        @Override
        public String getSessionId() {
            return this.zzJX;
        }

        @Override
        public boolean getWasLaunched() {
            return this.zzacm;
        }
    }
}

