/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzlh;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzlj;
import com.google.android.gms.internal.zzlk;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzlx;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class zzlg
extends com.google.android.gms.cast.internal.zzc {
    static final String NAMESPACE = zzf.zzcc("com.google.cast.games");
    private static final zzl zzYy = new zzl("GameManagerChannel");
    private final Map<String, String> zzaaS = new ConcurrentHashMap<String, String>();
    private final List<zzp> zzaaT;
    private final SharedPreferences zzvc;
    private final String zzaaU;
    private final Cast.CastApi zzaaV;
    private final GoogleApiClient zzaaW;
    private zzlh zzaaX;
    private boolean zzaaY = false;
    private GameManagerState zzaaZ;
    private GameManagerState zzaba;
    private String zzabb;
    private JSONObject zzabc;
    private long zzabd = 0L;
    private GameManagerClient.Listener zzabe;
    private String zzabf;

    public zzlg(GoogleApiClient googleApiClient, String string, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzaaT = new ArrayList<zzp>();
        this.zzaaU = string;
        this.zzaaV = castApi;
        this.zzaaW = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string2 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzvc = context.getApplicationContext().getSharedPreferences(string2, 0);
        this.zzaba = null;
        this.zzaaZ = new zzlk(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        if (gameManagerClient == null) {
            throw new IllegalArgumentException("gameManagerClient can't be null.");
        }
        return this.zzaaW.zzb((zzlx.zza)new zzc(gameManagerClient){

            @Override
            public void execute() {
                try {
                    zzlg.this.zzaaV.setMessageReceivedCallbacks(zzlg.this.zzaaW, zzlg.this.getNamespace(), new Cast.MessageReceivedCallback(){

                        @Override
                        public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
                            zzlg.this.zzbZ(message);
                        }
                    });
                }
                catch (IOException | IllegalStateException exception) {
                    this.zznE().zza(-1L, 8, null);
                    return;
                }
                zzlg.this.zznC();
                zzlg.this.zznB();
                zzlg.this.zza(null, 1100, null, this.zznE());
            }
        });
    }

    public synchronized void dispose() throws IllegalStateException {
        if (this.zzaaY) {
            return;
        }
        this.zzaaZ = null;
        this.zzaba = null;
        this.zzabb = null;
        this.zzabc = null;
        this.zzaaY = true;
        try {
            this.zzaaV.removeMessageReceivedCallbacks(this.zzaaW, this.getNamespace());
        }
        catch (IOException iOException) {
            zzYy.zzf("Exception while detaching game manager channel.", iOException);
        }
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> zza(final String string, final int n, final JSONObject jSONObject) throws IllegalStateException {
        this.zznz();
        return this.zzaaW.zzb((zzlx.zza)new zza(){

            @Override
            public void execute() {
                int n2 = zzlj.zzbh(n);
                if (n2 == 0) {
                    this.zznE().zza(-1L, 2001, null);
                    zzYy.zzf("sendPlayerRequest for unsupported playerState: %d", n);
                    return;
                }
                zzlg.this.zza(string, n2, jSONObject, this.zznE());
            }
        });
    }

    public synchronized void sendGameMessage(String playerId, JSONObject extraMessageData) throws IllegalStateException {
        this.zznz();
        long l = ++this.zzabd;
        JSONObject jSONObject = this.zza(l, playerId, 7, extraMessageData);
        if (jSONObject == null) {
            return;
        }
        this.zzaaV.sendMessage(this.zzaaW, this.getNamespace(), jSONObject.toString());
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(final String playerId, final JSONObject extraMessageData) throws IllegalStateException {
        this.zznz();
        return this.zzaaW.zzb((zzlx.zza)new zza(){

            @Override
            public void execute() {
                zzlg.this.zza(playerId, 6, extraMessageData, this.zznE());
            }
        });
    }

    public synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zznz();
        return this.zzaaZ;
    }

    public synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zznz();
        return this.zzabf;
    }

    public synchronized String zzbY(String string) throws IllegalStateException {
        return string == null ? null : this.zzaaS.get(string);
    }

    public synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzabe = listener;
    }

    @Override
    public final void zzbZ(String string) {
        boolean bl;
        zzli zzli2;
        zzYy.zzb("message received: %s", string);
        try {
            JSONObject jSONObject = new JSONObject(string);
            zzli2 = zzli.zzh(jSONObject);
        }
        catch (JSONException jSONException) {
            zzYy.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string);
            return;
        }
        if (zzli2 == null) {
            zzYy.zzf("Could not parse game manager message from string: %s", string);
            return;
        }
        if (!this.isInitialized() && zzli2.zznL() == null || this.isDisposed()) {
            return;
        }
        boolean bl2 = bl = zzli2.zznG() == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzli2.zznK())) {
            this.zzaaS.put(zzli2.getPlayerId(), zzli2.zznK());
            this.zznB();
        }
        if (zzli2.getStatusCode() == 0) {
            this.zza(zzli2);
        } else {
            zzYy.zzf("Not updating from game message because the message contains error code: %d", zzli2.getStatusCode());
        }
        int n = this.zzbg(zzli2.getStatusCode());
        if (bl) {
            this.zzb(zzli2.getRequestId(), n, zzli2);
        }
        if (this.isInitialized() && n == 0) {
            this.zznA();
        }
    }

    public synchronized boolean isDisposed() {
        return this.zzaaY;
    }

    public synchronized boolean isInitialized() {
        return this.zzaaX != null;
    }

    @Override
    public void zzb(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzz(long l) {
        Iterator<zzp> iterator = this.zzaaT.iterator();
        while (iterator.hasNext()) {
            zzp zzp2 = iterator.next();
            if (!zzp2.zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzp.zzacU;
        synchronized (object) {
            for (zzp zzp3 : this.zzaaT) {
                if (!zzp3.zzoi()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int zzbg(int n) {
        switch (n) {
            case 4: {
                return 2151;
            }
            case 3: {
                return 2150;
            }
            case 2: {
                return 2003;
            }
            case 1: {
                return 2001;
            }
            case 0: {
                return 0;
            }
        }
        zzYy.zzf("Unknown GameManager protocol status code: " + n, new Object[0]);
        return 13;
    }

    private synchronized void zznz() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private void zza(String string, int n, JSONObject jSONObject, zzo zzo2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzabd, string, n, jSONObject)) == null) {
            zzo2.zza(-1L, 2001, null);
            zzYy.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzp zzp2 = new zzp(30000L);
        zzp2.zza(l, zzo2);
        this.zzaaT.add(zzp2);
        this.zzW(true);
        this.zzaaV.sendMessage(this.zzaaW, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzp(Status status) {
                if (!status.isSuccess()) {
                    zzlg.this.zzb(l, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zzp((Status)x0);
            }
        });
    }

    private JSONObject zza(long l, String string, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string);
            jSONObject2.put("playerToken", (Object)this.zzbY(string));
        }
        catch (JSONException jSONException) {
            zzYy.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private synchronized void zza(zzli zzli2) {
        boolean bl = zzli2.zznG() == 1;
        this.zzaba = this.zzaaZ;
        if (bl && zzli2.zznL() != null) {
            this.zzaaX = zzli2.zznL();
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzlm zzlm2 : zzli2.zznI()) {
            String string = zzlm2.getPlayerId();
            zzll zzll2 = new zzll(string, zzlm2.getPlayerState(), zzlm2.getPlayerData(), this.zzaaS.containsKey(string));
            arrayList.add(zzll2);
        }
        this.zzaaZ = new zzlk(zzli2.getLobbyState(), zzli2.getGameplayState(), zzli2.zznJ(), zzli2.getGameData(), arrayList, this.zzaaX.zznF(), this.zzaaX.getMaxPlayers());
        PlayerInfo playerInfo = this.zzaaZ.getPlayer(zzli2.getPlayerId());
        if (playerInfo != null && playerInfo.isControllable() && zzli2.zznG() == 2) {
            this.zzabb = zzli2.getPlayerId();
            this.zzabc = zzli2.getExtraMessageData();
        }
    }

    private void zznA() {
        if (this.zzabe != null) {
            if (this.zzaba != null && !this.zzaaZ.equals(this.zzaba)) {
                this.zzabe.onStateChanged(this.zzaaZ, this.zzaba);
            }
            if (this.zzabc != null && this.zzabb != null) {
                this.zzabe.onGameMessageReceived(this.zzabb, this.zzabc);
            }
        }
        this.zzaba = null;
        this.zzabb = null;
        this.zzabc = null;
    }

    private void zzb(long l, int n, Object object) {
        Iterator<zzp> iterator = this.zzaaT.iterator();
        while (iterator.hasNext()) {
            zzp zzp2 = iterator.next();
            if (!zzp2.zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private synchronized void zznB() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzaaU);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzaaS));
            this.zzvc.edit().putString("save_data", jSONObject.toString()).commit();
        }
        catch (JSONException jSONException) {
            zzYy.zzf("Error while saving data: %s", jSONException.getMessage());
        }
    }

    private synchronized void zznC() {
        String string = this.zzvc.getString("save_data", null);
        if (string == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.getString("castSessionId");
            if (this.zzaaU.equals(string2)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    this.zzaaS.put(string3, jSONObject2.getString(string3));
                }
                this.zzabd = 0L;
            }
        }
        catch (JSONException jSONException) {
            zzYy.zzf("Error while loading data: %s", jSONException.getMessage());
        }
    }

    public abstract class zza
    extends zzb<GameManagerClient.GameManagerResult> {
        public zza() {
            this.zzaaF = new zzo(){

                @Override
                public void zzy(long l) {
                    zza.this.zzb(zza.this.zzr(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zza.this.zzb(new zze(new Status(n, null, null), null, l, null));
                            return;
                        }
                        zzli zzli2 = (zzli)object;
                        String string = zzli2.getPlayerId();
                        if (n == 0 && string != null) {
                            zzlg.this.zzabf = string;
                        }
                        zza.this.zzb(new zze(new Status(n, zzli2.zznH(), null), string, zzli2.getRequestId(), zzli2.getExtraMessageData()));
                    }
                    catch (ClassCastException classCastException) {
                        zza.this.zzb(zza.this.zzr(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerResult zzr(Status status) {
            return new zze(status, null, -1L, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzr(status);
        }
    }

    public abstract class zzc
    extends zzb<GameManagerClient.GameManagerInstanceResult> {
        private GameManagerClient zzabo;

        public zzc(GameManagerClient gameManagerClient) {
            this.zzabo = gameManagerClient;
            this.zzaaF = new zzo(){

                @Override
                public void zzy(long l) {
                    zzc.this.zzb(zzc.this.zzs(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zzc.this.zzb(new zzd(new Status(n, null, null), zzc.this.zzabo));
                            return;
                        }
                        zzli zzli2 = (zzli)object;
                        zzlh zzlh2 = zzli2.zznL();
                        if (zzlh2 != null && !zzf.zza("1.0.0", zzlh2.getVersion())) {
                            zzc.this.zzb(zzc.this.zzs(new Status(2150, String.format(Locale.ROOT, "Incorrect Game Manager SDK version. Receiver: %s Sender: %s", zzlh2.getVersion(), "1.0.0"))));
                            zzlg.this.zzaaX = null;
                            return;
                        }
                        zzc.this.zzb(new zzd(new Status(n, zzli2.zznH(), null), zzc.this.zzabo));
                    }
                    catch (ClassCastException classCastException) {
                        zzc.this.zzb(zzc.this.zzs(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerInstanceResult zzs(Status status) {
            return new zzd(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzs(status);
        }
    }

    public abstract class zzb<R extends Result>
    extends com.google.android.gms.cast.internal.zzb<R> {
        protected zzo zzaaF;

        public zzb() {
            super(zzlg.this.zzaaW);
        }

        protected void zza(com.google.android.gms.cast.internal.zze zze2) {
            this.execute();
        }

        public zzo zznE() {
            return this.zzaaF;
        }

        public abstract void execute();
    }

    private static final class zze
    implements GameManagerClient.GameManagerResult {
        private final Status zzTA;
        private final String zzabq;
        private final long zzabr;
        private final JSONObject zzabs;

        zze(Status status, String string, long l, JSONObject jSONObject) {
            this.zzTA = status;
            this.zzabq = string;
            this.zzabr = l;
            this.zzabs = jSONObject;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public String getPlayerId() {
            return this.zzabq;
        }

        @Override
        public long getRequestId() {
            return this.zzabr;
        }

        @Override
        public JSONObject getExtraMessageData() {
            return this.zzabs;
        }
    }

    private static final class zzd
    implements GameManagerClient.GameManagerInstanceResult {
        private final Status zzTA;
        private final GameManagerClient zzabo;

        zzd(Status status, GameManagerClient gameManagerClient) {
            this.zzTA = status;
            this.zzabo = gameManagerClient;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public GameManagerClient getGameManagerClient() {
            return this.zzabo;
        }
    }
}

